/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.jbackpack.RdiffBackupRestore;
import ch.fhnw.jbackpack.chooser.DatabaseSyncDialog;
import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.jbackpack.chooser.IncrementsListCellRenderer;
import ch.fhnw.jbackpack.chooser.NoHiddenFilesSwingFileFilter;
import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.jbackpack.chooser.RdiffFileDatabase;
import ch.fhnw.jbackpack.chooser.RdiffFileSystemView;
import ch.fhnw.jbackpack.chooser.RdiffFileView;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class RdiffChooserPanel
extends JPanel
implements PropertyChangeListener {
    public static final String CHECK_RUNNING_PROPERTY = "checkRunning";
    public static final String DIRECTORY_SELECTABLE_PROPERTY = "directorySelectable";
    private static final Logger LOGGER = Logger.getLogger(RdiffChooserPanel.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final ProcessExecutor processExecutor = new ProcessExecutor();
    private final CardLayout cardLayout;
    private final CardLayout filesCardLayout;
    private final IncrementModel incrementModel = new IncrementModel();
    private final RdiffFileSystemView rdiffFileSystemView = new RdiffFileSystemView();
    private final FileFilter noHiddenFilesSwingFilter = NoHiddenFilesSwingFileFilter.getInstance();
    private final Desktop desktop;
    private final boolean desktopIsSupported;
    private List<Increment> increments = new ArrayList<Increment>();
    private Window parentWindow;
    private String selectedDirectory;
    private File[] oldSelectedFiles;
    private RdiffFileDatabase rdiffFileDatabase;
    private JRadioButton allBackupRadioButton;
    private JRadioButton backupFilesRadioButton;
    private ButtonGroup backupSelectionGroup;
    private JPanel backupSizesPanel;
    private JList backupsList;
    private JPopupMenu backupsListPopupMenu;
    private JScrollPane backupsListScrollPane;
    private JPanel backupsPanel;
    private JLabel cumulativeSizeLabel;
    private JTextField cumulativeSizeTextField;
    private JButton deleteBackupButton;
    private JMenuItem deleteMenuItem;
    private JButton downButton;
    private JPanel emptyPanel;
    private JFileChooser fileChooser;
    private JPanel filesCardPanel;
    private JPanel filesPanel;
    private JLabel noRdiffDirectoryLabel;
    private JPanel noRdiffDirectoryPanel;
    private JButton previewButton;
    private JPanel rdiffDirectoryPanel;
    private JLabel selectIncrementLabel;
    private JPanel selectIncrementPanel;
    private JLabel storageUsageLabel;
    private JProgressBar storageUsageProgressBar;
    private JLabel totalSizeLabel;
    private JTextField totalSizeTextField;
    private JButton upButton;

    public RdiffChooserPanel() {
        this.initComponents();
        this.fileChooser.addChoosableFileFilter(this.noHiddenFilesSwingFilter);
        this.fileChooser.setFileFilter(this.noHiddenFilesSwingFilter);
        this.fileChooser.setFileView(new RdiffFileView());
        this.backupsList.setModel(this.incrementModel);
        this.backupsList.setCellRenderer(new IncrementsListCellRenderer());
        this.cardLayout = (CardLayout)this.getLayout();
        this.filesCardLayout = (CardLayout)this.filesCardPanel.getLayout();
        FileChooserUI fileChooserUI = this.fileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)fileChooserUI;
            basicFileChooserUI.getModel().addPropertyChangeListener(this);
        } else {
            LOGGER.warning("can not keep file selection when switching between increments");
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("LC_ALL", "C");
        this.processExecutor.setEnvironment(environment);
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
            this.desktopIsSupported = this.desktop.isSupported(Desktop.Action.OPEN);
            if (!this.desktopIsSupported) {
                LOGGER.warning("desktop \"open\" action is not supported");
            }
        } else {
            this.desktop = null;
            this.desktopIsSupported = false;
            LOGGER.warning("desktop is not supported");
        }
        if (!this.desktopIsSupported) {
            this.previewButton.setToolTipText(BUNDLE.getString("Preview_Disabled_Tooltip"));
        }
        Dimension preferredSize = this.backupsListScrollPane.getPreferredSize();
        preferredSize.width = 280;
        this.backupsListScrollPane.setMinimumSize(preferredSize);
        this.backupsListScrollPane.setPreferredSize(preferredSize);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("busy".equals(evt.getPropertyName()) && evt.getNewValue() == Boolean.FALSE) {
            File[] newFiles = this.fileChooser.getCurrentDirectory().listFiles();
            ArrayList<File> newSelectedFilesCollection = new ArrayList<File>();
            for (File newFile : newFiles) {
                for (File oldSelectedFile : this.oldSelectedFiles) {
                    if (!newFile.getName().equals(oldSelectedFile.getName())) continue;
                    newSelectedFilesCollection.add(newFile);
                }
            }
            File[] newSelectedFiles = newSelectedFilesCollection.toArray(new File[newSelectedFilesCollection.size()]);
            this.fileChooser.setSelectedFiles(newSelectedFiles);
        }
    }

    public void setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    public void setRadioButtonsVisible(boolean visible) {
        this.allBackupRadioButton.setVisible(visible);
        this.backupFilesRadioButton.setVisible(visible);
    }

    public void setSelectedDirectory(String selectedDir) {
        this.selectedDirectory = selectedDir;
        if (selectedDir == null || selectedDir.length() == 0) {
            this.dirCheckError("Error_No_Selection", new Object[0]);
            return;
        }
        File testFile = new File(selectedDir);
        FileTools.showSpaceInfo(testFile, this.storageUsageProgressBar);
        if (!testFile.exists()) {
            this.dirCheckError("Error_Directory_Does_Not_Exist", new Object[0]);
            return;
        }
        if (!testFile.isDirectory()) {
            this.dirCheckError("Error_No_Directory", new Object[0]);
            return;
        }
        if (!testFile.canRead()) {
            this.dirCheckError("Error_Directory_Unreadable", new Object[0]);
            return;
        }
        File rdiffBackupDataDir = new File(testFile, "rdiff-backup-data");
        if (rdiffBackupDataDir.exists()) {
            if (!rdiffBackupDataDir.canRead()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "can not read {0}{1}rdiff-backup-data", new Object[]{testFile, Character.valueOf(File.separatorChar)});
                }
                this.dirCheckError("Error_Read-Only", rdiffBackupDataDir);
                return;
            }
            if (!rdiffBackupDataDir.canExecute()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "can not enter directory {0}{1}rdiff-backup-data", new Object[]{testFile, Character.valueOf(File.separatorChar)});
                }
                this.dirCheckError("Error_No_Execute_Dir", rdiffBackupDataDir);
                return;
            }
        }
        ProgressDialog dialog = new ProgressDialog(this.parentWindow, this.processExecutor);
        ModalDialogHandler dialogHandler = new ModalDialogHandler(dialog);
        dialog.setCancelButtonVisible(false);
        DirectoryChecker directoryChecker = new DirectoryChecker(dialog, dialogHandler, testFile);
        LOGGER.fine("scheduling directoryChecker for execution");
        directoryChecker.execute();
        dialogHandler.show();
    }

    public RdiffFile[] getSelectedFiles() {
        File[] selectedFiles;
        if (this.backupFilesRadioButton.isSelected() && (selectedFiles = this.fileChooser.getSelectedFiles()) != null) {
            int length = selectedFiles.length;
            if (length > 0) {
                RdiffFile[] rdiffFiles = new RdiffFile[length];
                for (int i = 0; i < length; ++i) {
                    rdiffFiles[i] = (RdiffFile)selectedFiles[i];
                }
                return rdiffFiles;
            }
            LOGGER.warning("no files selected");
            return null;
        }
        if (this.allBackupRadioButton.isSelected()) {
            int selectedIndex = this.backupsList.getSelectedIndex();
            if (selectedIndex == -1) {
                LOGGER.warning("no increment selected");
                return null;
            }
            Increment increment = this.increments.get(selectedIndex);
            RdiffFile root = increment.getRdiffRoot();
            if (root == null) {
                LOGGER.log(Level.WARNING, "increment {0} has no root", increment.getRdiffTimestamp());
                return null;
            }
            return new RdiffFile[]{root};
        }
        LOGGER.warning("unsupported state");
        return null;
    }

    public RdiffFileDatabase getRdiffFileDatabase() {
        return this.rdiffFileDatabase;
    }

    private void initComponents() {
        this.backupsListPopupMenu = new JPopupMenu();
        this.deleteMenuItem = new JMenuItem();
        this.backupSelectionGroup = new ButtonGroup();
        this.rdiffDirectoryPanel = new JPanel();
        this.backupsPanel = new JPanel();
        this.backupsListScrollPane = new JScrollPane();
        this.backupsList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.backupSizesPanel = new JPanel();
        this.cumulativeSizeLabel = new JLabel();
        this.cumulativeSizeTextField = new JTextField();
        this.totalSizeLabel = new JLabel();
        this.totalSizeTextField = new JTextField();
        this.storageUsageLabel = new JLabel();
        this.storageUsageProgressBar = new JProgressBar();
        this.deleteBackupButton = new JButton();
        this.filesPanel = new JPanel();
        this.allBackupRadioButton = new JRadioButton();
        this.backupFilesRadioButton = new JRadioButton();
        this.filesCardPanel = new JPanel();
        this.selectIncrementPanel = new JPanel();
        this.selectIncrementLabel = new JLabel();
        this.fileChooser = new JFileChooser(this.rdiffFileSystemView);
        this.emptyPanel = new JPanel();
        this.previewButton = new JButton();
        this.noRdiffDirectoryPanel = new JPanel();
        this.noRdiffDirectoryLabel = new JLabel();
        this.deleteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/remove.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.deleteMenuItem.setText(bundle.getString("RdiffChooserPanel.deleteMenuItem.text"));
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.backupsListPopupMenu.add(this.deleteMenuItem);
        this.setLayout(new CardLayout());
        this.rdiffDirectoryPanel.setLayout(new GridBagLayout());
        this.backupsPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RdiffChooserPanel.backupsPanel.border.title")));
        this.backupsPanel.setLayout(new GridBagLayout());
        this.backupsList.setSelectionMode(1);
        this.backupsList.setName("backupsList");
        this.backupsList.setVisibleRowCount(1);
        this.backupsList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                RdiffChooserPanel.this.backupsListMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                RdiffChooserPanel.this.backupsListMouseReleased(evt);
            }
        });
        this.backupsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RdiffChooserPanel.this.backupsListValueChanged(evt);
            }
        });
        this.backupsListScrollPane.setViewportView(this.backupsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.backupsPanel.add((Component)this.backupsListScrollPane, gridBagConstraints);
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/up.png")));
        this.upButton.setToolTipText(bundle.getString("RdiffChooserPanel.upButton.toolTipText"));
        this.upButton.setMargin(new Insets(2, 2, 2, 2));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 3);
        this.backupsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/down.png")));
        this.downButton.setToolTipText(bundle.getString("RdiffChooserPanel.downButton.toolTipText"));
        this.downButton.setMargin(new Insets(2, 2, 2, 2));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.backupsPanel.add((Component)this.downButton, gridBagConstraints);
        this.backupSizesPanel.setLayout(new GridBagLayout());
        this.cumulativeSizeLabel.setText(bundle.getString("RdiffChooserPanel.cumulativeSizeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.backupSizesPanel.add((Component)this.cumulativeSizeLabel, gridBagConstraints);
        this.cumulativeSizeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.backupSizesPanel.add((Component)this.cumulativeSizeTextField, gridBagConstraints);
        this.totalSizeLabel.setText(bundle.getString("RdiffChooserPanel.totalSizeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.backupSizesPanel.add((Component)this.totalSizeLabel, gridBagConstraints);
        this.totalSizeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.backupSizesPanel.add((Component)this.totalSizeTextField, gridBagConstraints);
        this.storageUsageLabel.setText(bundle.getString("RdiffChooserPanel.storageUsageLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.backupSizesPanel.add((Component)this.storageUsageLabel, gridBagConstraints);
        this.storageUsageProgressBar.setFont(this.storageUsageProgressBar.getFont().deriveFont(this.storageUsageProgressBar.getFont().getStyle() & 0xFFFFFFFE, this.storageUsageProgressBar.getFont().getSize() - 1));
        this.storageUsageProgressBar.setString("");
        this.storageUsageProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.backupSizesPanel.add((Component)this.storageUsageProgressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 0, 3);
        this.backupsPanel.add((Component)this.backupSizesPanel, gridBagConstraints);
        this.deleteBackupButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/remove.png")));
        this.deleteBackupButton.setText(bundle.getString("RdiffChooserPanel.deleteBackupButton.text"));
        this.deleteBackupButton.setEnabled(false);
        this.deleteBackupButton.setHorizontalAlignment(2);
        this.deleteBackupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.deleteBackupButtonActionPerformed(evt);
            }
        });
        this.deleteBackupButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                RdiffChooserPanel.this.deleteBackupButtonFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                RdiffChooserPanel.this.deleteBackupButtonFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.backupsPanel.add((Component)this.deleteBackupButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.rdiffDirectoryPanel.add((Component)this.backupsPanel, gridBagConstraints);
        this.filesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RdiffChooserPanel.filesPanel.border.title")));
        this.filesPanel.setLayout(new GridBagLayout());
        this.backupSelectionGroup.add(this.allBackupRadioButton);
        this.allBackupRadioButton.setText(bundle.getString("RdiffChooserPanel.allBackupRadioButton.text"));
        this.allBackupRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.allBackupRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.filesPanel.add((Component)this.allBackupRadioButton, gridBagConstraints);
        this.backupSelectionGroup.add(this.backupFilesRadioButton);
        this.backupFilesRadioButton.setSelected(true);
        this.backupFilesRadioButton.setText(bundle.getString("RdiffChooserPanel.backupFilesRadioButton.text"));
        this.backupFilesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.backupFilesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.filesPanel.add((Component)this.backupFilesRadioButton, gridBagConstraints);
        this.filesCardPanel.setLayout(new CardLayout());
        this.selectIncrementPanel.setLayout(new GridBagLayout());
        this.selectIncrementLabel.setText(bundle.getString("RdiffChooserPanel.selectIncrementLabel.text"));
        this.selectIncrementPanel.add((Component)this.selectIncrementLabel, new GridBagConstraints());
        this.filesCardPanel.add((Component)this.selectIncrementPanel, "selectIncrementPanel");
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setName("fileChooser");
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RdiffChooserPanel.this.fileChooserPropertyChange(evt);
            }
        });
        this.filesCardPanel.add((Component)this.fileChooser, "fileChooser");
        this.emptyPanel.setLayout(new GridBagLayout());
        this.filesCardPanel.add((Component)this.emptyPanel, "emptyPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filesPanel.add((Component)this.filesCardPanel, gridBagConstraints);
        this.previewButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/previewer.png")));
        this.previewButton.setText(bundle.getString("RdiffChooserPanel.previewButton.text"));
        this.previewButton.setEnabled(false);
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RdiffChooserPanel.this.previewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.filesPanel.add((Component)this.previewButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.rdiffDirectoryPanel.add((Component)this.filesPanel, gridBagConstraints);
        this.add((Component)this.rdiffDirectoryPanel, "rdiffDirectoryPanel");
        this.noRdiffDirectoryPanel.setLayout(new GridBagLayout());
        this.noRdiffDirectoryLabel.setText(bundle.getString("Warning_No_Backup_Directory"));
        this.noRdiffDirectoryPanel.add((Component)this.noRdiffDirectoryLabel, new GridBagConstraints());
        this.add((Component)this.noRdiffDirectoryPanel, "noRdiffDirectoryPanel");
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.deleteBackups();
    }

    private void deleteBackupButtonActionPerformed(ActionEvent evt) {
        this.deleteBackups();
    }

    private void backupsListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int[] selectedIndices = this.backupsList.getSelectedIndices();
        boolean mustFixSelection = false;
        int selectionLength = selectedIndices.length;
        if (selectionLength == 0) {
            return;
        }
        int topIndex = selectedIndices[0];
        int bottomIndex = selectedIndices[selectionLength - 1];
        if (bottomIndex == this.incrementModel.getSize() - 1) {
            for (int i = 0; i < selectionLength - 1; ++i) {
                if (selectedIndices[i] + 1 == selectedIndices[i + 1]) continue;
                mustFixSelection = true;
                break;
            }
        } else {
            mustFixSelection = true;
        }
        if (mustFixSelection) {
            this.backupsList.setSelectionInterval(this.backupsList.getModel().getSize() - 1, topIndex);
            return;
        }
        this.upButton.setEnabled(topIndex != 0);
        this.downButton.setEnabled(topIndex != this.increments.size() - 1);
        this.deleteBackupButton.setEnabled(topIndex != -1);
        this.updateSizeInformation();
        this.updateIncrementView();
    }

    private void backupsListMouseReleased(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    private void backupsListMousePressed(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    private void allBackupRadioButtonActionPerformed(ActionEvent evt) {
        this.updateIncrementView();
    }

    private void backupFilesRadioButtonActionPerformed(ActionEvent evt) {
        this.updateIncrementView();
    }

    private void deleteBackupButtonFocusGained(FocusEvent evt) {
        this.getRootPane().setDefaultButton(this.deleteBackupButton);
    }

    private void deleteBackupButtonFocusLost(FocusEvent evt) {
        this.getRootPane().setDefaultButton(null);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.backupsList.setSelectedIndex(this.backupsList.getSelectedIndex() - 1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.backupsList.setSelectedIndex(this.backupsList.getSelectedIndex() + 1);
    }

    private void fileChooserPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("fileFilterChanged".equals(propertyName)) {
            this.fileChooser.setFileHidingEnabled(this.fileChooser.getFileFilter() == this.noHiddenFilesSwingFilter);
            this.fileChooser.rescanCurrentDirectory();
        } else if (this.desktopIsSupported && "SelectedFilesChangedProperty".equals(propertyName)) {
            this.previewButton.setEnabled(this.fileChooser.getSelectedFiles().length > 0);
        }
    }

    private void previewButtonActionPerformed(ActionEvent evt) {
        this.previewFiles();
    }

    private void dirCheckInfo(String messageKey) {
        this.dirCheckUnsuccessful("OptionPane.informationIcon", messageKey, new Object[0]);
        this.cardLayout.show(this, "noRdiffDirectoryPanel");
    }

    private void dirCheckError(String messageKey, Object ... arguments) {
        this.dirCheckUnsuccessful("OptionPane.errorIcon", messageKey, arguments);
    }

    private void dirCheckUnsuccessful(String iconKey, String messageKey, Object ... arguments) {
        this.noRdiffDirectoryLabel.setIcon(UIManager.getIcon(iconKey));
        String message = BUNDLE.getString(messageKey);
        message = MessageFormat.format(message, arguments);
        this.noRdiffDirectoryLabel.setText(message);
        this.cardLayout.show(this, "noRdiffDirectoryPanel");
    }

    private void updateIncrementView() {
        int selectedIndex = this.backupsList.getSelectedIndex();
        if (this.allBackupRadioButton.isSelected()) {
            this.filesCardLayout.show(this.filesCardPanel, "emptyPanel");
            return;
        }
        if (selectedIndex == -1) {
            this.filesCardLayout.show(this.filesCardPanel, "selectIncrementPanel");
        } else {
            Increment increment = this.increments.get(selectedIndex);
            RdiffFile root = increment.getRdiffRoot();
            this.rdiffFileSystemView.setRoot(root);
            this.oldSelectedFiles = this.fileChooser.getSelectedFiles();
            File oldCurrentDirectory = this.fileChooser.getCurrentDirectory();
            if (oldCurrentDirectory == null) {
                this.fileChooser.setCurrentDirectory(root);
            } else {
                String currentPath = oldCurrentDirectory.getAbsolutePath();
                try {
                    File newCurrentDirectory = root.getLongestMatch(currentPath);
                    this.fileChooser.setCurrentDirectory(newCurrentDirectory);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            this.filesCardLayout.show(this.filesCardPanel, "fileChooser");
        }
    }

    private void deleteBackups() {
        final int selectedIndex = this.backupsList.getSelectedIndex();
        if (selectedIndex == 0) {
            int returnValue = JOptionPane.showConfirmDialog(this, BUNDLE.getString("Delete_All_Backups_Warning"), BUNDLE.getString("Warning"), 2);
            if (returnValue == 0) {
                ProgressDialog dialog = new ProgressDialog(this.parentWindow, this.processExecutor);
                dialog.setCancelButtonVisible(false);
                dialog.setMessage(BUNDLE.getString("Removing_Selected_Backups"));
                final ModalDialogHandler dialogHandler = new ModalDialogHandler(dialog);
                SwingWorker swingWorker = new SwingWorker(){

                    protected Object doInBackground() {
                        File backupDirectory = new File(RdiffChooserPanel.this.selectedDirectory);
                        for (File file : backupDirectory.listFiles()) {
                            if (file.isDirectory()) {
                                RdiffChooserPanel.this.deleteDirectory(file);
                                continue;
                            }
                            file.delete();
                        }
                        return null;
                    }

                    protected void done() {
                        dialogHandler.hide();
                    }
                };
                swingWorker.execute();
                dialogHandler.show();
                this.dirCheckInfo("Warning_No_Backup_Directory");
            }
        } else {
            final Increment previousIncrement = this.increments.get(selectedIndex - 1);
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            Date timestamp = previousIncrement.getTimestamp();
            String formattedDate = dateFormat.format(timestamp);
            String warningMessage = BUNDLE.getString("Delete_Increment_Warning");
            int returnValue = JOptionPane.showConfirmDialog(this, warningMessage = MessageFormat.format(warningMessage, formattedDate), BUNDLE.getString("Warning"), 2);
            if (returnValue == 0) {
                ProgressDialog dialog = new ProgressDialog(this.parentWindow, this.processExecutor);
                dialog.setCancelButtonVisible(false);
                dialog.setMessage(BUNDLE.getString("Removing_Selected_Backups"));
                final ModalDialogHandler dialogHandler = new ModalDialogHandler(dialog);
                SwingWorker swingWorker = new SwingWorker(){

                    protected Object doInBackground() {
                        String rdiffTimestamp = previousIncrement.getRdiffTimestamp();
                        RdiffChooserPanel.this.processExecutor.executeProcess("rdiff-backup", "--force", "--remove-older-than", rdiffTimestamp, RdiffChooserPanel.this.selectedDirectory);
                        return null;
                    }

                    protected void done() {
                        dialogHandler.hide();
                        for (int i = RdiffChooserPanel.this.increments.size() - 1; i >= selectedIndex; --i) {
                            RdiffChooserPanel.this.increments.remove(i);
                        }
                        RdiffChooserPanel.this.incrementModel.changed();
                        RdiffChooserPanel.this.backupsList.setSelectedIndex(RdiffChooserPanel.this.increments.size() - 1);
                        FileTools.showSpaceInfo(new File(RdiffChooserPanel.this.selectedDirectory), RdiffChooserPanel.this.storageUsageProgressBar);
                    }
                };
                swingWorker.execute();
                dialogHandler.show();
            }
        }
    }

    private void deleteDirectory(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    private void updateSizeInformation() {
        int selectedIndex = this.backupsList.getSelectedIndex();
        long cumulativeSize = 0L;
        long totalSize = 0L;
        boolean showCumulativeSize = true;
        boolean showTotalSize = true;
        int j = this.increments.size();
        for (int i = 0; i < j; ++i) {
            Increment increment = this.increments.get(i);
            Long size = increment.getSize();
            if (size == null) {
                if (i >= selectedIndex) {
                    showCumulativeSize = false;
                }
                showTotalSize = false;
                continue;
            }
            if (i >= selectedIndex) {
                cumulativeSize += size.longValue();
            }
            totalSize += size.longValue();
        }
        if (showCumulativeSize) {
            String text = FileTools.getDataVolumeString(cumulativeSize, 1);
            this.cumulativeSizeTextField.setText(text);
        } else {
            this.cumulativeSizeTextField.setText(null);
        }
        if (showTotalSize) {
            String text = FileTools.getDataVolumeString(totalSize, 1);
            this.totalSizeTextField.setText(text);
        } else {
            this.totalSizeTextField.setText(null);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        int index = this.backupsList.locationToIndex(e.getPoint());
        this.backupsList.setSelectedIndex(index);
        if (e.isPopupTrigger()) {
            this.backupsListPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void previewFiles() {
        try {
            String tmpPath = System.getProperty("java.io.tmpdir");
            File restoreDirectory = FileTools.createTempDirectory(new File(tmpPath), "jbackpack_preview");
            restoreDirectory.deleteOnExit();
            RdiffBackupRestore rdiffBackupRestore = new RdiffBackupRestore();
            RdiffFile[] selectedFiles = this.getSelectedFiles();
            Increment increment = selectedFiles[0].getIncrement();
            rdiffBackupRestore.restore(increment.getRdiffTimestamp(), selectedFiles, increment.getBackupDirectory(), restoreDirectory, tmpPath, false);
            for (RdiffFile selectedFile : selectedFiles) {
                File restoredFile = new File(restoreDirectory, ((File)selectedFile).getAbsolutePath());
                restoredFile.setReadOnly();
                restoredFile.deleteOnExit();
                try {
                    this.desktop.open(restoredFile);
                }
                catch (IOException ex) {
                    String errorMessage = BUNDLE.getString("Error_Preview_File_Log");
                    errorMessage = MessageFormat.format(errorMessage, restoredFile.getName());
                    LOGGER.log(Level.SEVERE, errorMessage, ex);
                    errorMessage = BUNDLE.getString("Error_Preview_File_GUI");
                    errorMessage = MessageFormat.format(errorMessage, restoredFile.getName(), ex);
                    this.showError(errorMessage);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            String errorMessage = BUNDLE.getString("Error_Preview");
            errorMessage = MessageFormat.format(errorMessage, ex);
            this.showError(errorMessage);
        }
    }

    private void showError(String errorMessage) {
        JOptionPane.showMessageDialog(this.parentWindow, errorMessage, BUNDLE.getString("Error"), 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DatabaseSyncer
    extends SwingWorker<Boolean, Object> {
        private final File backupDirectory;
        private final String databasePath;
        private final List<String> rdiffBackupListOutput;
        private final DatabaseSyncDialog dialog;
        private final ModalDialogHandler dialogHandler;

        public DatabaseSyncer(File backupDirectory, String databasePath, List<String> rdiffBackupListOutput) {
            this.backupDirectory = backupDirectory;
            this.databasePath = databasePath;
            this.rdiffBackupListOutput = rdiffBackupListOutput;
            this.dialog = new DatabaseSyncDialog(RdiffChooserPanel.this.parentWindow);
            this.dialogHandler = new ModalDialogHandler(this.dialog);
            this.dialogHandler.show();
        }

        @Override
        protected Boolean doInBackground() {
            RdiffChooserPanel.this.rdiffFileDatabase = RdiffFileDatabase.getInstance(this.backupDirectory, this.databasePath, this.rdiffBackupListOutput);
            if (RdiffChooserPanel.this.rdiffFileDatabase.isConnected()) {
                this.dialog.setDatabase(RdiffChooserPanel.this.rdiffFileDatabase);
                try {
                    RdiffChooserPanel.this.rdiffFileDatabase.sync();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                RdiffChooserPanel.this.increments = RdiffChooserPanel.this.rdiffFileDatabase.getIncrements();
                return true;
            }
            return false;
        }

        @Override
        protected void done() {
            LOGGER.fine("syncing database done");
            this.dialogHandler.hide();
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    if (RdiffChooserPanel.this.increments.isEmpty()) {
                        LOGGER.log(Level.WARNING, "no increments found in {0}", this.backupDirectory);
                        RdiffChooserPanel.this.dirCheckInfo("Warning_No_Backup_Directory");
                    } else {
                        RdiffChooserPanel.this.backupsList.clearSelection();
                        RdiffChooserPanel.this.updateSizeInformation();
                        RdiffChooserPanel.this.incrementModel.changed();
                        RdiffChooserPanel.this.backupsList.setSelectedIndex(0);
                        RdiffChooserPanel.this.cardLayout.show(RdiffChooserPanel.this, "rdiffDirectoryPanel");
                    }
                } else if (RdiffChooserPanel.this.rdiffFileDatabase.isAnotherInstanceRunning()) {
                    RdiffChooserPanel.this.dirCheckError("Error_Database_In_Use", new Object[0]);
                } else {
                    RdiffChooserPanel.this.dirCheckError("Error_Database", new Object[0]);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryFixer
    extends SwingWorker<Object, Object> {
        private final ProgressDialog dialog;
        private final ModalDialogHandler dialogHandler;
        private final File directory;

        public DirectoryFixer(ProgressDialog dialog, ModalDialogHandler dialogHandler, File directory) {
            this.dialog = dialog;
            this.dialogHandler = dialogHandler;
            this.directory = directory;
            dialog.setMessage(BUNDLE.getString("Repairing_Destination_Directory"));
        }

        @Override
        protected Object doInBackground() {
            RdiffChooserPanel.this.processExecutor.executeProcess("rdiff-backup", "--check-destination-dir", RdiffChooserPanel.this.selectedDirectory);
            return null;
        }

        @Override
        protected void done() {
            DirectoryChecker directoryChecker = new DirectoryChecker(this.dialog, this.dialogHandler, this.directory);
            LOGGER.info("scheduling directoryChecker for execution");
            directoryChecker.execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryChecker
    extends SwingWorker<Boolean, Void> {
        private final ProgressDialog dialog;
        private final ModalDialogHandler dialogHandler;
        private final File directory;
        private int returnValue;
        private List<String> rdiffBackupListOutput;

        public DirectoryChecker(ProgressDialog dialog, ModalDialogHandler dialogHandler, File directory) {
            this.dialog = dialog;
            this.dialogHandler = dialogHandler;
            this.directory = directory;
            dialog.setMessage(BUNDLE.getString("Checking_Directory"));
        }

        @Override
        protected Boolean doInBackground() {
            long start = System.currentTimeMillis();
            this.returnValue = RdiffChooserPanel.this.processExecutor.executeProcess(true, true, "rdiff-backup", "--parsable-output", "-l", RdiffChooserPanel.this.selectedDirectory);
            long time = System.currentTimeMillis() - start;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "calling \"rdiff-backup -l {0}\" took {1} ms", new Object[]{RdiffChooserPanel.this.selectedDirectory, time});
            }
            for (String s : RdiffChooserPanel.this.processExecutor.getStdErrList()) {
                if (!s.matches(".*Previous backup.*failed.*")) continue;
                return false;
            }
            this.rdiffBackupListOutput = RdiffChooserPanel.this.processExecutor.getStdOutList();
            return true;
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    this.dialogHandler.hide();
                    if (this.returnValue == 0) {
                        String databasePath = null;
                        File rdiffBackupDataDir = new File(this.directory, "rdiff-backup-data");
                        if (FileTools.canWrite(rdiffBackupDataDir)) {
                            databasePath = rdiffBackupDataDir.getPath() + File.separatorChar + "jbackpack";
                        } else {
                            String message = BUNDLE.getString("Warning_Temporary_Database");
                            message = MessageFormat.format(message, rdiffBackupDataDir);
                            int selected = JOptionPane.showConfirmDialog(RdiffChooserPanel.this.parentWindow, message, BUNDLE.getString("Warning"), 0);
                            if (selected == 0) {
                                try {
                                    databasePath = FileTools.createTempDirectory("jbackpack", null).getPath() + File.separatorChar + "jbackpack";
                                }
                                catch (IOException ex) {
                                    LOGGER.log(Level.WARNING, null, ex);
                                    RdiffChooserPanel.this.dirCheckError("Error_Database", new Object[0]);
                                    return;
                                }
                            } else {
                                RdiffChooserPanel.this.dirCheckError("Error_Database", new Object[0]);
                                return;
                            }
                        }
                        DatabaseSyncer databaseSyncer = new DatabaseSyncer(this.directory, databasePath, this.rdiffBackupListOutput);
                        LOGGER.fine("scheduling DatabaseSyncer for execution");
                        databaseSyncer.execute();
                    } else {
                        RdiffChooserPanel.this.dirCheckInfo("Warning_No_Backup_Directory");
                    }
                } else {
                    RdiffChooserPanel.this.dirCheckError("Error_Backup_Directory_Corrupted", new Object[0]);
                    int selected = JOptionPane.showConfirmDialog(RdiffChooserPanel.this.parentWindow, BUNDLE.getString("Repair_Backup_Message"), BUNDLE.getString("Repair_Backup_Title"), 0);
                    if (selected == 0) {
                        DirectoryFixer directoryFixer = new DirectoryFixer(this.dialog, this.dialogHandler, this.directory);
                        LOGGER.info("scheduling directoryFixer for execution");
                        directoryFixer.execute();
                    } else {
                        this.dialogHandler.hide();
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private class IncrementModel
    extends DefaultListModel {
        private IncrementModel() {
        }

        public int getSize() {
            return RdiffChooserPanel.this.increments.size();
        }

        public Object getElementAt(int index) {
            return RdiffChooserPanel.this.increments.get(index);
        }

        public void changed() {
            this.fireContentsChanged(this, 0, RdiffChooserPanel.this.increments.size() - 1);
        }
    }
}

