/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jedecma.Base64;
import jedecma.FixedSizePlainDocument;
import jedecma.Jedecma;
import jedecma.MyJComboBox;
import jedecma.MyJTextField;
import jedecma.MyJlabel;
import jedecma.MyLock;
import jedecma.Uti1;

public class UsersMgr
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String delString = Jedecma.localMessagesBundle.getString("DELETE");
    private static final String okString = "OK";
    private static final String lockCode = "TBLUSER";
    private JButton delBut;
    private JButton okBut;
    private MyJTextField userName;
    private JPasswordField userPass;
    private MyJComboBox userPr;
    private JList userList;
    private Vector<String> users = new Vector();

    public UsersMgr() {
        super(Jedecma.mf, Jedecma.localMessagesBundle.getString("USERS_MANAGEMENT"), true);
        int lockrv = MyLock.setLock(Jedecma.dbmgr, lockCode, Jedecma.user.userid, true);
        if (lockrv == 0) {
            ResultSet resultSet = Jedecma.dbmgr.executeQuery("SELECT username FROM TBLUSER WHERE userno <> " + Jedecma.user.userid);
            try {
                while (resultSet.next()) {
                    String s = resultSet.getString("username");
                    this.users.add(s.trim());
                }
            }
            catch (SQLException ex) {
                System.err.println(ex);
                Uti1.error(Jedecma.localMessagesBundle.getString("SQL_ERROR"), true);
            }
            this.userList = new JList<String>(this.users);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int index;
                    JList theList = (JList)mouseEvent.getSource();
                    if (mouseEvent.getClickCount() == 1 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                        Object o = theList.getModel().getElementAt(index);
                        String uName = o.toString();
                        String uPass = "";
                        int iPr = 0;
                        ResultSet resultSet = Jedecma.dbmgr.executeQuery("SELECT userpr, userpw FROM TBLUSER WHERE username = '" + uName + "'");
                        try {
                            while (resultSet.next()) {
                                uPass = resultSet.getString("userpw");
                                String p = resultSet.getString("userpr");
                                if (!p.equals("1")) continue;
                                iPr = 1;
                            }
                        }
                        catch (SQLException ex) {
                            System.err.println(ex);
                            Uti1.error(Jedecma.localMessagesBundle.getString("SQL_ERROR"), true);
                        }
                        uPass = Base64.decode(uPass);
                        UsersMgr.this.userPr.setSelectedIndex(iPr);
                        UsersMgr.this.userName.setText(uName.trim());
                        UsersMgr.this.userPass.setText(uPass.trim());
                        UsersMgr.this.okBut.setSelected(true);
                    }
                }
            };
            this.userList.addMouseListener(mouseListener);
            JPanel mainPan = new JPanel();
            mainPan.setLayout(new BoxLayout(mainPan, 1));
            JScrollPane userListPan = new JScrollPane(this.userList);
            userListPan.setBorder(BorderFactory.createTitledBorder(Jedecma.localMessagesBundle.getString("USERS_LIST")));
            mainPan.add((Component)userListPan, "Center");
            JPanel userPan = new JPanel();
            GridBagLayout gbUPan = new GridBagLayout();
            GridBagConstraints gbcUPan = new GridBagConstraints();
            userPan.setLayout(gbUPan);
            userPan.setBorder(BorderFactory.createTitledBorder(""));
            MyJlabel lab = new MyJlabel(Jedecma.localMessagesBundle.getString("USER"));
            Uti1.bldConst(gbcUPan, 0, 0, 5, 1, 0, 1, 11, 1);
            gbUPan.setConstraints(lab, gbcUPan);
            userPan.add(lab);
            this.userName = new MyJTextField(15, "", new float[0], 0);
            Uti1.bldConst(gbcUPan, 5, 0, 10, 1, 1, 1, 11, 1);
            gbUPan.setConstraints(this.userName, gbcUPan);
            userPan.add(this.userName);
            lab = new MyJlabel("Password");
            Uti1.bldConst(gbcUPan, 0, 1, 5, 1, 0, 1, 11, 1);
            gbUPan.setConstraints(lab, gbcUPan);
            userPan.add(lab);
            this.userPass = new JPasswordField(8);
            this.userPass.setDocument(new FixedSizePlainDocument(8));
            Uti1.bldConst(gbcUPan, 5, 1, 10, 1, 1, 1, 11, 1);
            gbUPan.setConstraints(this.userPass, gbcUPan);
            this.userPass.setText("");
            userPan.add(this.userPass);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("ADMIN"));
            Uti1.bldConst(gbcUPan, 0, 2, 5, 1, 0, 1, 11, 1);
            gbUPan.setConstraints(lab, gbcUPan);
            userPan.add(lab);
            this.userPr = new MyJComboBox(new String[]{"0=" + Jedecma.localMessagesBundle.getString("CB_NO"), "1=" + Jedecma.localMessagesBundle.getString("CB_YES")}, String.valueOf(0));
            Uti1.bldConst(gbcUPan, 5, 2, 5, 1, 0, 1, 11, 1);
            gbUPan.setConstraints(this.userPr, gbcUPan);
            this.userPr.setSelectedIndex(0);
            userPan.add(this.userPr);
            mainPan.add(userPan);
            JPanel butPan = new JPanel();
            butPan.setLayout(new FlowLayout(2));
            butPan.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.delBut = new JButton(delString);
            this.delBut.setMnemonic(76);
            this.delBut.addActionListener(new DelListener());
            butPan.add(this.delBut);
            this.okBut = new JButton(okString);
            this.okBut.setMnemonic(79);
            this.okBut.addActionListener(new OkListener());
            butPan.add(this.okBut);
            mainPan.add((Component)butPan, "South");
            this.getContentPane().add((Component)mainPan, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MyLock.delLock(Jedecma.dbmgr, UsersMgr.lockCode, Jedecma.user.userid);
                }
            });
            this.pack();
            this.setVisible(true);
        } else {
            Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("USERS_LIST")) + " " + Jedecma.localMessagesBundle.getString("IN_USE") + " (" + lockrv + ")", false);
        }
    }

    public boolean existUser(String c) {
        String name = c;
        for (String item : this.users) {
            if (!item.equals(name)) continue;
            return true;
        }
        return false;
    }

    void refreshGui() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UsersMgr.this.updateLists();
                UsersMgr.this.repaint();
            }
        });
    }

    void updateLists() {
        this.userList.setListData(this.users);
    }

    class DelListener
    implements ActionListener {
        DelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsersMgr.this.delBut.setEnabled(false);
            UsersMgr.this.okBut.setEnabled(false);
            String uName = UsersMgr.this.userName.getText().trim();
            boolean ctr = true;
            if (uName.length() == 0) {
                ctr = false;
            }
            if (ctr) {
                int rc = Jedecma.dbmgr.executeUpdate("DELETE FROM TBLUSER WHERE username='" + Uti1.escape(uName) + "'");
                if (rc != 1) {
                    Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("USERS_LIST")) + ": " + Jedecma.localMessagesBundle.getString("INS_UPD_FAILURE"), true);
                } else {
                    UsersMgr.this.users.removeElement(uName);
                }
            }
            UsersMgr.this.userName.setText("");
            UsersMgr.this.userPass.setText("");
            UsersMgr.this.userPr.setSelectedIndex(0);
            UsersMgr.this.okBut.setEnabled(true);
            UsersMgr.this.delBut.setEnabled(true);
            UsersMgr.this.refreshGui();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsersMgr.this.okBut.setEnabled(false);
            UsersMgr.this.delBut.setEnabled(false);
            String uName = UsersMgr.this.userName.getText().trim();
            String pwString = "";
            char[] input = UsersMgr.this.userPass.getPassword();
            int i = 0;
            while (i < input.length) {
                pwString = String.valueOf(pwString) + input[i];
                ++i;
            }
            pwString = pwString.trim();
            String uAdmin = String.valueOf(UsersMgr.this.userPr.getSelectedIndex());
            boolean ctr = true;
            if (uName.length() == 0) {
                ctr = false;
            }
            if (ctr && pwString.length() == 0) {
                ctr = false;
            }
            if (ctr && (UsersMgr.this.userPr.getSelectedIndex() < 0 || UsersMgr.this.userPr.getSelectedIndex() > 1)) {
                ctr = false;
            }
            if (ctr) {
                int rc = 0;
                boolean newUser = !UsersMgr.this.existUser(uName);
                rc = newUser ? Jedecma.dbmgr.executeUpdate("INSERT INTO TBLUSER (username, userpw, userpr) VALUES ('" + uName + "', '" + Base64.encode(pwString) + "', '" + uAdmin + "')") : Jedecma.dbmgr.executeUpdate("UPDATE TBLUSER set userpw='" + Base64.encode(pwString) + "'" + ", userpr='" + uAdmin + "'" + " WHERE username = '" + uName + "'");
                if (rc != 1) {
                    Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("USERS_LIST")) + ": " + Jedecma.localMessagesBundle.getString("INS_UPD_FAILURE"), true);
                } else {
                    if (newUser) {
                        UsersMgr.this.users.add(uName);
                    }
                    UsersMgr.this.userName.setText("");
                    UsersMgr.this.userPass.setText("");
                    UsersMgr.this.userPr.setSelectedIndex(0);
                }
            } else {
                Uti1.error(Jedecma.localMessagesBundle.getString("CHECK_USER_DATA"), false);
            }
            UsersMgr.this.okBut.setEnabled(true);
            UsersMgr.this.delBut.setEnabled(true);
            UsersMgr.this.refreshGui();
        }
    }
}

