/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class ComandoAiuto
extends Comando {
    private final String nomeComando = "aiuto";
    private String aiutoComando;

    public ComandoAiuto(String aiutoComando) {
        this.aiutoComando = aiutoComando;
    }

    public String getNomeComando() {
        return this.nomeComando;
    }

    public boolean esegui(Giocatore giocatore, Tabellone planisfero) throws IOException {
        if (this.aiutoComando == null) {
            this.stampaAiutoGenerico(giocatore);
        } else {
            ElencoComandi elenco = new ElencoComandi();
            if (elenco.comandoValido(this.aiutoComando)) {
                this.stampaAiutoPerComando(giocatore, this.aiutoComando);
            } else {
                new ComandoNonValido().esegui(giocatore, planisfero);
            }
        }
        return false;
    }

    private void stampaAiutoGenerico(Giocatore g) {
        g.schermo.stampa("I comandi accettati dalla console sono: ");
        g.schermo.stampaln(ElencoComandi.elencoTuttiComandi());
        g.schermo.stampaln("Le regole del gioco le potete trovare su http://www.hasbro.com/risk/rules.cfm");
    }

    private void stampaAiutoPerComando(Giocatore g, String str) {
        if (str.equals("attacca")) {
            g.schermo.stampaln(this.aiutoPerAttacca());
        }
        if (str.equals("sposta")) {
            g.schermo.stampaln(this.aiutoPerSposta());
        }
        if (str.equals("esci")) {
            g.schermo.stampaln(this.aiutoPerEsci());
        }
        if (str.equals("stampa")) {
            g.schermo.stampaln(this.aiutoPerStampa());
        }
        if (str.equals("passa")) {
            g.schermo.stampaln(this.aiutoPerPassa());
        }
        if (str.equals("aiuto")) {
            g.schermo.stampaln(this.aiutoPerAiuto());
        }
        if (str.equals("versione")) {
            g.schermo.stampaln(this.aiutoPerVersione());
        }
    }

    private String aiutoPerAttacca() {
        return "Attacca un territorio avversario da un territorio confinante.\nUso: attacca \"territorio_base\" \"territorio_avversario\"";
    }

    private String aiutoPerSposta() {
        return "Sposta un numero valido di proprie armate da un territorio a un altro confinante.\nUso: sposta \"territorio_partenza\" \"territorio_arrivo\"";
    }

    private String aiutoPerEsci() {
        return "Esci da jRisk";
    }

    private String aiutoPerPassa() {
        return "Passa il turno";
    }

    private String aiutoPerStampa() {
        return "Stampa le informazioni su un giocatore, su un territorio oppure l'intero tabellone.\nUso: stampa [tabellone|\"nome_territorio\"|\"nome_giocatore\"]";
    }

    private String aiutoPerAiuto() {
        return "Stampa questa schermata di aiuto.\nUso: aiuto [comando]";
    }

    private String aiutoPerVersione() {
        return "Stampa la versione corrente di jrisk";
    }
}

