/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Giocatore {
    private String colore;
    private List carte;
    private Set territori;
    private boolean territorioVinto;
    public Display schermo;
    public Parser parser;
    private static int turno = 0;

    public Giocatore(String colore) {
        this.colore = colore;
        this.territori = new HashSet();
        this.schermo = new Display();
        this.parser = new Parser();
        this.carte = new ArrayList();
        this.territorioVinto = false;
    }

    public void setDisplay(Display schermo) {
        this.schermo = schermo;
    }

    public String getColore() {
        return this.colore;
    }

    public List getCarte() {
        return this.carte;
    }

    public void aggiungiCarta(String valore) {
        if (ElencoCarte.cartaValida(valore)) {
            this.carte.add(valore);
        }
        this.territorioVinto = false;
    }

    public void aggiungiCarte(List carte) {
        this.carte.addAll(carte);
    }

    public String rimuoviCarta(String valore) {
        Iterator it = this.carte.iterator();
        while (it.hasNext()) {
            String temp = (String)it.next();
            if (!temp.equals("valore")) continue;
            it.remove();
            return temp;
        }
        return null;
    }

    public List rimuoviTutteLeCarte() {
        Iterator it = this.carte.iterator();
        ArrayList<String> rimosse = new ArrayList<String>();
        while (it.hasNext()) {
            String carta = (String)it.next();
            rimosse.add(carta);
            it.remove();
        }
        return rimosse;
    }

    public int numeroCarte() {
        return this.carte.size();
    }

    public List rimuoviCarteStessoValore(String valore, int n) {
        int occorrenzeValore = Collections.frequency(this.carte, valore);
        if (n <= occorrenzeValore) {
            ArrayList<String> carteRimosse = new ArrayList<String>();
            int i = 0;
            while (i < n) {
                carteRimosse.add(valore);
                this.carte.remove(valore);
                ++i;
            }
        }
        return null;
    }

    public Territorio getTerritorio(String nomeTerritorio) {
        Iterator it = this.territori.iterator();
        while (it.hasNext()) {
            Territorio temp = (Territorio)it.next();
            if (!temp.getNome().equals(nomeTerritorio)) continue;
            return temp;
        }
        return null;
    }

    public Set getTerritori() {
        return this.territori;
    }

    public Territorio rimuoviTerritorio(String nomeTerritorio) {
        Iterator it = this.territori.iterator();
        while (it.hasNext()) {
            Territorio temp = (Territorio)it.next();
            if (!temp.getNome().equals(nomeTerritorio)) continue;
            it.remove();
            return temp;
        }
        return null;
    }

    public void aggiungiTerritorio(Territorio t) {
        this.territori.add(t);
    }

    public void setPuoPescare(boolean haVintoUnTerritorio) {
        this.territorioVinto = haVintoUnTerritorio;
    }

    public boolean getPuoPescare() {
        return this.territorioVinto;
    }

    public static int getTurnoCorrente() {
        return turno;
    }

    public static void aggiornaTurni() {
        ++turno;
    }

    public boolean eliminato() {
        return this.territori.size() == 0;
    }

    public boolean haVinto() {
        return this.territori.size() == ElencoTerritoriContinenti.TERRITORI.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.territori.iterator();
        buffer.append(String.valueOf(this.colore) + " " + this.territori.size() + " territori: ");
        while (it.hasNext()) {
            Territorio temp = (Territorio)it.next();
            buffer.append("\n\t" + temp.getNome() + " " + temp.getArmate() + " armate");
        }
        return buffer.toString();
    }
}

