/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 16-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

/**
 * Contiene l'elenco dei territori. Verifica che il nome di
 * un territorio sia valido, restituisce l'elenco dei
 * territori in formato stringa.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ElencoTerritoriContinenti {
    /** Numero di territori dell'America del Nord */
    private static final int NORDAMERICA = 9;
    /** Numero di territori dell'America del Sud */
    private static final int SUDAMERICA = 4;
    /** Numero di territori dell'Europa */
    private static final int EUROPA = 7;
    /** Numero di territori dell'Africa */
    private static final int AFRICA = 6;
    /** Numero di territori dell'Asia */
    private static final int ASIA = 12;
    /** Numero di territori dell'Oceania */
    private static final int OCEANIA = 4;
    /** Elenco dei territori */
    public final static String TERRITORI[] = {
            "alaska",
            "territoridelnordovest",
            "groenlandia",
            "alberta",
            "ontario",
            "quebec",
            "usaovest",
            "usaest",
            "americacentrale",
            "venezuela",
            "brasile",
            "peru'",
            "argentina",
            "islanda",
            "uk",
            "scandinavia",
            "europanord",
            "europaovest",
            "europasud",
            "ucraina",
            "africanord",
            "egitto",
            "africaest",
            "congo",
            "sudafrica",
            "madagascar",
            "urali",
            "afghanistan",
            "siberia",
            "medioriente",
            "jacuzia",
            "kamchatka",
            "cita",
            "cina",
            "giappone",
            "mongolia",
            "india",
            "siam",
            "indonesia",
            "nuovaguinea",
            "australiaovest",
            "australiaest",
    };
    /** Elenco dei continenti */
    public static final String CONTINENTI[] = {
            "nordamerica",
            "sudamerica",
            "europa",
            "africa",
            "asia",
            "oceania"
    };
    
    /**
     * Restituisce una stringa contenente l'elenco dei
     * nomi validi per i territori.
     * 
     * @return l'elenco dei territori
     */
    public static String elencoTuttiTerritori() {
        int i;
        
    	StringBuffer elenco = new StringBuffer();

    	for (i=0; i<TERRITORI.length-1; i++) {
			elenco.append(TERRITORI[i]);
			elenco. append(", ");
		}
		elenco.append(TERRITORI[i]);
		return elenco.toString();   
    }
    /**
     * Restituisce l'elenco dei continenti in una stringa
     * 
     * @return l'elenco dei continenti in formato <code>String<code>
     */
    public static String elencoTuttiContinenti() {
        int i;
        
    	StringBuffer elenco = new StringBuffer();

    	for (i=0; i<CONTINENTI.length-1; i++) {
			elenco.append(CONTINENTI[i]);
			elenco. append(", ");
		}
		elenco.append(CONTINENTI[i]);
		return elenco.toString();        
    }
    
    /**
     * Verifica che una stringa sia un nome valido per un
     * territorio.
     * 
     * @param nome nome del <code>Territorio</code>
     * @return <code>true</code> se  un nome valido
     */
    public static boolean territorioValido(String nome) {
        for(int i = 0; i < TERRITORI.length; i++) {
            if(TERRITORI[i].equals(nome))
                return true;
        }
        return false; 
    }
    /**
     * Verifica che una stringa sia un nome valido per un
     * continente.
     * 
     * @param nome nome del continente
     * @return <code>true</code> se  un nome valido
     */
    public static boolean continenteValido(String nome) {
        for(int i = 0; i < CONTINENTI.length; i++) {
            if(CONTINENTI[i].equals(nome))
                return true;
        }
        return false;        
    }
    
    /**
     * Restituisce il nome del continente di appartanenza
     * di un territorio.
     * 
     * @param nome nome del <code>Territorio</code>
     * @return il continente di appartenenza
     */
    public static String getContinente(String nome) {
        int pos = 0;
        /* Controlla che sia un nome valido */
        if(territorioValido(nome)) {
            /* Calcola la posizione nell'elenco*/
            for(int i=0; i<TERRITORI.length; i++)
                if(TERRITORI[i].equals(nome))
                    pos = i;
            /* Calcola il nome del continente */    
            if(pos < NORDAMERICA)
                pos = 0;
            else
                if(pos < (NORDAMERICA+SUDAMERICA))
                    pos = 1;
                else
                    if(pos < (NORDAMERICA+SUDAMERICA+EUROPA))
                        pos = 2;
                    else
                        if(pos < NORDAMERICA+SUDAMERICA+EUROPA+AFRICA)
                            pos = 3;
                        else
                            if(pos < NORDAMERICA+SUDAMERICA+EUROPA+AFRICA+ASIA)
                                pos = 4;
                            else
                                pos = 5;
            
            return CONTINENTI[pos];					// restituisce la stringa contenente il nome
        }
        return null;
    }
    
    /**
     * Restituisce il numero di territori che compongono il NordAmerica
     * 
     * @return numero di territori che compongono il NordAmerica
     */
    public static int numeroTerritoriNordAmerica() { return NORDAMERICA; }
    /**
     * Restituisce il numero di territori che compongono il SudAmerica
     * 
     * @return numero di territori che compongono il SudAmerica
     */
    public static int numeroTerritoriSudAmerica() { return SUDAMERICA; }
    /**
     * Restituisce il numero di territori che compongono l'Europa
     * 
     * @return numero di territori che compongono l'Europa
     */
    public static int numeroTerritoriEuropa() { return EUROPA; }
    /**
     * Restituisce il numero di territori che compongono l'Africa
     * 
     * @return numero di territori che compongono l'Africa
     */
    public static int numeroTerritoriAfrica() { return AFRICA; }
    /**
     * Restituisce il numero di territori che compongono l'Asia
     * 
     * @return numero di territori che compongono l'Asia
     */
    public static int numeroTerritoriAsia() { return ASIA; }
    /**
     * Restituisce il numero di territori che compongono l'Oceania
     * 
     * @return numero di territori che compongono l'Oceania
     */
    public static int numeroTerritoriOceania() { return OCEANIA; }
}
