<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_topic extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','post');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XF::tan('post_topic');
  XFUI::ajax_init();
  XFUI::html_head('{:new_topic}');
  $group = XF::get_group();
  $allow_acl = ( XF::access_control('mcp_overview') || $group['g_executive'] ) ? true : false;
  //XF::$tpl->clear_cache('form_post_topic.tpl');
  XF::$tpl->assign('smilie_listing',XFCache::get('simple','smilies'));
  XF::$tpl->assign('post_maximum_weight_listing',XFUI::get_post_weight_list());
  XF::$tpl->assign('default_approvement',XFUI::get_post_approvement());
  XF::$tpl->assign('post_prefix_listing',XFUI::get_post_prefix_list(true));
  XF::$tpl->assign('allow_acl_setting',$allow_acl);
  XF::$tpl->display('form_post_topic.tpl',crc32(XFUI::get_post_approvement().$allow_acl));
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $stage = XF::sanitize_var(XF::ifset($input,'stage',''),'enum','o=,o=preview,o=submit');
  $psw = XF::sanitize_var(XF::ifset($input,'f_weight',1),'int','range=1-5');
  $psp = XF::sanitize_var(XF::ifset($input,'f_prefix',0),'int');
  $pss = XF::sanitize_var(XF::ifset($input,'f_subject',''),'str','length=8-128');
  $psm = XF::sanitize_var(XF::ifset($input,'f_message',''),'strwbr','length=40-'.XF::POST_MAXLEN);
  $pst = XF::sanitize_var(XF::ifset($input,'f_tags',''),'str','okifempty');
  $psa = XF::sanitize_var(XF::ifset($input,'f_acl',''),'str','okifempty,length=0-255');
  $this->gpc = array('stage'=>$stage,'f_weight'=>$psw,'f_prefix'=>$psp,'f_subject'=>$pss,'f_message'=>$psm,
  'f_tags'=>$pst,'f_acl'=>$psa);
  $this->markgpc = array('f_subject','f_message','f_tags','f_acl');
  return true;
  }

  /**
  * preview message text
  * @return string
  * @since 1.0.0
  */
  public function preview(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  return XFParser::message($this->gpc['f_message']);
  }

  /**
  * submit a new topic
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $user = XF::get_user();
    $group = XF::get_group();
    $pp = XFUI::get_post_prefix_list(true);
    $schk = XF::sql_query("SELECT p_u_id FROM ".XF::tbl('post_meta')." WHERE p_is_topic = true
    ORDER BY p_time DESC LIMIT 1 OFFSET 0",'',__METHOD__,__LINE__);
    $lastpost = $schk->fetchObject();
    $schk->closeCursor();
      if ( $this->gpc['f_weight'] > $group['g_max_post_weight'] )
      $this->gpc['f_weight'] = $group['g_max_post_weight'];
      if ( $this->gpc['f_prefix'] !== 0 && !isset($pp[$this->gpc['f_prefix']]) && empty($this->error) )
      $this->error = '{:you_cannot_select_this_prefix}';
      if ( is_object($lastpost) && (bool)$group['g_post_repeat'] === false && (int)$lastpost->p_u_id === XF::vault_query('current_user_id') && empty($this->error) )
      $this->error = '{:not_allowed_to_submit_repeated_posting}';
      if ( !$group['g_executive'] && !XF::access_control('mcp_overview') ){
      $this->gpc['f_message'] = preg_replace('/\[notice\].+?\[\/notice\]/siu','',$this->gpc['f_message']);
      $this->gpc['f_acl'] = '';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_meta'=>'w','post_data'=>'w','tag_meta'=>'w','tag_data'=>'w','user'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::sql_query("INSERT INTO ".XF::tbl('post_meta')." (p_is_topic,p_u_id,p_time,p_weight,p_approved,p_license,p_pp_id,p_subject,p_acl)
      VALUES ('1',:userid,:date,:weight,:approved,:license,:prefixid,:subject,:acl)",
      array('userid'=>array(XF::vault_query('current_user_id'),'int'),
      'date'=>array(XF::vault_query('uts'),'int'),
      'weight'=>array($this->gpc['f_weight'],'int'),
      'approved'=>array((int)XFUI::get_post_approvement(),'str'),
      'license'=>array($user['u_post_license'],'str'),
      'prefixid'=>array($this->gpc['f_prefix'],'int'),
      'subject'=>array($this->gpc['f_subject'],'str'),
      'acl'=>array($this->gpc['f_acl'],'str')),__METHOD__,__LINE__);
      $newpostid = XF::sql_lastId('post_meta.p_id');
        if ( !$newpostid )
        throw new XFE('new post (meta) could not be inserted');
      XF::sql_query("INSERT INTO ".XF::tbl('post_data')." (pd_p_id,pd_time,pd_text) VALUES (:postid,:date,:message)",
      array('postid'=>array($newpostid,'int'),
      'date'=>array(XF::vault_query('uts'),'int'),
      'message'=>array($this->gpc['f_message'],'str')),__METHOD__,__LINE__);
      $newmessid = XF::sql_lastId('post_data.pd_id');
        if ( !$newmessid )
        throw new XFE('new post (data) could not be inserted');
      XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_topic_id = :topicid, p_pd_id = :postid WHERE p_id = :topicid AND p_is_topic = true",
      array('topicid'=>array($newpostid,'int'),
      'postid'=>array($newmessid,'int')),__METHOD__,__LINE__);
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_post_count = u_post_count+1 WHERE u_id = :userid",
      array('userid'=>array(XF::vault_query('current_user_id'),'int')),__METHOD__,__LINE__);
      require_once(XF::vault_query('root_path').'/class.parser.php');
        if ( !XFParser::tag_management($newpostid,$this->gpc['f_tags'],'skip_check') )
        throw new XFE('tags of post could not be set');
        if ( $user['u_auto_bookmark'] ){
        $bmid = XF::sql_query("INSERT INTO ".XF::tbl('user_bookmark')." (uk_u_id,uk_p_id) VALUES (:userid,:postid)",
        array('userid'=>array(XF::vault_query('current_user_id'),'int'),
        'postid'=>array($newpostid,'int')),__METHOD__,__LINE__);
          if ( !$bmid )
          throw new XFE('could not add bookmark for posting "'.$newpostid.'"');
          if ( isset($_SESSION['xf_bookmark']) ){
            if ( !in_array((int)$newpostid,$_SESSION['xf_bookmark'],true) )
            $_SESSION['xf_bookmark'][] = (int)$newpostid;
          }
        }
      XF::logger('info','new_postid',$newpostid,'new_msgid',$newmessid,'is_approved',XF::bool2yn(XFUI::get_post_approvement()));
      XF::statistic('submit_posting');
      XF::sql_transaction('commit');
        if ( XFUI::get_post_approvement() ){
          if ( XF::$tpl->is_cached('overview_recent_posts.tpl') )
          XF::$tpl->clear_cache('overview_recent_posts.tpl');
        XFCache::purge('rss',XF::RSS_LAST);
        }
        else
        XFCache::purge('rss',XF::RSS_MOD_UNAPPROVE);
        if ( $this->gpc['f_prefix'] !== 0 ){
        XF::$tpl->clear_cache('mcp_overview.tpl');
        XF::$tpl->clear_cache('acp_overview_request.tpl');
        }
      XFCache::statistic('post','rebuild');
      XFCache::topic($newpostid,'rebuild');
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_topic($input){
  $a = new XFAction_post_topic();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
    if ( $b['stage'] === 'preview' ){
    XFUI::$ajax_response->assign('f_post_preview','style.display','block');
    XFUI::$ajax_response->assign('f_post_preview','innerHTML',$a->preview());
    }
    elseif ( $b['stage'] === 'submit' ){
    $a->execute();
      if ( $a->get_success() )
      return xfaf_success(XF::link('overview','',false),'{:new_topic_successfully_posted}');
      else
      return xfaf_failure($a->get_error());
    }
  }

?>