/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
/* <![CDATA[ */
var XFJSV_TEMP_COUNTER = 0;
var XFJSV_LIVEDIT_FORM_NAME = 'xf__form_post_';
var XFJSV_LIVEDIT_TEXT_NAME = 'f_message';

function xf_var2arr(input){
o = new Array();
  for ( i = 0 ; i < input.length ; i++ ){
  mod = i/2;
  mod = mod.toString().indexOf('.');
    if ( mod == -1 )
    o[input[i]] = input[i+1];
  }
return o;
}

function xf_clock(){
v = new Date();
document.getElementById('xf__clock').innerHTML = v.toLocaleString();
window.setTimeout('xf_clock()',5000);
}

function xf_dosubmit(turn){
  if ( turn == 1 && !XFJSV_DEBUG ){
  document.getElementById('xf__sbtn').disabled = true;
  document.getElementById('xf__sbtn').style.opacity = '0.2';
  }
  else if ( turn == -1 && !XFJSV_DEBUG ){
  document.getElementById('xf__sbtn').disabled = false;
  document.getElementById('xf__sbtn').style.opacity = '1';
  }
}

function xf_hash_password(fname,doclear){
a = hex_sha1(document.getElementById(fname).value);
document.getElementById(fname+'_hash').value = hex_sha1(a);
  if ( doclear === 1 )
  document.getElementById(fname).value = '';
}

function xf_visibility(objname,useopt){
  if ( useopt == '' ){
  olds = document.getElementById(objname).style.display;
    if ( olds == 'block' )
    news = 'none';
    else if ( olds == 'none' )
    news = 'block';
  }
  else
  news = useopt;
document.getElementById(objname).style.display=news;
}

function xf_addsysmsg(msg){
xf_visibility('xf__acp_system_message','block');
a = document.getElementById('xf__acp_system_message').innerHTML;
  if ( a.length == 0 )
  b = '';
  else
  b = '<hr />';
document.getElementById('xf__acp_system_message').innerHTML = a+b+msg;
}

function xf_post_form_acl(acl){
  if ( acl == '' ){
  document.getElementById('f_acl').value = '';
  document.getElementById('f_acl').disabled = false;
  }
  else{
  document.getElementById('f_acl').value = acl;
  document.getElementById('f_acl').disabled = true;
  }
}

function xf_msghook(fname){
  if ( fname.createTextRange )
  fname.caretPos = document.selection.createRange().duplicate();
xf_msglength(fname);
}

function xf_msglength(fname){
XFJSV_TEMP_COUNTER++;
  if ( XFJSV_TEMP_COUNTER === Math.round(XFJSV_POST_MAXLEN/50) ){
  XFJSV_TEMP_COUNTER = 0;
  xf_msgthreshold(fname);
  }
}

function xf_msgthreshold(fname){
clen = document.getElementById(fname).value.length;
pct = Math.round((clen/XFJSV_POST_MAXLEN)*100);
  if ( pct > 100 )
  pct = 100;
  if ( pct === 100 )
  ibc = '#000';
  else if ( pct >= 80 )
  ibc = '#f00';
  else if ( pct >= 60 )
  ibc = '#f90';
  else if ( pct >= 40 )
  ibc = '#ff0';
  else if ( pct >= 20 )
  ibc = '#9f0';
  else
  ibc = '#0f0';
document.getElementById('xf__msgfill__'+fname).style.width = pct+'%';
document.getElementById('xf__msgfill__'+fname).style.backgroundColor = ibc;
}

function xf_bbcode_insert(text,popup){
  if ( popup )
  textarea = window.opener.document.forms[XFJSV_LIVEDIT_FORM_NAME].elements[XFJSV_LIVEDIT_TEXT_NAME];
  else
  textarea = document.forms[XFJSV_LIVEDIT_FORM_NAME].elements[XFJSV_LIVEDIT_TEXT_NAME];

  if ( textarea.createTextRange && !isNaN(textarea.caretPos) ){
  caret_pos = textarea.caretPos;
  caret_pos.text = caret_pos.text.charAt(caret_pos.text.length - 1) === ' ' ? caret_pos.text + text + ' ' : caret_pos.text + text;
  }
  else if ( !isNaN(textarea.selectionStart) ){
  sel_start = textarea.selectionStart;
  sel_end = textarea.selectionEnd;
  xf_mozWrap(textarea,text,'');
  textarea.selectionStart = sel_start + text.length;
  textarea.selectionEnd = sel_end + text.length;
  }
  else
  textarea.value = textarea.value + text;
}

function xf_bbcode_replace(opentag,closetag,popup){
  if ( popup )
  textarea = window.opener.document.forms[XFJSV_LIVEDIT_FORM_NAME].elements[XFJSV_LIVEDIT_TEXT_NAME];
  else
  textarea = document.forms[XFJSV_LIVEDIT_FORM_NAME].elements[XFJSV_LIVEDIT_TEXT_NAME];
ua = navigator.userAgent.toLowerCase();
textarea.focus();
  if ( (ua.indexOf('msie')!==-1) && (ua.indexOf('opera')===-1) ){
  selection = document.selection.createRange().text;
    if ( selection ){
    document.selection.createRange().text = opentag + selection + closetag;
    textarea.focus();
    selection = '';
    return;
    }
  }
  else if ( textarea.selectionEnd && ( textarea.selectionEnd - textarea.selectionStart > 0 ) ){
  xf_mozWrap(textarea,opentag,closetag);
  textarea.focus();
  selection = '';
  return;
  }
xf_bbcode_insert(opentag+closetag);
textarea.focus();
xf_msghook(textarea);
return;
}

/**
* From http://www.massless.org/mozedit/
*/
function xf_mozWrap(textarea,open,close){
selLength = textarea.textLength;
selStart = textarea.selectionStart;
selEnd = textarea.selectionEnd;
scrollTop = textarea.scrollTop;
  if ( selEnd === 1 || selEnd === 2 )
  selEnd = selLength;
s1 = (textarea.value).substring(0,selStart);
s2 = (textarea.value).substring(selStart,selEnd)
s3 = (textarea.value).substring(selEnd,selLength);
textarea.value = s1 + open + s2 + close + s3;
textarea.selectionStart = selEnd + open.length + close.length;
textarea.selectionEnd = textarea.selectionStart;
textarea.focus();
textarea.scrollTop = scrollTop;
return;
}

/* ]]> */