<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_vcard extends XFAction {
/**
* @var integer limit last posting listing to x items (default is 10)
*/
const LIMIT_LASTPOST = 10;
/**
* @var integer limit log entries shown to executives to x items (default is 50)
*/
const LIMIT_LOG_ENTRIES = 50;
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','ucp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $uid = XF::sanitize_var(XF::ifset('get','user',XF::vault_query('current_user_id')),'int');
  $this->gpc = array('uid'=>$uid);

  $user = XF::get_user($this->gpc['uid']);
    if ( !$user )
    XFUI::html_redirect(-1,XF::link('overview'));
  $group = XF::get_group('*');
  $cg = XF::vault_query('current_group_id');
  $user['__warning_lvl'] = XFUI::i18n('warning_level_'.$user['u_warning_level']);
  $user['__rating'] = '';
  $posts = array();
  $ipdb = array();
  $log = '';

    if ( $user['u_rating_bonus'] !== 0 ){
    $img = ( $user['u_rating_bonus'] < 0 ) ? 'vote_negative' : 'vote_positive';
      for ( $a = 1 ; $a <= floor(abs($user['u_rating_bonus'])/2) ; $a++ )
      $user['__rating'] .= '<img src="'.XFUI::image($img).'" alt="user rating: '.$user['u_rating_bonus'].'" />';
    }

  $slpo = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
    WHERE p_u_id = :userid AND p_approved = true ORDER BY p_time DESC LIMIT ".self::LIMIT_LASTPOST." OFFSET 0",array('userid'=>array($this->gpc['uid'],'int')),__METHOD__,__LINE__);
    while ( $r = $slpo->fetchObject() ){
    $r->p_id = intval($r->p_id);
    $posts[] = (array)$r;
    }
  $slpo->closeCursor();

    if ( $group[$cg]['g_executive'] ){
    $data = array();
    XFUI::load_lang_res('','acp');
    XFUI::load_lang_res('','acpacl');
    $slog = XF::sql_query("SELECT * FROM ".XF::tbl('log')." WHERE l_u_id = :userid
    ORDER BY l_time DESC LIMIT ".self::LIMIT_LOG_ENTRIES." OFFSET 0",array('userid'=>array($this->gpc['uid'],'int')),__METHOD__,__LINE__);
      while ( $r = $slog->fetchObject() ){
      $action = explode(',',$r->l_action);
      $user2 = XF::get_user($r->l_u_id);
      $r->l_ip = long2ip($r->l_ip);
      $r->u_name = $user2['u_name'];
      $r->g_name = $group[$user2['u_group']]['g_name'];
      $r->g_color = $group[$user2['u_group']]['g_color'];
      $r->level_str = 'log_level_'.$r->l_level;
      $r->method = $action[0];
      $r->action = $action[1];
      $r->action_str = 'acl_seg_'.$r->action;
      XF::logger_parse_message($r);
      unset($r->l_action);
      $data[] = (array)$r;
      }
    $slog->closeCursor();
    XF::$tpl->clear_cache('acp_log_results.tpl');
    XF::$tpl->assign('log_date_class','full');
    XF::$tpl->assign('log_listing',$data);
    $log = trim(XF::$tpl->fetch('acp_log_results.tpl'));
    XF::reset_tpl();
    unset($data,$user2);

    $slog = XF::sql_query("SELECT DISTINCT(l_ip) AS l_ip FROM ".XF::tbl('log')." WHERE l_u_id = :userid
    ORDER BY l_ip ASC",array('userid'=>array($this->gpc['uid'],'int')),__METHOD__,__LINE__);
      while ( $r = $slog->fetchObject() ){
      $r->l_ip = long2ip($r->l_ip);
      $subnet = substr($r->l_ip,0,strrpos($r->l_ip,'.'));
      $ipdb[$subnet][] = $r->l_ip;
      }
    $slog->closeCursor();
    }

  XFUI::html_head('{:visiting_card}');
  XF::$tpl->clear_cache('vcard.tpl');
  XF::$tpl->assign('user_data',$user);
  XF::$tpl->assign('group_data',$group[$user['u_group']]);
  XF::$tpl->assign('last_posts',$posts);
  XF::$tpl->assign('executive_mode',$group[$cg]['g_executive']);
  XF::$tpl->assign('log_entries',$log);
  XF::$tpl->assign('ip_database',$ipdb);
  XF::$tpl->display('vcard.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * visiting card for an user (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}

?>