<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFCache provides an abstraction for caching organized in pools
* @package lbcore
*/
class XFCache {
/**
* @var integer revision id for topic cache
*/
const TOPIC_CACHE_VERSION = 0x01;
/**
* @var boolean cache enabled?
*/
protected static $enable = false;
/**
* @var string absolute path to cache folder
*/
protected static $dir = '';

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * get current cache folder
  * @return string
  * @since 1.0.0
  */
  public static function getdir(){
  return self::$dir;
  }

  /**
  * set a folder for cache. obviously it has to be writeable...
  * @param string $a full path
  * @return boolean
  * @since 1.0.0
  */
  public static function setdir($a){
  $a = XF::sanitize_var($a,'path');
    if ( !$a )
    return false;
  self::$dir = $a;
  self::$enable = true;

    if ( !is_dir(self::$dir.'/tpl') ){
      if ( is_writeable(self::$dir) )
      mkdir(self::$dir.'/tpl');
      else
      return false;
    }

    if ( !is_dir(self::$dir.'/pool') ){
      if ( is_writeable(self::$dir) )
      mkdir(self::$dir.'/pool');
      else
      return false;
    }

    for ( $i = 0 ; $i <= 32 ; $i++ ){
    $j = str_pad(strtoupper(dechex($i)),2,0,STR_PAD_LEFT);
      if ( !is_dir(self::$dir.'/pool/'.$j) && is_writeable(self::$dir.'/pool') )
      mkdir(self::$dir.'/pool/'.$j);
    }

  return true;
  }

  /**
  * get a resource from cache
  * @param string $a resource class
  * @param string $b resource identifier
  * @param string $c 'read' the content or return modification time 'mtime'
  * @return mixed
  * @since 1.0.0
  */
  public static function get($a,$b = '',$c = 'read'){
  $a = filter_var(strtolower($a),FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9]{3,20}$/D')));
    if ( !self::$enable || ( XF::DEBUG && isset($_GET['NOCACHE']) ) )
    return false;
    if ( !$a )
    return false;
    switch ( $a ){
    case 'simple':
    $f = self::$dir.'/'.preg_replace('/[^a-z0-9_]+/u','',$b).'.txt';
    break;
    default:
    $b = intval($b);
    $md = XF::get_masqueraded_folder($b);
    $f = self::$dir.'/pool/'.$md.'/'.$a.'__'.$b.'.txt';
    break;
    }
    if ( file_exists($f) ){
      if ( $c === 'read' )
      return unserialize(XF::file_handler($f,'','read,local,noroot'));
      elseif ( $c === 'mtime' )
      return filemtime($f);
    }
    else
    return false;
  }

  /**
  * put content to cache
  * @param string $a resource class
  * @param string $b resource identifier
  * @param array $d input stream
  * @return boolean
  * @since 1.0.0
  */
  public static function put($a,$b = '',$d = ''){
  $a = filter_var(strtolower($a),FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9]{3,20}$/D')));
    if ( !self::$enable )
    return false;
    if ( !$a )
    return false;
    switch ( $a ){
    case 'simple':
    $f = self::$dir.'/'.preg_replace('/[^a-z0-9_]+/u','',$b).'.txt';
    break;
    default:
    $b = intval($b);
      if ( !is_dir(self::$dir.'/pool') && is_writeable(self::$dir) )
      mkdir(self::$dir.'/pool');
    $md = XF::get_masqueraded_folder($b);
      if ( !is_dir(self::$dir.'/pool/'.$md) )
      mkdir(self::$dir.'/pool/'.$md);
    $f = self::$dir.'/pool/'.$md.'/'.$a.'__'.$b.'.txt';
    break;
    }
    if ( is_writeable(dirname($f)) && is_array($d) && sizeof($d) > 0 ){
      if ( XF::file_handler($f,serialize($d),'write,local,noroot,verify') )
      return true;
      else
      return false;
    }
  }

  /**
  * remove a resource from cache
  * @param string $a resource class
  * @param string $b resource identifier
  * @return boolean
  * @since 1.0.0
  */
  public static function purge($a,$b = ''){
  $a = filter_var(strtolower($a),FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9]{3,20}$/D')));
    if ( !self::$enable )
    return false;
    if ( !$a )
    return false;
    switch ( $a ){
    case 'simple':
    $f = self::$dir.'/'.preg_replace('/[^a-z0-9_]+/u','',$b).'.txt';
    XF::file_handler($f,'','delete,local,noroot');
    break;
    default:
      if ( is_numeric($b) ){
      $b = intval($b);
      $md = XF::get_masqueraded_folder($b);
      $f = self::$dir.'/pool/'.$md.'/'.$a.'__'.$b.'.txt';
      XF::file_handler($f,'','delete,local,noroot');
      }
      else{
      $f1 = scandir(self::$dir.'/pool');
        foreach ( $f1 as $v1 ){
          if ( $v1 === '.' || $v1 === '..' )
          continue;
        $f2 = scandir(self::$dir.'/pool/'.$v1);
          foreach ( $f2 as $v2 ){
            if ( $v2 === '.' || $v2 === '..' )
            continue;
          XF::file_handler(self::$dir.'/pool/'.$v1.'/'.$v2,'','delete,local,noroot');
          }
        }
      }
    break;
    }
  return true;
  }

  /**
  * calculate forum statistics and cache it
  * @param string $a select section: 'post' or 'user'
  * @param string $b options: 'rebuild'
  * @return array
  * @since 1.0.0
  */
  public static function statistic($a,$b = ''){
  $rebuildcache = false;
    switch ( $a ){
    case 'post':
    $f = 'count_post';
    $q = 'SELECT COUNT(p_id) AS rescount,p_approved AS restag FROM '.XF::tbl('post_meta').' GROUP BY p_approved';
    break;
    case 'user':
    $f = 'count_user';
    $q = 'SELECT COUNT(u_id) AS rescount,u_active AS restag FROM '.XF::tbl('user').' WHERE u_id != \''.XF::get_cfg('main_guest_uid').'\' GROUP BY u_active';
    break;
    default: return false;
    }
    if ( $b === 'rebuild' )
    self::purge('simple',$f);
  $o = self::get('simple',$f);
    if ( is_array($o) && sizeof($o) === 2 )
    return $o;
    else
    $rebuildcache = true;

    if ( $rebuildcache ){
    $o = array('approved'=>0,'unapproved'=>0);
    $scnt = XF::sql_query($q,'',__METHOD__,__LINE__);
      while ( $r = $scnt->fetchObject() ){
      ( (bool)$r->restag )
      ? $o['approved'] = intval($r->rescount)
      : $o['unapproved'] = intval($r->rescount);
      }
    $scnt->closeCursor();
    }
    if ( XF::get_cfg('cache_main') && $rebuildcache )
    self::put('simple',$f,$o);
  return $o;
  }

  /**
  * fetches topic data from cache pool
  * if multiple are requested, they are precached *without* returning (use '*' for all)
  * only single topic requests are returned from cache!
  * @param integer $a topic id, single or multiple separated by comma
  * @param string $b options: 'rebuild'
  * @return mixed
  * @since 1.0.0
  */
  public static function topic($a,$b = ''){
  static $localcache = array();
  static $debug = false;
  static $raw = array(
  '_'=>self::TOPIC_CACHE_VERSION,'topicid'=>0,
  'attr'=>array('closed'=>false,'prefix'=>0,'acl'=>'','subject'=>''),
  'tree'=>array(),'time'=>array(),'rating'=>array(),'user'=>array('trunk'=>array())
  );
    if ( !XF::chksum_query('get','topiccache') )
    XF::chksum_query('put','topiccache',XF::hash_cache_keys(array(
    '_','topicid','attr','tree','time','rating','user'),false));
    if ( !is_array($a) )
    $a = array($a);
    foreach ( $a as $k=>$v )
    $a[$k] = intval($v);
    if ( sizeof($a) > 1 )
    $a = array_unique($a);

    if ( sizeof($a) === 1 && $a[0] !== 0 && $b !== 'rebuild' ){
      if ( isset($localcache[$a[0]]) )
      return $localcache[$a[0]];
    $cd = self::get('topic',$a[0]);
      if ( is_array($cd) && XF::hash_cache_keys($cd) === XF::chksum_query('get','topiccache') && $cd['_'] === self::TOPIC_CACHE_VERSION ){
        if ( (int)$cd['topicid'] !== $a[0] )
        $cd['topicid'] = $a[0];
      $localcache[$a[0]] = $cd;
      return $cd;
      }
    }
    elseif ( sizeof($a) === 0 )
    return true;

  $data = $raw;
  $qw = ( !$a[0] )
  ? 'WHERE true'
  : 'WHERE p_topic_id IN ('.implode(',',$a).')';
  $spsc = XF::sql_query("SELECT p_id,p_is_topic,p_topic_id,p_u_id,p_approved,p_closed,p_rating,p_time,p_subject,p_pp_id,p_acl
  FROM ".XF::tbl('post_meta')." ".$qw." ORDER BY p_topic_id ASC, p_is_topic DESC, p_time ASC",'',__METHOD__,__LINE__);
    if ( $spsc->rowCount() === 0 )
    return false;
    while ( $r = $spsc->fetchObject() ){
    $r->p_id = intval($r->p_id);
    $r->p_is_topic = (bool)$r->p_is_topic;
    $r->p_topic_id = intval($r->p_topic_id);
      if ( $debug )
      D($r,str_repeat('=',80));
      if ( !isset($c) ){ // init the data on the first iteration!
      $c = $r;
      $data['topicid'] = $r->p_id;
      }

      if ( $c->p_topic_id !== $r->p_topic_id && $r->p_is_topic ){
        if ( $debug )
        D($data,$c->p_topic_id);
        if ( XF::get_cfg('cache_topic') && $c->p_id !== 0 )
        self::put('topic',$c->p_topic_id,$data);
      $data = $raw;
      }

    $data['tree'][$r->p_id] = ( (bool)$r->p_approved ) ? '+' : '-';
    $data['time'][$r->p_id] = intval($r->p_time);
      if ( (int)$r->p_rating !== 0 )
      $data['rating'][$r->p_id] = (int)$r->p_rating;
      if ( !in_array((int)$r->p_u_id,$data['user']['trunk'],true) )
      $data['user']['trunk'][] = (int)$r->p_u_id;
      if ( $r->p_is_topic ){
      $data['attr']['subject'] = $r->p_subject;
      $data['attr']['closed'] = (bool)$r->p_closed;
      $data['attr']['prefix'] = (int)$r->p_pp_id;
      $data['attr']['acl'] = $r->p_acl;
      }
    $data['user'][$r->p_id] = (int)$r->p_u_id;
    $c = $r;
    }
  $spsc->closeCursor();
    if ( $debug )
    D($data,$c->p_topic_id);
    if ( XF::get_cfg('cache_topic') && $c->p_topic_id !== 0 )
    self::put('topic',$c->p_topic_id,$data);
    if ( sizeof($a) === 1 && $a[0] )
    return $data;
    else
    return true;
  }

  /**
  * make changes on topic cache without rebuilding it
  * @param array $cache resource array from XFCache::topic()
  * @param string $op operations: add_reply, remove_reply, change_lock, change_attribute, change_rate
  * @param array $data input data stream
  * @return boolean
  * @since 1.0.0
  */
  public static function topic_delta(&$cache,$op,$data){
    if ( !is_array($cache) || XF::hash_cache_keys($cache) !== XF::chksum_query('get','topiccache') )
    return false;
    switch ( strtolower($op) ){
    case 'add_reply':
      if ( isset($data['id']) && isset($data['approve']) && isset($data['time']) && isset($data['user']) ){
      $cache['tree'][(int)$data['id']] = ( $data['approve'] ) ? '+' : '-';
      $cache['time'][(int)$data['id']] = (int)$data['time'];
      $cache['user'][(int)$data['id']] = (int)$data['user'];
        if ( !in_array((int)$data['user'],$cache['user']['trunk'],true) )
        $cache['user']['trunk'][] = (int)$data['user'];
      }
    break;
    case 'remove_reply':
      if ( isset($data['id']) ){
        if ( (int)$data['id'] !== $cache['topicid'] ){
        $nt = array();
        unset($cache['tree'][(int)$data['id']]);
        unset($cache['time'][(int)$data['id']]);
        unset($cache['user'][(int)$data['id']]);
          foreach ( $cache['user'] as $k=>$v ){
            if ( is_integer($k) )
            $nt[] = $v;
          }
        $cache['user']['trunk'] = array_unique($nt);
        }
      }
    break;
    case 'change_lock':
      if ( isset($data['close']) )
      $cache['attr']['closed'] = (bool)$data['close'];
    break;
    case 'change_approve':
      if ( isset($data['id']) && isset($data['approve']) )
      $cache['tree'][(int)$data['id']] = ( (bool)$data['approve'] ) ? '+' : '-';
    break;
    case 'change_attribute':
      if ( isset($data['prefix']) && isset($data['acl']) && isset($data['subject']) ){
      $cache['attr']['prefix'] = (int)$data['prefix'];
      $cache['attr']['acl'] = $data['acl'];
      $cache['attr']['subject'] = $data['subject'];
      }
    break;
    case 'change_rate':
      if ( isset($data['id']) && isset($data['rate_value']) && isset($data['rate']) ){
      $score = ( $data['rate'] === '+' ) ? $data['rate_value'] : 0-$data['rate_value'];
        if ( !isset($cache['rating'][(int)$data['id']]) )
        $cache['rating'][(int)$data['id']] = 0;
      $cache['rating'][(int)$data['id']] += $score;
      }
    break;
    }
  return true;
  }

}
?>