<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFDebug handles all debugging purposes and requires XF::DEBUG to be 'true'
* @package lbcore
*/
class XFDebug {
/**
* @var array stores any debugging messages in debug mode (XF::DEBUG)
*/
protected static $trace = array();
/**
* @var string background color for next entry
*/
protected static $color = 'fff';

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * put an entry into debug trace (logging)
  * @param string $a description (usually ___METHOD__), null outputs trace
  * @param string $b message
  * @return mixed
  * @since 1.0.0
  */
  public static function trace($a,$b){
  static $bench = null;
    if ( is_null($bench) )
    $bench = XF::vault_query('bench');
    if ( is_null($a) ){
    $d = '<div style="background-color: #000; color: #fff; padding: 3px; overflow: auto; font-size: 75%;">'.chr(10);
    $d .= '-- VERSION: '.XF::VERSION.chr(10);
    $d .= '-- TIME: '.round((double)microtime(true)-$bench,3).'s'.chr(10);
    $d .= '-- MEMORY: emalloc('.memory_get_peak_usage(false).')/real('.memory_get_peak_usage(true).')';
    $d .= '</div>'.chr(10);
      foreach ( self::$trace as $v )
      $d .= '<div style="background-color: #'.$v[2].'; color: #000; padding: 3px; overflow: auto; font-size: 75%;">
      <strong>'.htmlspecialchars($v[0]).'</strong><br />'.chr(10).nl2br(htmlspecialchars($v[1])).chr(10).chr(10).'</div><hr />';
      if ( $b === 'return' )
      return $d;
    XF::terminate($d);
    }
    else
    self::$trace[] = array('» [+'.round((double)microtime(true)-$bench,3).'s] '.$a,$b,self::$color);
  return true;
  }

  /**
  * sets background color for trace view
  * @param string $a color in hexadecimal without #
  * @return true
  * @since 1.0.0
  */
  public static function settracecolor($a){
    if ( preg_match('/^[0-9a-f]{3,6}$/Du',$a) )
    self::$color = $a;
  return true;
  }

  /**
  * builds todo list from source files and adds it to debug trace
  * format is '// TODO: [priority] message' or '* @todo [priority] message'
  * @return true
  * @since 1.0.0
  */
  public static function todo(){
  $d = array();
  $z = array('idle'=>array(),'low'=>array(),'medium'=>array(),'high'=>array());
  $dir = scandir(XF::vault_query('root_path'));
    foreach ( $dir as $v ){
    $b = array();
      if ( substr($v,-4) === '.php' ){
      $a = file_get_contents(XF::vault_query('root_path').'/'.$v);
      preg_match_all('=(?://\s+TODO:|\*\s+@todo)\s+\[(\w+)\]\s+(.+)=u',$a,$b);
        if ( sizeof($b[0]) > 0 ){
          foreach ( $b[0] as $k=>$__unused )
          $z[$b[1][$k]][] = '['.$b[1][$k].'] '.$v.' » '.$b[2][$k];
        }
      }
    }
  $d = array_merge($z['idle'],$z['low'],$z['medium'],$z['high']);
  $a = self::$color;
  self::settracecolor('f90');
  self::trace('This is our little ToDo-List :)',implode(chr(10),$d));
  self::settracecolor($a);
  return true;
  }

  /**
  * set a mesure point for profiling. use multiple to have differences between them.
  * @author kroczu <kroczu@interia.pl>
  * @link http://docs.php.net/manual/en/function.debug-backtrace.php
  * @return integer
  * @since 1.0.0
  */
  public static function prof(){
  static $st = null;
  static $scl = 0;
  $dbt = debug_backtrace();
  $ci = array_shift($dbt);
  $cl = $ci['line'];
  $ecl = explode('/',$ci['file']);
  $f = array_pop($ecl);
    if ( is_null($st) ){
    echo 'prof '.$f.' > initialize<br />';
    $st = time()+microtime();
    $scl = $cl;
    return 0;
    }
  printf('prof(): %s > code-lines: %d-%d time: %.4f mem: %d KB<br />',$f,$scl,$cl,(time()+microtime()-$st),ceil(memory_get_usage()/1024));
  $st = time()+microtime();
  $scl = $cl;
  return 1;
  }

  /**
  * do a hex dump of input
  * @author Aidan Lister <aidan@php.net>
  * @author Peter Waller <iridum@php.net>
  * @link http://aidanlister.com/repos/v/function.hexdump.php
  * @param string $data input stream
  * @param boolean $htmloutput format output in HTML
  * @param boolean $uppercase uppercase hex
  * @param boolean $return return or echo the results?
  * @return string
  * @since 1.0.0
  * @version 1.3.2
  */
  // just modified to colorize 0x00-0x1f in output
  public static function hexdump($data,$htmloutput = true,$uppercase = false,$return = false){
  // Init
  $hexi = '';
  $ascii = '';
  $dump = ( $htmloutput ) ? '<pre>' : '';
  $offset = 0;
  $len = strlen($data);

  // Upper or lower case hexidecimal
  $x = ( !$uppercase ) ? 'x' : 'X';

    // Iterate string
    for ( $i = $j = 0 ; $i < $len ; $i++ ){
    // Convert to hexidecimal
    $hexi .= ( ord($data[$i]) < 32 )
    ? sprintf('<span style="color: #f00; font-weight: bold;">%02'.$x.'</span> ',ord($data[$i]))
    : sprintf('%02'.$x.' ',ord($data[$i]));

      // Replace non-viewable bytes with '.'
      if ( ord($data[$i]) >= 32 ){
      $ascii .= ( $htmloutput )
      ? htmlspecialchars($data[$i])
      : $data[$i];
      }
      else
      $ascii .= '<span style="color: #f00;">.</span>';

      // Add extra column spacing
      if ( $j === 7 ){
      $hexi  .= ' ';
      $ascii .= ' ';
      }

      // Add row
      if ( ++$j === 16 || $i === $len-1 ){
      // Join the hexi / ascii output
      $dump .= sprintf('%04'.$x.'  %-49s  %s',$offset,$hexi,$ascii);

      // Reset vars
      $hexi   = $ascii = '';
      $offset += 16;
      $j      = 0;

        // Add newline
        if ( $i !== $len-1 )
        $dump .= "\n";
      }

    }

  // Finish dump
  $dump .= ( $htmloutput ) ? '</pre>' : '';
  $dump .= "\n";

    // Output method
    if ( $return )
    return $dump;
    else
    echo $dump;
  }

}
?>