<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_acl_edit extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $this->gpc = $input;
  return true;
  }

  /**
  * edit an access control entry
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $process = array();
      foreach ( $this->gpc as $k=>$v ){
        if ( preg_match('/^f_(\d+)_allow$/Du',$k,$v) )
        $process[] = intval($v[1]);
      }
      if ( sizeof($process) === 0 )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('acl'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $sacl = XF::sql_query("SELECT a_id,a_action,a_use_group,a_key FROM ".XF::tbl('acl')." WHERE a_id IN (".implode(',',$process).")",'',__METHOD__,__LINE__);
      $process = array('info');
        while ( $r = $sacl->fetchObject() ){
          if ( (bool)$r->a_use_group )
          $key = (int)$r->a_key;
          else{
          $key = ( isset($this->gpc['f_'.(int)$r->a_id.'_key']) ) ? (int)$this->gpc['f_'.(int)$r->a_id.'_key'] : 0;
            if ( $key === 0 || !XF::get_user($key) )
            continue;
          }
        $allow = intval($this->gpc['f_'.(int)$r->a_id.'_allow']);
        XF::sql_query("UPDATE ".XF::tbl('acl')." SET a_key = :key, a_allow = :allow WHERE a_id = :id",array(
        'id'=>array($r->a_id,'int'),
        'key'=>array($key,'int'),
        'allow'=>array($allow,'int')),__METHOD__,__LINE__);
        $process[] = 'id';
        $process[] = $r->a_id;
        $process[] = 'action';
        $process[] = $r->a_action;
        $process[] = 'allow';
        $process[] = XF::bool2yn($allow);
        XFCache::purge('acl',crc32($r->a_action));
        }
      $sacl->closeCursor();
      XF::logger($process);
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_acl_edit($input){
  $a = new XFAction_acp_acl_edit();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_acl_list','',false),'{:edit_acl_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>