<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_group_new extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XF::tan('acp_group_new');
  XFUI::ajax_init();
  XFUI::html_head('{:user_group}');
  //XF::$tpl->clear_cache('form_acp_group_new.tpl');
  XF::$tpl->assign('weight_listing',array(1,2,3,4,5));
  XF::$tpl->assign('group_listing',XF::get_group('*'));
  XF::$tpl->display('form_acp_group_new.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $name = XF::sanitize_var(XF::ifset($input,'f_name',''),'str','stripspaces,length=4-32');
  $color = XF::sanitize_var(XF::ifset($input,'f_color','000000'),'color','forcestr');
  $weight = XF::sanitize_var(XF::ifset($input,'f_weight',1),'int','range=1-5');
  $copy_acl = XF::sanitize_var(XF::ifset($input,'f_copy_acl',1),'int');
  $perm_pa = XF::sanitize_var(XF::ifset($input,'f_perm_pa',0),'booli');
  $perm_pr = XF::sanitize_var(XF::ifset($input,'f_perm_pr',0),'booli');
  $perm_ra = XF::sanitize_var(XF::ifset($input,'f_perm_ra',0),'booli');
  $perm_ex = XF::sanitize_var(XF::ifset($input,'f_perm_ex',0),'booli');
  $this->gpc = array('f_name'=>$name,'f_color'=>$color,'f_weight'=>$weight,'f_copy_acl'=>$copy_acl,
  'f_perm_pa'=>$perm_pa,'f_perm_pr'=>$perm_pr,'f_perm_ra'=>$perm_ra,'f_perm_ex'=>$perm_ex);
  $this->markgpc = array('f_name','f_color');
  return true;
  }

  /**
  * create a new user group
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $group_data = XF::get_group($this->gpc['f_copy_acl']);
      if ( !$group_data )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('acl'=>'w','group'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::sql_query("INSERT INTO ".XF::tbl('group')." (g_name,g_color,g_max_post_weight,g_post_approved,g_post_repeat,g_read_unapproved,g_executive)
      VALUES (:name,:color,:weight,:perm_pa,:perm_pr,:perm_ra,:perm_ex)",array(
      'name'=>array($this->gpc['f_name'],'str'),
      'color'=>array($this->gpc['f_color'],'str'),
      'weight'=>array($this->gpc['f_weight'],'int'),
      'perm_pa'=>array($this->gpc['f_perm_pa'],'str'),
      'perm_pr'=>array($this->gpc['f_perm_pr'],'str'),
      'perm_ra'=>array($this->gpc['f_perm_ra'],'str'),
      'perm_ex'=>array($this->gpc['f_perm_ex'],'str')),__METHOD__,__LINE__);
      $newgid = XF::sql_lastId('group.g_id');
        if ( !$newgid )
        throw new XFE('cannot insert new group');
      $sacl = XF::sql_query("SELECT a_action,a_allow FROM ".XF::tbl('acl')."
      WHERE a_key = :group AND a_use_group = true GROUP BY a_action,a_allow",array('group'=>array($this->gpc['f_copy_acl'],'int')),__METHOD__,__LINE__);
        while ( $r = $sacl->fetchObject() ){
        XF::sql_query("INSERT INTO ".XF::tbl('acl')." (a_action,a_key,a_use_group,a_allow) VALUES (:action,:key,:usegroup,:allow)",array(
        'action'=>array($r->a_action,'str'),
        'key'=>array($newgid,'int'),
        'usegroup'=>array('1','str'),
        'allow'=>array((int)$r->a_allow,'int')
        ),__METHOD__,__LINE__);
        XFCache::purge('acl',crc32($r->a_action));
        }
      $sacl->closeCursor();
      XF::logger('info','new_id',$newgid);
      XF::sql_transaction('commit');
      XFCache::purge('simple','group');
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_group_new($input){
  $a = new XFAction_acp_group_new();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_group_list','',false),'{:new_group_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>