<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_reauth extends XFAction {
const USE_TAN = false;
/**
* @var integer how often can a session be reauthenticated? (default is 3)
*/
const LIMIT_REFRESH_TOKEN = 3;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','login');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
    if ( $_SESSION['xf_generation'] >= self::LIMIT_REFRESH_TOKEN )
    XFUI::html_redirect(-1,XF::link('logout')); // do not allow reauth forever :)
    if ( XF::vault_query('request_method') === 'POST' ){
    $this->gpc['f_pass'] = XF::sanitize_var(XF::ifset('post','f_pass_hash',''),'str','restrict');
    return $this->execute();
    }
  XFUI::html_head('{:reauth}');
  XF::$tpl->clear_cache('form_reauth.tpl');
  XF::$tpl->assign('reauth_reason',XFUI::lang_str('{:'.__XF_AUTH_IS_TAINTED.'}'));
  XF::$tpl->display('form_reauth.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * refresh authentication of user session
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  require_once(XF::vault_query('root_path').'/class.auth.php');
  $auth = XFAuth::check(XF::vault_query('current_user_id'),$this->gpc['f_pass']);

    if ( $auth['login_fail'] >= XF::get_cfg('auth_max_faillogin') ){
    $_SESSION['xf_authentication']['status'] = 'expired';
    XFUI::html_redirect(0,XF::link('reauth'),'{:reauth_failed}');
    return false;
    }

    if ( $auth['valid_password'] ){
      try {
        if ( !XF::sql_transaction('begin',array('user'=>'w')) )
        throw new XFE('unable to begin database transaction');
        if ( !headers_sent() && session_id() ){
        $token = XF::token(8);
        $_SESSION['xf_authentication'] = array( // refresh authentication...
        'id'=>$auth['id'],
        'status'=>'clear',
        'username'=>$auth['username'],
        'password'=>'*',
        'token'=>$token,
        'time'=>XF::vault_query('uts'),
        'client_hash'=>XF::vault_query('client_hash'),
        'ip'=>sha1(XF::vault_query('client_ip'))
        );
        $_SESSION['xf_tan'] = array();
        $_SESSION['xf_generation']++;
        $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_login_token = :token, u_login_fail = 0 WHERE u_id = :id",array(
        'id'=>array($auth['id'],'int'),
        'token'=>array($token,'int')),__METHOD__,__LINE__);
          if ( !$u )
          throw new XFE('could not update dataset for user "'.$this->gpc['id'].'"');
          if ( isset($_SESSION['xf_reauth_redirect']) ){
          $redirect = XF::link(null,$_SESSION['xf_reauth_redirect']);
          unset($_SESSION['xf_reauth_redirect']);
          }
          else
          $redirect = XF::link('overview');
        XFCache::purge('user',$auth['id']);
        XF::logger('info','userid',$auth['id'],'username',$auth['username'],'generation',$_SESSION['xf_generation']);
        XF::sql_transaction('commit');
        $this->success = true;
        XFUI::html_redirect(1,$redirect,'{:reauth_success}');
        }
        else
        XFUI::html_redirect(0,XF::link('reauth'),'{:reauth_failed}');
      } catch ( XFE $E ){ session_destroy(); $E->handle(); if ( $E->check_abort() ) return false; }
    }
    else{
      if ( $auth['id'] && $auth['login_fail'] < XF::get_cfg('auth_max_faillogin') ){
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_login_fail = u_login_fail+1 WHERE u_id = :id",
      array('id'=>array($auth['id'],'int')),__METHOD__,__LINE__);
      XFCache::purge('user',$auth['id']);
      }
    XFUI::html_redirect(0,XF::link('reauth'),'{:reauth_failed}');
    }
  return true;
  }

}
?>