CREATE TABLE "{$PREFIX}acl" (
  "a_id" serial primary key,
  "a_action" varchar(32) not null default '',
  "a_key" int not null default '0',
  "a_use_group" boolean not null default 'true',
  "a_allow" boolean not null default 'false'
);/*###*/

CREATE TABLE "{$PREFIX}config" (
  "c_id" varchar(32) primary key,
  "c_value" varchar(255) not null default ''
);/*###*/

CREATE TABLE "{$PREFIX}config_task" (
  "ct_command" varchar(16) primary key,
  "ct_parameter" varchar(255) not null default '',
  "ct_time_last" int not null default '0',
  "ct_time_interval" int not null default '0',
  "ct_active" boolean not null default 'true'
);/*###*/

CREATE TABLE "{$PREFIX}group" (
  "g_id" serial primary key,
  "g_name" varchar(32) not null default '',
  "g_color" varchar(6) not null default '000000',
  "g_max_post_weight" smallint not null default '1',
  "g_post_approved" boolean not null default 'true',
  "g_post_repeat" boolean not null default 'false',
  "g_post_filter" boolean not null default 'false',
  "g_read_unapproved" boolean not null default 'false',
  "g_executive" boolean not null default 'false'
);/*###*/

CREATE TABLE "{$PREFIX}log" (
  "l_u_id" int not null default '0',
  "l_time" int not null default '0',
  "l_index_month" int not null default '0',
  "l_index_year" int not null default '0',
  "l_level" varchar(8) check (l_level in ('system','info','error')) not null default 'info',
  "l_action" varchar(32) not null default '',
  "l_ip" varchar(44) not null default '',
  "l_text" text not null default ''
);/*###*/

CREATE TABLE "{$PREFIX}post_data" (
  "pd_id" serial primary key,
  "pd_p_id" int not null default '0',
  "pd_time" int not null default '0',
  "pd_spam_marker" int not null default '0',
  "pd_edit_u_id" int not null default '0',
  "pd_edit_reason" varchar(128) not null default '',
  "pd_is_last" boolean not null default 'true',
  "pd_text" text not null
);/*###*/

CREATE TABLE "{$PREFIX}post_meta" (
  "p_id" serial primary key,
  "p_is_topic" boolean not null default 'true',
  "p_topic_id" int not null default '0',
  "p_pd_id" int not null default '0',
  "p_u_id" int not null default '0',
  "p_pp_id" int not null default '0',
  "p_time" int not null default '0',
  "p_weight" smallint not null default '0',
  "p_rating" smallint not null default '0',
  "p_approved" boolean not null default 'true',
  "p_closed" boolean not null default 'false',
  "p_license" varchar(6) not null default 'none',
  "p_subject" varchar(128) not null default '',
  "p_acl" varchar(255) not null default ''
);/*###*/

CREATE TABLE "{$PREFIX}post_prefix" (
  "pp_id" serial primary key,
  "pp_name" varchar(64) not null default '',
  "pp_preset_acl" varchar(255) not null default '',
  "pp_list_as_request" boolean not null default 'false'
);/*###*/

CREATE TABLE "{$PREFIX}post_rating" (
  "pr_p_id" int not null default '0',
  "pr_u_id" int not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}search_result" (
  "sr_hash" int not null default '0',
  "sr_time" int not null default '0',
  "sr_p_id" int not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}statistic" (
  "st_day" smallint not null,
  "st_month" smallint not null,
  "st_year" smallint not null,
  "st_login_attempt" int not null default '0',
  "st_login_success" int not null default '0',
  "st_account_register" int not null default '0',
  "st_account_activation" int not null default '0',
  "st_password_request" int not null default '0',
  "st_password_activation" int not null default '0',
  "st_search_query" int not null default '0',
  "st_search_cached" int not null default '0',
  "st_filter_spam" int not null default '0',
  "st_filter_ham" int not null default '0',
  "st_submit_posting" int not null default '0',
  "st_exception" int not null default '0'
);/*###*/
ALTER TABLE ONLY "{$PREFIX}statistic" ADD CONSTRAINT {$PREFIX}statistic_pkey PRIMARY KEY (st_day, st_month, st_year);/*###*/

CREATE TABLE "{$PREFIX}tag_data" (
  "td_t_id" int not null default '0',
  "td_p_id" int not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}tag_meta" (
  "t_id" serial primary key,
  "t_name" varchar(64) not null default ''
);/*###*/

CREATE TABLE "{$PREFIX}user" (
  "u_id" serial primary key,
  "u_active" boolean not null default 'true',
  "u_uuid" varchar(36) not null default '',
  "u_name" varchar(32) not null default '',
  "u_password" varchar(80) not null default '',
  "u_mail" varchar(255) not null default '',
  "u_info" varchar(255) not null default '',
  "u_comment" varchar(255) not null default '',
  "u_warning_level" varchar(6) check (u_warning_level in ('none','low','medium','high')) not null default 'none',
  "u_group" int not null default '1',
  "u_time_registration" int not null default '0',
  "u_time_last_read" int not null default '0',
  "u_rating_bonus" int not null default '0',
  "u_post_count" int not null default '0',
  "u_post_approved" varchar(7) check (u_post_approved in ('default','true','false')) not null default 'default',
  "u_post_license" varchar(6) not null default 'none',
  "u_style" varchar(16) not null default '',
  "u_language" varchar(10) not null default '',
  "u_timezone" varchar(64) not null default '',
  "u_time24h" boolean not null default 'true',
  "u_auto_bookmark" boolean not null default 'false',
  "u_login_annoy" boolean not null default 'false',
  "u_login_liberal" boolean not null default 'false',
  "u_login_token" int not null default '0',
  "u_login_fail" smallint not null default '0',
  "u_login_count" smallint not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}user_blacklist" (
  "ub_u_id_src" int not null default '0',
  "ub_u_id_dst" int not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}user_bookmark" (
  "uk_u_id" int not null default '0',
  "uk_p_id" int not null default '0'
);/*###*/

CREATE TABLE "{$PREFIX}user_request" (
  "ur_class" varchar(17) check (ur_class in ('ACTIVATE_ACCOUNT','ACTIVATE_PASSWORD','REPORT_POSTING')) not null default 'REPORT_POSTING',
  "ur_u_id" int not null default '0',
  "ur_time" int not null default '0',
  "ur_data_int" int not null default '0',
  "ur_data" varchar(255) not null default '',
  "ur_hash" varchar(16) not null default ''
);/*###*/
