<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

  // emulation for unsupported platforms and php < 5.2.1...
  // by: php [spat] hm2k.org @ 22-Aug-2008 01:20
  // http://de3.php.net/manual/de/function.sys-get-temp-dir.php
  // @saturas: changed syntax
  if ( !function_exists('sys_get_temp_dir') ){
    function sys_get_temp_dir(){
      if ( isset($_ENV['TMP']) && !empty($_ENV['TMP']) ){ return realpath($_ENV['TMP']);}
      if ( isset($_ENV['TMPDIR']) && !empty($_ENV['TMPDIR']) ){ return realpath($_ENV['TMPDIR']);}
      if ( isset($_ENV['TEMP']) && !empty($_ENV['TEMP']) ){ return realpath($_ENV['TEMP']);}
    $tf = tempnam(uniqid(rand(),true),'');
      if ( file_exists($tf) ){
      unlink($tf);
      return realpath(dirname($tf));
      }
    }
  }

/**
* XFFilter is an api for filtering identifiers against "spam databases"
* @package lbbackend
*/
class XFFilter {
/**
* @var integer mapped id for User-ID entries
*/
const TYPE_UID = 0x01;
/**
* @var integer mapped id for IP Address entries
*/
const TYPE_IPA = 0x02;
/**
* @var integer mapped id for Message entries
*/
const TYPE_MSG = 0x04;
/**
* @var mixed result cache for later decisions (null=unknown,true=spam,false=ham)
*/
public $result_cache = null;
/**
* @var array the local database
*/
protected static $data = array();
/**
* @var array empty database structure
*/
protected $raw = array('_'=>1,'rrd'=>array());
// rrd version 1 specification
// [numeric key] => array(0=>[str],1=>[int],2=>[int],3=>[str]), ...
//                  0=Hash-ID (sha1), 1=TTL, 2=Bitmask Storage 8-bit, 3=Aux Stream
// Bitmask: 0 0 0 0 0 0 0 0
//          | | | | | | | \---> 0x01 Is UID?
//          | | | | | | \-----> 0x02 Is IPA?
//          | | | | | \-------> 0x04 Is MSG?
//          | | | | \---------> 0x08 RESERVED
//          | | | \-----------> 0x10 RESERVED
//          | | \-------------> 0x20 RESERVED
//          | \---------------> 0x40 RESERVED
//          \-----------------> 0x80 Is Spam?

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * load the database
  * @param none
  * @return true
  * @since 1.1.0
  */
  public function load(){
  $a = XFCache::get('simple','filter');
    if ( is_array($a) ){
      if ( isset($a['_']) && isset($a['rrd']) && is_array($a['rrd']) )
      self::$data = $a;
    }
    else
    self::$data = $this->raw;
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,'version='.self::$data['_'].',rrd_length='.sizeof(self::$data['rrd']));
  return true;
  }

  /**
  * save the database
  * @param none
  * @return boolean
  * @since 1.1.0
  */
  public function save(){
  $a = XFCache::put('simple','filter',self::$data);
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,'success='.XF::bool2yn($a));
  return $a;
  }

  /**
  * check, if a entry is stored in database
  * returns 'true', if spam is detected, 'false' otherwise. 'null' if an error has occured.
  * @param integer $id the sha1-hash as entry id
  * @param integer $type select the type (uid,ipa,msg)
  * @param string $flags available: getifmissing,autosave
  * @return mixed
  * @since 1.1.0
  */
  public function check($id,$type,$flags = ''){
  $flags = explode(',',$flags);
  $o = $this->query($id,$type);
    if ( is_null($o) && in_array('getifmissing',$flags,true) ){
    $s = $this->poll_sink($id,$type);
    //D($s,'sink()');
      if ( is_bool($s) ){
      $this->add($id,$type,$s);
      $o = $s;
      }
    }
    if ( in_array('autosave',$flags,true) )
    $this->save();
  //D($o,'output()');
  return $o;
  }

  /**
  * add a new entry to database
  * @param integer $id the sha1-hash as entry id
  * @param integer $type select the type (uid,ipa,msg)
  * @param boolean $value if 'true' this entry will be marked as spam
  * @return mixed
  * @since 1.1.0
  */
  public function add($id,$type,$value){
  return $this->prepend($id,$type,$value);
  }

  /**
  * dump database to human-readable format
  * @param none
  * @return void
  * @since 1.1.0
  */
  public function dump(){
    if ( isset(self::$data['_']) && self::$data['_'] === 1 ){
    printf('%s','<pre>');
      foreach ( self::$data['rrd'] as $k=>$v ){
      $a = array();
        if ( $v[2]&self::TYPE_UID ){
        $a[] = 'TYPE=UID';
        $a[] = 'UID='.$v[3];
        }
        if ( $v[2]&self::TYPE_IPA ){
        $a[] = 'TYPE=IPA';
        $a[] = 'IP='.$v[3];
        }
        if ( $v[2]&self::TYPE_MSG ){
        $a[] = 'TYPE=MSG';
        $a[] = 'LENGTH='.$v[3];
        }
      $a[] = ( $v[2]&0x80 ) ? 'VALUE=TRUE' : 'VALUE=FALSE';
      printf('%04d  %40s  %s  %s%s',$k,$v[0],gmdate('r',$v[1]),implode(',',$a),chr(10));
      }
    printf('%s','</pre>');
    }
  }

  /**
  * the real dirty work is done here by querying the database
  * @param integer $id the sha1-hash as entry id
  * @param integer $type select the type (uid,ipa,msg)
  * @return mixed
  * @since 1.1.0
  */
  protected function query($id,$type){
  $rid = $this->restrict_id($id,$type);
  $o = null;
    if ( self::$data['_'] === 1 ){
      foreach ( self::$data['rrd'] as $k=>$v ){
        if ( is_null($v[0]) )
        continue;
        if ( $v[1] < XF::vault_query('uts') ){
        $this->remove($k);
        continue;
        }
        if ( $v[0] === $rid && $v[2]&$type ){
        $o = $this->bitmap_to_value($v[2]);
        break;
        }
      }
    }
  return $o;
  }

  /**
  * ask external sources ("sink") for "spam score"
  * currently we have: real-time dns-blacklisting for IPs and scanners for message texts
  * these can be on the local machine (e.g. spamassassin) or an external source (e.g. akismet)
  * @param integer $id the sha1-hash as entry id
  * @param integer $type select the type (uid,ipa,msg)
  * @return mixed
  * @since 1.1.0
  */
  protected function poll_sink($id,$type){
  $o = null;
    switch ( $type ){
    case self::TYPE_UID:
    // currently no sink available...
    return null;
    break;
    case self::TYPE_IPA:
    // query a real-time blasklist by dns
    // NOTE: we do not know how provider handle ipv6 queries. like normal ptr "0.0.0.0.0" or "1234.5678.90ab"?
      if ( !XF::sanitize_var($id,'ip') )
      return null;
    $r = array();
    $iv = ( strstr($id,':') ) ? 6 : 4;
    $li = ( $iv === 4 ) ? '.' : ':';
    $rr = ( $iv === 4 ) ? 'A' : 'AAAA';
    $a = implode($li,array_reverse(explode($li,$id)));
    $s = explode(',',XF::get_cfg('filter_sink_dnsbl_server'));
      foreach ( $s as $v ){
        if ( strlen($v) < 3 )
        continue;
      $b = checkdnsrr($a.'.'.$v.'.',$rr);
      $r[$v] = XF::bool2yn($b);
      $o = $b;
        if ( $b )
        break;
      }
    //D($r);
    $c = ( sizeof($r) > 0 ) ? trim(XF::arr2str($r)) : 'no servers defined';
    $class = 'dnsbl';
    break;
    case self::TYPE_MSG:
    $a = XF::get_cfg('filter_sink_local_class');
    $class = substr($a,0,strpos($a,':'));
    $slp = substr($a,strpos($a,':')+1);
    $curi = '';
    unset($a);
      // forward message to a command line tool (e.g. spamassassin)
      if ( $class === 'exec' ){
        if ( !is_executable($slp) )
        return null;
      $h = array(
      'From: '.XF::get_cfg('mail_from_mail'),
      'To: '.XF::get_cfg('mail_from_mail'),
      'Date: '.gmdate(XF::DATE_RFC822),
      'Subject: Message Forward To Local Filter',
      'Message-Id: <'.strtoupper(XF::token(32,'strict')).'@'.$_SERVER['SERVER_NAME'].'>',
      'Content-Type: text/plain',
      'MIME-Version: 1.0',
      '',
      ''
      );
      $t = tempnam(sys_get_temp_dir(),'lbsink');
      file_put_contents($t,implode(chr(10),$h).$id);
      $c = $slp.' '.XF::get_cfg('filter_sink_local_param').' < '.$t;
      exec($c,$r);
      //D($r,$c);
      $r = implode(chr(10),$r);
      unlink($t);
        if ( stripos($r,'spamassassin') ){
        $lt = XF::get_cfg('filter_threshold');
          if ( $lt > 0 ){
          preg_match('/ score=([0-9\.]+) /i',$r,$r);
          $r = ( sizeof($r) === 2 ) ? doubleval($r[1]) : 0;
          $o = ( $r > $lt ) ? true : false;
          }
          else{
          $o = ( stripos($r,'x-spam-flag: yes') ) ? true : false;
          }
        }
        // NOTE: we can add more filter handlers here...
      } // forward message to an external api by network socket (e.g. akismet)
      elseif ( $class === 'sock' ){
      // slp can contain "hostname:port" or ":full_uri" like "http://foo.tld/spam"
        if ( substr($slp,0,1) === ':' ){
        $tmp = substr($slp,1);
          if ( XF::sanitize_var($tmp,'uri') ){
          $slp = array();
          $tmp = parse_url($tmp);
          $curi = $tmp['path'];
          $slp[0] = $tmp['host'];
            if ( isset($tmp['port']) )
            $slp[1] = intval($tmp['port']);
          }
        unset($tmp);
        }
        else
        $slp = explode(':',$slp);
        if ( !is_array($slp) || !XF::sanitize_var($slp[0],'hostname') )
        return null;
      parse_str(str_replace(',','&',XF::get_cfg('filter_sink_local_param')),$p);
      $sock = new XFFilter_External();
      $sock->set('host',$slp[0]);
      $sock->set('port',(isset($slp[1])&&is_integer($slp[1]))?$slp[1]:80);
      $sock->query(array_merge(array('command'=>'check','message'=>$id,'custom_uri'=>$curi),$p));
      $r = $sock->result();
      //D($r);
        if ( is_array($r) && sizeof($r) === 2 )
        $o = ( in_array(strval(trim($r[1])),array('valid','true','1','spam'),true) ) ? true : false;
      $c = XF::bool2yn($o);
      }
    break;
    }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str(array('module'=>$type,'class'=>$class,'is_spam'=>$c)));
  return $o;
  }

  /**
  * really add an entry in our round-robin database
  * @param integer $id the sha1-hash as entry id
  * @param integer $type select the type (uid,ipa,msg)
  * @param boolean $value if 'true' this entry will be marked as spam
  * @return integer
  * @since 1.1.0
  */
  protected function prepend($id,$type,$value){
    if ( sizeof(self::$data) >= XF::get_cfg('filter_size') )
    array_pop(self::$data);
  $a = 'filter_max_age_';
    switch ( $type ){
    case self::TYPE_UID:
    $a .= 'uid';
    $e = $id;
    break;
    case self::TYPE_IPA:
    $a .= 'ipa';
    $e = $id;
    break;
    case self::TYPE_MSG:
    $a .= 'msg';
    $e = strlen($id);
    break;
    }
  $rid = $this->restrict_id($id,$type);
    if ( self::$data['_'] === 1 ){
    $bm = 0; // prepare bitmask
    $bm += (int)$type; // add type
      if ( is_bool($value) && $value ) // if true, set the highest bit (at least on LE)
      $bm += 0x80;
    return array_unshift(self::$data['rrd'],array(hash('sha1',$rid),XF::vault_query('uts')+XF::get_cfg($a),$bm,$e));
    }
  return 0;
  }

  /**
  * remove an entry from database
  * @param integer $key the key of the array entry
  * @return boolean
  * @since 1.1.0
  */
  protected function remove($key){
    if ( self::$data['_'] === 1 )
    unset(self::$data['rrd'][$key]);
  return true;
  }

  /**
  * extract the spam marker from database entry
  * @param integer $bm the bitmap value from db
  * @return boolean
  * @since 1.1.0
  */
  protected function bitmap_to_value($bm){
  return ( $bm&0x80 ) ? true : false;
  }

  /**
  * restrict input id to an hash (sha1) for identifying entries
  * @param string $id this input will be converted to a sha1-hash as id
  * @param integer $type select the type (uid,ipa,msg)
  * @return integer
  * @since 1.1.0
  */
  protected function restrict_id($id,$type){
  return hash('sha1',$id);
  }

}

/**
* XFFilter_External helps the main filter by querying external sources
* @package lbbackend
*/
class XFFilter_External {
/**
* @var array keys of "safe" values from $_SERVER
*/
protected static $safe_http_header = array('http_host','http_user_agent','http_accept','http_accept_language',
'http_accept_encoding','http_accept_charset','http_keep_alive','http_connection','http_cache_control','http_pragma',
'server_name','server_addr','server_port','remote_addr','remote_port','request_method','request_time'
);
/**
* @var array the results of a query
*/
protected $result = array();
/**
* @var string what scheme to use (currently 'tcp' only)
*/
protected $scheme = 'tcp';
/**
* @var string the hostname
*/
protected $host = '';
/**
* @var integer the port
*/
protected $port = 0;

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * set different parameters
  * @param string $a the key, allowed are: host, port and scheme
  * @param mixed $b the value
  * @return boolean
  * @since 1.1.0
  */
  public function set($a,$b){
    if ( in_array($a,array('host','port','scheme'),true) ){
    $this->$a = ( $a === 'port' ) ? intval($b) : $b;
    return true;
    }
    else
    return false;
  }

  /**
  * do the query (at the moment we support "akismet" for MSG only)
  * mandatory keys: class,command,message
  * optional  keys: key,verbose,custom_uri,msgvarid
  * @param array $a input data
  * @return boolean
  * @since 1.1.0
  */
  public function query($a){
    if ( is_array($a) && isset($a['class']) ){
      if ( !isset($a['message']) )
      return false;
    $var = array();
    $rq = array();
    $rq[] = 'POST {$URL} HTTP/1.0';
    $rq[] = 'Host: {$HOST}';
    $rq[] = 'User-Agent: Larus Board/'.substr(XF::VERSION,0,strrpos(XF::VERSION,'.'));
    $rq[] = 'Content-Type: application/x-www-form-urlencoded; charset=utf-8';
    $rq[] = 'Content-Length: {$LENGTH}';
    $rq[] = 'Date: '.gmdate(XF::DATE_RFC822);
    $rq[] = 'Proxy-Connection: close';
    $rq[] = 'Connection: close';
      switch ( $a['class'] ){
      case 'generic': // ask user-defined host by tcp.http
      $key = ( isset($a['msgvarid']) ) ? $a['msgvarid'] : 'message';
      $var[$key] = $a['message'];
      $uri = $a['custom_uri'];
      break;
      case 'akismet': // ask "www.akismet.com" by tcp.http
        if ( !isset($a['key']) )
        return false;
      $rq[2] .= ' | Akismet/1.11';
        if ( $a['command'] === 'verify' ){
        $var['key'] = $a['key'];
        $var['blog'] = XF::get_cfg('root_uri');
        $uri = '/1.1/verify-key';
        }
        elseif ( $a['command'] === 'check' ){
        $var['blog'] = XF::get_cfg('root_uri');
        $var['user_ip'] = XF::vault_query('client_ip');
        $var['user_agent'] = XF::ifset('server','HTTP_USER_AGENT','unknown');
        $var['comment_type'] = 'comment';
        $var['comment_content'] = $a['message'];
          // akismet would like to have $_SERVER be transmitted, too.
          // well, we filter it before by whitelisting "safe" header data :)
          if ( isset($a['verbose']) && (bool)$a['verbose'] ){
            foreach ( $_SERVER as $k=>$v ){
            $k = strtolower($k);
              if ( in_array($k,self::$safe_http_header,true) )
              $var[$k] = $v;
            }
          }
        $uri = '/1.1/comment-check';
        $this->host = $a['key'].'.'.$this->host;
        }
      break;
      }

    $var = http_build_query($var);
    $rq[0] = str_replace('{$URL}',$uri,$rq[0]);
    $rq[1] = str_replace('{$HOST}',$this->host,$rq[1]);
    $rq[4] = str_replace('{$LENGTH}',strlen($var),$rq[4]);
    $rq[] = '';
    $rq[] = $var;
    return $this->get($rq);
    }
  return false;
  }

  /**
  * return the results. usually a http response with [0]=headers and [1]=body
  * @param none
  * @return array
  * @since 1.1.0
  */
  public function result(){
  return $this->result;
  }

  /**
  * finally fetch data from source ("sink")
  * @param array $req the request data, usually http stream
  * @return boolean
  * @since 1.1.0
  */
  protected function get($rq){
    if ( !is_array($rq) )
    return false;
  $h = $this->host;
  $p = $this->port;
  $proxy = parse_url(XF::get_cfg('filter_remote_proxy'));
    // we can use a http proxy, if provided.
    if ( isset($proxy['host']) && isset($proxy['path']) && $proxy['path'] === '/' ){
      if ( !isset($proxy['port']) )
      $proxy['port'] = 80;
    $rq[0] = preg_replace('/^(GET|POST) (.*) (HTTP\/[0-9\.]+)$/ium','$1 http://'.$h.':'.$p.'$2 $3',$rq[0]);
    $rq[1] = 'Host: '.$proxy['host'];
    $h = $proxy['host'];
    $p = $proxy['port'];
    }
  //D($rq,$h.':'.$p);
  $s = fsockopen($this->scheme.'://'.$h,$p,$e1,$e2,3);
  $r = '';
    if ( $s ){ // well, response parsing assumes http for now...
    fputs($s,implode("\r\n",$rq));
      while ( !feof($s) )
      $r .= fread($s,2048);
    fclose($s);
    $this->result = explode("\r\n\r\n",$r);
    $first_line = substr($this->result[0],0,strpos($this->result[0],chr(10)));
    }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str(array('host'=>$this->scheme.'://'.$h.':'.$p,'error'=>$e2,'request_head'=>$rq[0],'reply_head'=>$first_line)));
  return true;
  }

}
?>