<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFMail is currently a simple abstraction for mail()
* @package lbbackend
*/
class XFMail {

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * send an e-mail
  * @param array $args input data for mail: 'to', 'subject', 'message', 'simulate' and 'nolog'
  * @return mixed
  * @since 1.0.0
  */
  public static function send($args){
    if ( !isset($args['to']) || strlen($args['to']) < 6 )
    return 'NO_RECIPIENT';
    if ( !isset($args['message']) || strlen($args['message']) < 8 )
    return 'NO_MESSAGE';
    if ( !isset($args['subject']) || strlen($args['subject']) < 8 )
    $args['subject'] = XF::get_cfg('main_title');
    if ( isset($args['checkmx']) ){
    $dd = substr($args['to'],strpos($args['to'],'@')+1);
      if ( !checkdnsrr($dd,'MX') )
      return 'NO_MX_RECORD_IN_DNS';
    }
    if ( XF::get_cfg('mail_signing_enable') ){
      if ( !self::crypto_sign($args['message']) )
      return 'ERROR_ON_SIGNING';
    }
  $eol = chr(13).chr(10);
  $args['subject'] = XF::sanitize_var($args['subject'],'str','stripspaces');
  $header  = 'From: "'.XF::get_cfg('mail_from_name').'" <'.XF::get_cfg('mail_from_mail').'>'.$eol;
  $header .= 'Content-Type: text/plain; charset=utf-8'.$eol;
  $header .= 'Content-Length: '.strlen($args['message']).$eol;
  $header .= 'MIME-Version: 1.0';
  $m = ( isset($args['simulate']) )
  ? true
  : mail($args['to'],$args['subject'],$args['message'],$header);
  $args['success'] = $m;
    if ( !isset($args['nolog']) ){
    $l = ( $m ) ? 'info' : 'error';
    XF::logger($l,'sub','mail','to',$args['to'],'subject',$args['subject'],'msghash',hash('sha1',$args['message']),'success',XF::bool2yn($m));
    }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str($args));
  return $m;
  }

  /**
  * sign a message by gnupg
  * @param string $msg the message text to be signed
  * @return boolean
  * @since 1.1.0
  */
  protected static function crypto_sign(&$msg){
  $a = XF::get_cfg('mail_signing_class');
  $class = substr($a,0,strpos($a,':'));
  $slp = substr($a,strpos($a,':')+1);
  parse_str(str_replace(',','&',XF::get_cfg('mail_signing_param')),$p);
  unset($a);
    if ( $class === 'exec' ){
    $pwd = ( isset($p['password']) && !empty($p['password']) ) ? $p['password'].chr(10) : '';
    $pch = ( empty($pwd) ) ? '' : '--passphrase-fd 0';
    $c = 'echo '.escapeshellarg($pwd.$msg).' | '.escapeshellcmd($slp).
    ' --batch --no-tty --homedir='.escapeshellarg($p['keyring']).
    ' --default-key '.escapeshellarg($p['keyid']).' '.$pch.' --clearsign --sign 2>&1';
    $r = array();
    exec($c,$r,$ec);
    $msg = implode(chr(10),$r);
    }
    elseif ( $class === 'php_ext' ){
      if ( extension_loaded('gnupg') ){
        if ( is_dir($p['keyring']) )
        @putenv('GNUPGHOME='.$p['keyring']);
      $GPG = new gnupg();
      $GPG->seterrormode(gnupg::ERROR_WARNING);
      $GPG->setarmor(1);
      $GPG->setsignmode(gnupg::SIG_MODE_CLEAR);
      $GPG->addsignkey($p['keyid'],$p['password']);
      $msg = $GPG->sign($msg);
      $GPG->clearsignkeys();
      $ec = 0;
      }
      else
      $ec = 1;
    }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,$c);
  return ( (int)$ec === 0 ) ? true : false;
  }

}
?>