<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
define('__XF_INCLUDE',1);
require_once('../lb_private/class.root.php');
new XF('ajax');
  if ( XF::vault_query('request_method') !== 'POST' ){
  @ob_end_clean();
  @header('HTTP/1.x 405 Method not Allowed',true,405);
  @header('Allow: POST');
  die('only POST is allowed as "ajax" request!');
  }
  if ( !headers_sent() ){ // never cache ajax requests in browsers or proxies...
  header('Cache-Control: no-cache, no-store, must-revalidate, proxy-revalidate');
  header('Pragma: no-cache');
  header('Expires: '.gmdate(XF::DATE_RFC822,1234567890));
  }
XFUI::ajax_init();

function xf__handler($ac,$args){
set_error_handler('xf__error');
$user = XF::get_user();
$ac = XF::sanitize_var($ac,'action');
$r = null;
XFUI::$ajax_response = new xajaxResponse();
  if ( XF::DEBUG ){
  XFUI::$ajax_response->alert($ac);
  XFUI::$ajax_response->alert(XF::arr2str($args));
  XFDebug::settracecolor('fff');
  XFDebug::trace(__METHOD__.' {'.$ac.'}',XF::arr2str($args));
  }
  if ( (bool)$user['u_login_annoy'] && mt_rand(1,100) < XF::ANNOY_PROBABILITY_ON_AJAX )
  xfaf_failure('{:fun_message_'.mt_rand(1,8).'}');
  elseif ( !$ac || !XF::access_control($ac) )
  xfaf_failure('{:access_denied}');
  else{
    if ( defined('__XF_AUTH_IS_TAINTED') && $ac !== 'reauth' )
    xfaf_failure('{:access_denied}');
    else{
      if ( !file_exists(XF::vault_query('root_path').'/action.'.$ac.'.php') )
      xfaf_failure('{:file_not_found}');
      else{
      XF::vault_query('request_action',$ac,'required');
        if ( XF::sql_transaction('is_running:ajax_core') )
        XF::sql_transaction('commit:ajax_core');
      $cn = 'XFAction_'.$ac;
      require_once(XF::vault_query('root_path').'/action.'.$ac.'.php');
        if ( is_subclass_of($cn,'XFAction') ){
        $ao = new $cn();
          if ( !xf__compare_tan($ac,$args,constant($cn.'::USE_TAN')) )
          xfaf_failure('{:transaction_number_invalid}');
          else{
            if ( isset($ao->version) && (int)$ao->version === XFAction::API_VERSION )
            $r = call_user_func('xfaf_'.$ac,$args);
          }
        unset($ao);
        }
        // NOTE: okay, use a hack to keep TANs. we get fresh ones, if page is reloaded...
        //if ( constant($cn.'::USE_TAN') === true && $r )
        //XF::tan($ac,'-');
        if ( XF::sql_transaction('is_running:cleanup') )
        xfaf_failure('{:action_has_not_committed_transaction}');
      }
    }
  }
  if ( !$r )
  XFUI::$ajax_response->call('xf_dosubmit',-1);
  if ( XF::DEBUG ){
  XFDebug::trace(__METHOD__.' {'.$ac.'}',XF::arr2str(array('return'=>$r)));
  XFUI::$ajax_response->assign('xf__ajax_debug','innerHTML',XFDebug::trace(null,'return'));
  }
return XFUI::$ajax_response;
}

function xf__compare_tan($a,&$args,$action_require_tan){
$tan = XF::sanitize_var(XF::ifset($args,'tan',0),'int');
unset($args['tan']);
  if ( XF::DEBUG )
  return true;
  if ( $action_require_tan && XF::get_cfg('auth_use_tan') ){
    if ( !isset($_SESSION['xf_tan'][$a]) )
    return false;
  return ( $tan === (int)$_SESSION['xf_tan'][$a] ) ? true : false;
  }
return true;
}

function xfaf_process_data($input,$mark){
$rej = array();
  foreach ( $input as $k=>$v ){
    if ( $v === false ){
    $rej[] = $k;
      if ( in_array($k,$mark,true) )
      XFUI::$ajax_response->assign($k,'className','xf_input_invalid');
    }
    else{
      if ( in_array($k,$mark,true) )
      XFUI::$ajax_response->assign($k,'className','xf_input_field');
    }
  }
  if ( sizeof($rej) > 0 )
  xfaf_failure(XFUI::i18n('invalid_form_input'));
return ( sizeof($rej) == 0 ) ? true : false;
}

function xfaf_process_input($input,$mark){
$data = XF::validate_gpc_data($input);
xfaf_process_data($data,$mark);
return true;
}

function xfaf_success($uri,$msg){
  if ( substr($msg,0,2) === '{:' )
  $msg = XFUI::lang_str($msg);
  if ( !empty($msg) )
  XFUI::$ajax_response->script("overlib('".str_replace("'",'&#x22;',$msg)."',TIMEOUT,5000,STICKY,CLOSETEXT,'',CAPTION,'".XFUI::i18n('success')."',CSSCLASS,BGCLASS,'xf_box_message xf_bm_popup xf_bm_notice',FGCLASS,'xf_transparent',CAPTIONFONTCLASS,'xf_bm_popup_caption',TEXTFONTCLASS,'xf_bm_popup_message');");
  if ( !empty($uri) && !XF::DEBUG )
  XFUI::$ajax_response->redirect($uri,2);
  if ( XF::DEBUG ){
  XFUI::$ajax_response->alert(XFUI::i18n('success').' -- '.$msg);
  XFUI::$ajax_response->alert('redirect -- '.$uri);
  XFDebug::trace(__METHOD__,$msg);
  }
return true;
}

function xfaf_failure($msg){
  if ( substr($msg,0,2) === '{:' )
  $msg = XFUI::lang_str($msg);
XFUI::$ajax_response->script("overlib('".str_replace("'",'&#x22;',$msg)."',TIMEOUT,5000,STICKY,CLOSETEXT,'',CAPTION,'".XFUI::i18n('fail')."',CSSCLASS,BGCLASS,'xf_box_message xf_bm_popup xf_bm_error',FGCLASS,'xf_transparent',CAPTIONFONTCLASS,'xf_bm_popup_caption',TEXTFONTCLASS,'xf_bm_popup_message');");
  if ( XF::DEBUG ){
  XFUI::$ajax_response->alert(XFUI::i18n('fail').' -- '.$msg);
  XFDebug::trace(__METHOD__,$msg);
  }
return false;
}

function xf__error($no,$str,$file,$line){
static $et = array(
1=>'E_ERROR',2=>'E_WARNING',4=>'E_PARSE',8=>'E_NOTICE',16=>'E_CORE_ERROR',32=>'E_CORE_WARNING',64=>'E_COMPILE_ERROR',
128=>'E_COMPILE_WARNING',256=>'E_USER_ERROR',512=>'E_USER_WARNING',1024=>'E_USER_NOTICE',2048=>'E_STRICT',
4096=>'E_RECOVERABLE_ERROR',8192=>'E_DEPRECATED',16384=>'E_USER_DEPRECATED');
  if ( preg_match('/(\/ext\/|PEAR\.php)/',$file) ) // do not show errors/notices from extensions as there are plenty :)
  return;
$no = ( isset($et[(int)$no]) ) ? $et[(int)$no] : 'E_UNKNOWN';
$msg = 'ERROR HANDLER {'.$no.'}'.chr(10).htmlspecialchars(basename($file)).':'.(int)$line.chr(10).htmlspecialchars($str);
$r = new xajaxResponse();
$r->alert($msg);
$r->prepend('xf__content','innerHTML','<div class="xf_box_message xf_bm_message xf_bm_warning">'.nl2br($msg).'</div>');
$r->call('xf_dosubmit',-1);
$r->printOutput();
die();
}
?>