/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.core;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import net.rim.blackberry.api.phone.Phone;
import net.rim.device.api.media.control.AudioPathControl;
import net.rim.device.api.system.ControlledAccessException;
import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
import net.rim.device.api.system.WLANInfo;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneAuthInfo;
import org.linphone.core.LinphoneCall;
import org.linphone.core.LinphoneCallParams;
import org.linphone.core.LinphoneChatRoom;
import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.core.LinphoneCoreFactory;
import org.linphone.core.LinphoneCoreListener;
import org.linphone.core.LinphoneFriend;
import org.linphone.core.LinphoneProxyConfig;
import org.linphone.core.OnlineStatus;
import org.linphone.core.PayloadType;
import org.linphone.core.VideoSize;
import org.linphone.jlinphone.core.LinphoneCallImpl;
import org.linphone.jlinphone.core.LinphoneProxyConfigImpl;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.SocketAddress;
import org.linphone.sal.Sal;
import org.linphone.sal.SalAuthInfo;
import org.linphone.sal.SalError;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalListener;
import org.linphone.sal.SalMediaDescription;
import org.linphone.sal.SalOp;
import org.linphone.sal.SalReason;

public class LinphoneCoreImpl
implements LinphoneCore {
    Sal mSal;
    LinphoneAuthInfo mAuthInfo;
    LinphoneProxyConfigImpl mProxyCfg;
    LinphoneCallImpl mCall;
    LinphoneCoreListener mListener;
    Logger mLog = JOrtpFactory.instance().createLogger("LinphoneCore");
    Player mRingPlayer;
    Player mRingBackPlayer;
    Vector mCallLogs;
    private PersistentObject mPersistentObject;
    boolean mNetworkIsUp = false;
    Sal.Transport mTransport = Sal.Transport.Datagram;
    int mSipPort = 5060;
    SalListener mSalListener = new SalListener(){

        public void onCallAccepted(SalOp op) {
            LinphoneCallImpl c = (LinphoneCallImpl)op.getUserContext();
            SalMediaDescription oldmd = null;
            boolean keepStreams = false;
            if (LinphoneCoreImpl.this.mCall == null || LinphoneCoreImpl.this.mCall != c) {
                op.callTerminate();
            }
            oldmd = c.getFinalMediaDescription();
            c.setFinalMediaDescription(op.getFinalMediaDescription());
            LinphoneCoreImpl.this.deallocateRingBackPlayerIfNeeded();
            if (oldmd != null) {
                if (oldmd.equals(op.getFinalMediaDescription())) {
                    LinphoneCoreImpl.this.mLog.info("Early media and 200 Ok media descriptions are equal, keeping same streams");
                    keepStreams = true;
                } else {
                    LinphoneCoreImpl.this.mLog.info("Early media and 200 Ok media descriptions are different, need to restart streams");
                }
            }
            if (c.getAudioStream().isStarted() && !keepStreams) {
                c.terminateMediaStreams();
                try {
                    LinphoneCoreImpl.this.mCall.initMediaStreams();
                }
                catch (SalException e) {
                    LinphoneCoreImpl.this.mLog.error("Cannot create media stream", e);
                    op.callTerminate();
                    return;
                }
            }
            c.setState(LinphoneCall.State.Connected);
            if (!keepStreams) {
                c.startMediaStreams();
            }
        }

        public void onCallReceived(SalOp op) {
            try {
                if (LinphoneCoreImpl.this.mCall != null || Phone.getActiveCall() != null) {
                    op.callDecline(Sal.Reason.Busy, null);
                } else {
                    LinphoneCoreImpl.this.mCall = LinphoneCoreImpl.this.createIncomingCall(op);
                    LinphoneCoreImpl.this.mCall.setState(LinphoneCall.State.IncomingReceived);
                    LinphoneCoreImpl.this.mCallLogs.addElement(LinphoneCoreImpl.this.mCall.getCallLog());
                    op.callRinging();
                    LinphoneCoreImpl.this.mRingPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/oldphone.wav"), (String)"audio/wav");
                    LinphoneCoreImpl.this.mRingPlayer.realize();
                    LinphoneCoreImpl.this.mRingPlayer.prefetch();
                    LinphoneCoreImpl.this.mRingPlayer.setLoopCount(Integer.MAX_VALUE);
                    AudioPathControl lPathCtr = (AudioPathControl)LinphoneCoreImpl.this.mRingPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
                    lPathCtr.setAudioPath(1);
                    LinphoneCoreImpl.this.mRingPlayer.start();
                }
            }
            catch (Throwable e) {
                LinphoneCoreImpl.this.mLog.error("Cannot create incoming call", e);
                LinphoneCoreImpl.this.mCall.terminateMediaStreams();
                op.callDecline(Sal.Reason.Unknown, null);
                return;
            }
        }

        public void onCallRinging(SalOp op) {
            LinphoneCallImpl c = (LinphoneCallImpl)op.getUserContext();
            if (LinphoneCoreImpl.this.mCall == null || LinphoneCoreImpl.this.mCall != c) {
                op.callTerminate();
            }
            if (LinphoneCoreImpl.this.mCall != null && op.getFinalMediaDescription() == null) {
                LinphoneCoreImpl.this.mCall.setState(LinphoneCall.State.OutgoingRinging);
                try {
                    LinphoneCoreImpl.this.mRingBackPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/ringback.wav"), (String)"audio/wav");
                    LinphoneCoreImpl.this.mRingBackPlayer.realize();
                    LinphoneCoreImpl.this.mRingBackPlayer.prefetch();
                    AudioPathControl lPathCtr = (AudioPathControl)LinphoneCoreImpl.this.mRingBackPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
                    lPathCtr.setAudioPath(0);
                    LinphoneCoreImpl.this.mRingBackPlayer.setLoopCount(-1);
                    LinphoneCoreImpl.this.mRingBackPlayer.start();
                }
                catch (Throwable e) {
                    LinphoneCoreImpl.this.mLog.error("cannot play ringback tone", e);
                    LinphoneCoreImpl.this.deallocateRingBackPlayerIfNeeded();
                    return;
                }
            }
            if (op.getFinalMediaDescription() != null && c.getFinalMediaDescription() == null) {
                LinphoneCoreImpl.this.mCall.setState(LinphoneCall.State.OutgoingEarlyMedia);
                LinphoneCoreImpl.this.deallocateRingBackPlayerIfNeeded();
                c.setFinalMediaDescription(op.getFinalMediaDescription());
                c.startMediaStreams();
            }
        }

        public void onCallTerminated(SalOp op) {
            if (LinphoneCoreImpl.this.mCall != null) {
                LinphoneCoreImpl.this.deallocateRingBackPlayerIfNeeded();
                LinphoneCoreImpl.this.deallocateRingPlayerIfNeeded();
                LinphoneCoreImpl.this.mCall.terminateMediaStreams();
                LinphoneCoreImpl.this.mCall.setState(LinphoneCall.State.CallEnd);
                LinphoneCoreImpl.this.mCall = null;
            }
        }

        public void onAuthRequested(SalOp op, String realm, String userName) {
            try {
                if (LinphoneCoreImpl.this.mAuthInfo != null && userName.equalsIgnoreCase(LinphoneCoreImpl.this.mAuthInfo.getUsername())) {
                    op.authenticate(new SalAuthInfo(realm, userName, LinphoneCoreImpl.this.mAuthInfo.getPassword()));
                } else {
                    LinphoneCoreImpl.this.mListener.authInfoRequested(LinphoneCoreImpl.this, realm, userName);
                }
            }
            catch (Exception e) {
                LinphoneCoreImpl.this.mLog.error("Cannot provide auth info", e);
            }
        }

        public void onAuthSuccess(SalOp lSalOp, String realm, String username) {
            LinphoneCoreImpl.this.mProxyCfg.setRegistered(true);
            LinphoneAddress lTo = LinphoneCoreFactory.instance().createLinphoneAddress(lSalOp.getTo());
            LinphoneCoreImpl.this.mListener.displayStatus(LinphoneCoreImpl.this, "Registered to " + lTo.getDomain());
        }

        public void onCallFailure(SalOp op, String reasonPhrase) {
            LinphoneCoreImpl.this.deallocateRingBackPlayerIfNeeded();
            LinphoneCoreImpl.this.mCall.terminateMediaStreams();
            LinphoneCoreImpl.this.mCall.setState(LinphoneCall.State.Error, reasonPhrase);
            LinphoneCoreImpl.this.mCall = null;
        }

        public void OnRegisterFailure(SalOp op, SalError error, SalReason reason, String details) {
            LinphoneCoreImpl.this.mListener.displayStatus(LinphoneCoreImpl.this, "Registration failure [" + details + "]");
            LinphoneCoreImpl.this.mListener.registrationState(LinphoneCoreImpl.this, LinphoneCoreImpl.this.getDefaultProxyConfig(), LinphoneCore.RegistrationState.RegistrationFailed, details);
        }

        public void OnRegisterSuccess(SalOp op, boolean registered) {
            LinphoneCoreImpl.this.mListener.registrationState(LinphoneCoreImpl.this, LinphoneCoreImpl.this.getDefaultProxyConfig(), registered ? LinphoneCore.RegistrationState.RegistrationOk : LinphoneCore.RegistrationState.RegistrationCleared, null);
        }
    };

    private LinphoneCallImpl createIncomingCall(SalOp op) throws SalException {
        return new LinphoneCallImpl(this, op, CallDirection.Incoming);
    }

    private LinphoneCallImpl createOutgoingCall(LinphoneAddress addr) throws SalException {
        SalOp op = this.mSal.createSalOp();
        if (this.getDefaultProxyConfig() != null && this.getDefaultProxyConfig().getDomain().equalsIgnoreCase(addr.getDomain())) {
            op.setRoute(this.getDefaultProxyConfig().getProxy());
        }
        op.setFrom(this.getIdentity());
        op.setTo(addr.asString());
        LinphoneCallImpl c = new LinphoneCallImpl(this, op, CallDirection.Outgoing);
        return c;
    }

    private String getIdentity() throws SalException {
        if (this.mProxyCfg != null) {
            return this.mProxyCfg.getIdentity();
        }
        return "sip:anonymous@" + this.mSal.getLocalAddr() + ":" + Integer.toString(this.mSipPort);
    }

    public LinphoneCoreImpl(LinphoneCoreListener listener, String userConfig, String factoryConfig, Object userdata) throws LinphoneCoreException {
        try {
            this.mPersistentObject = PersistentStore.getPersistentObject((long)"org.jlinphone.logs".hashCode());
            if (this.mPersistentObject.getContents() != null) {
                this.mCallLogs = (Vector)this.mPersistentObject.getContents();
                while (this.mCallLogs.size() > 30) {
                    this.mCallLogs.removeElementAt(0);
                }
            } else {
                this.mCallLogs = new Vector();
            }
            this.mListener = listener;
            this.mListener.globalState(this, LinphoneCore.GlobalState.GlobalOn, null);
            this.createSal();
        }
        catch (ControlledAccessException e1) {
            throw new LinphoneCoreException("Persistent store permission denied");
        }
        catch (Throwable e) {
            this.destroy();
            this.mLog.error("Cannot create Linphone core for user conf [" + userConfig + "] factory conf [" + factoryConfig + "]", e);
            throw new LinphoneCoreException("Initialization failure caused by: " + e.getMessage());
        }
    }

    public void acceptCall(LinphoneCall aCall) throws LinphoneCoreException {
        if (this.mCall != null) {
            try {
                this.mCall.getOp().callAccept();
                this.mCall.setFinalMediaDescription(this.mCall.getOp().getFinalMediaDescription());
                this.mCall.setState(LinphoneCall.State.Connected, null);
                this.deallocateRingPlayerIfNeeded();
                this.mCall.startMediaStreams();
            }
            catch (Throwable e) {
                throw new LinphoneCoreException("cannot accept call from [" + this.getRemoteAddress() + "]");
            }
        }
    }

    public void addAuthInfo(LinphoneAuthInfo info) {
        this.mAuthInfo = info;
    }

    public void addProxyConfig(LinphoneProxyConfig proxyCfg) throws LinphoneCoreException {
        this.mProxyCfg = (LinphoneProxyConfigImpl)proxyCfg;
        proxyCfg.done();
    }

    public void clearAuthInfos() {
        this.mAuthInfo = null;
    }

    public void clearCallLogs() {
        this.mCallLogs.removeAllElements();
    }

    public void clearProxyConfigs() {
        this.mProxyCfg = null;
    }

    public void destroy() {
        if (this.isIncall()) {
            this.terminateCall(this.mCall);
        }
        if (this.mSal != null) {
            this.mSal.close();
            this.mSal = null;
        }
        if (this.mPersistentObject != null) {
            this.mPersistentObject.setContents((Object)this.mCallLogs);
            this.mPersistentObject.commit();
        }
        if (this.mListener != null) {
            this.mListener.globalState(this, LinphoneCore.GlobalState.GlobalOff, null);
        }
    }

    public Vector getCallLogs() {
        return this.mCallLogs;
    }

    public LinphoneProxyConfig getDefaultProxyConfig() {
        return this.mProxyCfg;
    }

    public LinphoneAddress getRemoteAddress() {
        if (this.mCall != null) {
            return this.mCall.getRemoteAddress();
        }
        return null;
    }

    public float getSoftPlayLevel() {
        return 0.0f;
    }

    public LinphoneAddress interpretUrl(String rawDestination) throws LinphoneCoreException {
        String lDest = rawDestination.trim();
        StringBuffer lFilteredDestination = new StringBuffer();
        int i = 0;
        while (i < lDest.length()) {
            char lCurrentChar = lDest.charAt(i);
            if (lCurrentChar != ' ' && lCurrentChar != '-') {
                lFilteredDestination.append(lCurrentChar);
            }
            ++i;
        }
        lDest = lFilteredDestination.toString();
        LinphoneAddress addr = LinphoneCoreFactory.instance().createLinphoneAddress(lDest);
        if (addr == null) {
            if (lDest.indexOf("@") == -1) {
                LinphoneProxyConfigImpl cfg = (LinphoneProxyConfigImpl)this.getDefaultProxyConfig();
                if (cfg != null) {
                    LinphoneAddress tmp = LinphoneCoreFactory.instance().createLinphoneAddress(cfg.getIdentity());
                    tmp.setDisplayName(null);
                    if (lDest.startsWith("+") && cfg.isDialPlusEscaped()) {
                        tmp.setUserName("00" + lDest.substring(1));
                    } else {
                        tmp.setUserName(lDest);
                    }
                    return tmp;
                }
                throw new LinphoneCoreException("Bad destination [" + lDest + "]");
            }
            addr = LinphoneCoreFactory.instance().createLinphoneAddress("sip:" + lDest);
            if (addr == null) {
                throw new LinphoneCoreException("Bad destination [" + lDest + "]");
            }
        }
        return addr;
    }

    public LinphoneCall invite(String address) throws LinphoneCoreException {
        LinphoneAddress addr = this.interpretUrl(address);
        return this.invite(addr);
    }

    public LinphoneCall invite(LinphoneAddress to) throws LinphoneCoreException {
        if (this.mCall != null) {
            return null;
        }
        try {
            LinphoneCallImpl c = this.createOutgoingCall(to);
            c.getOp().call();
            this.mCall = c;
            c.setState(LinphoneCall.State.OutgoingInit, null);
            this.mCallLogs.addElement(c.getCallLog());
            return c;
        }
        catch (Exception e) {
            this.terminateCall(this.mCall);
            throw new LinphoneCoreException("Cannot place call to [" + to + "]", e);
        }
    }

    public boolean isInComingInvitePending() {
        return this.mCall != null && this.mCall.getState() == LinphoneCall.State.IncomingReceived;
    }

    public boolean isIncall() {
        return this.mCall != null;
    }

    public boolean isMicMuted() {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            return this.mCall.getAudioStream().isMicMuted();
        }
        return false;
    }

    public synchronized void iterate() {
        if (this.mSal != null && this.mSal.getTransport() != this.mTransport) {
            this.closeSal();
        }
        if (this.mSal == null && this.mNetworkIsUp) {
            try {
                this.createSal();
                if (this.mProxyCfg != null && this.mProxyCfg.registerEnabled()) {
                    this.mProxyCfg.done();
                }
            }
            catch (Throwable e) {
                this.mLog.error("Cannot create listening point", e);
            }
        } else if (this.mSal != null && !this.mNetworkIsUp) {
            this.closeSal();
        }
        if (this.mSal != null && this.mProxyCfg != null) {
            this.mProxyCfg.check(this);
        }
    }

    public void muteMic(boolean isMuted) {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            this.mCall.getAudioStream().muteMic(isMuted);
        }
    }

    public void sendDtmf(char number) {
        if (this.mCall != null) {
            this.mCall.sendDtmf(number);
        }
    }

    public void setDefaultProxyConfig(LinphoneProxyConfig proxyCfg) {
        this.mProxyCfg = (LinphoneProxyConfigImpl)proxyCfg;
    }

    public void setNetworkStateReachable(boolean isReachable) {
        if (this.mNetworkIsUp != isReachable) {
            this.mLog.warn("New network state is [" + isReachable + "]");
        }
        this.mNetworkIsUp = isReachable;
    }

    public void setSoftPlayLevel(float gain) {
    }

    public void terminateCall(LinphoneCall aCall) {
        if (this.mCall != null) {
            if (this.isInComingInvitePending()) {
                try {
                    this.mRingPlayer.stop();
                    this.mRingPlayer.close();
                    this.mRingPlayer = null;
                }
                catch (MediaException e) {
                    this.mLog.error("cannot stop ringer", e);
                }
                this.mCall.getOp().callDecline(Sal.Reason.Declined, null);
            } else {
                this.deallocateRingBackPlayerIfNeeded();
                this.mCall.terminateMediaStreams();
                this.mCall.getOp().callTerminate();
            }
            if (this.mCall != null && this.mCall.getState() != LinphoneCall.State.CallEnd) {
                this.mCall.setState(LinphoneCall.State.CallEnd, null);
            }
            this.mCall = null;
        }
    }

    public Sal getSal() {
        return this.mSal;
    }

    public void setSignalingTransport(LinphoneCore.Transport aTransport) {
        if (aTransport == LinphoneCore.Transport.udp) {
            this.mTransport = Sal.Transport.Datagram;
        } else if (aTransport == LinphoneCore.Transport.tcp) {
            this.mTransport = Sal.Transport.Stream;
        } else {
            this.mLog.error("Unexpected transport [" + aTransport + "]");
        }
    }

    private void closeSal() {
        if (this.isIncall()) {
            this.terminateCall(this.mCall);
        }
        if (this.mProxyCfg != null && this.mProxyCfg.isRegistered()) {
            if (this.mNetworkIsUp) {
                this.mProxyCfg.edit();
                this.mProxyCfg.done();
            } else {
                this.mListener.displayStatus(this, "Registration to [" + this.mProxyCfg.getProxy() + "] lost");
                this.mListener.registrationState(this, this.getDefaultProxyConfig(), LinphoneCore.RegistrationState.RegistrationFailed, "connection lost");
            }
        }
        this.mSal.close();
        this.mSal = null;
    }

    public void enableEchoCancellation(boolean enable) {
        this.mLog.error("ec not implemenetd");
    }

    public void enablePayloadType(PayloadType pt, boolean enable) throws LinphoneCoreException {
        this.mLog.error("enablePayloadType not implemenetd");
    }

    public PayloadType findPayloadType(String mime, int clockRate) {
        this.mLog.error("findPayloadType not implemenetd");
        return null;
    }

    public boolean isEchoCancellationEnabled() {
        return false;
    }

    public int getPlayLevel() {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            return this.mCall.getAudioStream().getPlayLevel();
        }
        return -1;
    }

    public void setPlayLevel(int level) {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            this.mCall.getAudioStream().setPlayLevel(level);
        } else {
            this.mLog.error("Cannot ajust playback level to [" + level + "]");
        }
    }

    public float getPlaybackGain() {
        return 0.0f;
    }

    public void setPlaybackGain(float gain) {
    }

    private void createSal() throws SalException {
        String localAdd = null;
        String dummyConnString = "socket://www.linphone.org:80;deviceside=true";
        if (WLANInfo.getWLANState() == 4620) {
            dummyConnString = String.valueOf(dummyConnString) + ";interface=wifi";
        }
        try {
            this.mLog.info("Opening dummy socket connection to : " + dummyConnString);
            SocketConnection dummyCon = (SocketConnection)Connector.open((String)dummyConnString);
            localAdd = dummyCon.getLocalAddress();
            dummyCon.close();
        }
        catch (Throwable e) {
            String lErrorStatus = "Network unreachable, please enable wifi/or 3G";
            this.mLog.error(lErrorStatus, e);
            this.mListener.displayStatus(this, lErrorStatus);
            this.setNetworkStateReachable(false);
            return;
        }
        SocketAddress addr = JOrtpFactory.instance().createSocketAddress(localAdd, this.mSipPort);
        this.mSal = SalFactory.instance().createSal();
        this.mSal.setUserAgent("jLinphone/0.0.1");
        try {
            this.mSal.listenPort(addr, this.mTransport, false);
        }
        catch (SalException e) {
            this.mLog.error("Cannot listen of on [" + addr + "]", e);
            throw e;
        }
        this.mSal.setListener(this.mSalListener);
        this.mListener.displayStatus(this, "Ready");
    }

    public void enableSpeaker(boolean value) {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            this.mCall.getAudioStream().enableSpeaker(value);
        }
    }

    public boolean isSpeakerEnabled() {
        if (this.mCall != null && this.mCall.getAudioStream() != null) {
            return this.mCall.getAudioStream().isSpeakerEnabled();
        }
        return false;
    }

    public LinphoneCall getCurrentCall() {
        return this.mCall;
    }

    public void playDtmf(char number, int duration) {
    }

    public void stopDtmf() {
    }

    private void deallocateRingBackPlayerIfNeeded() {
        this.deallocatePlayerIfNeeded(this.mRingBackPlayer);
        this.mRingBackPlayer = null;
    }

    private void deallocateRingPlayerIfNeeded() {
        this.deallocatePlayerIfNeeded(this.mRingPlayer);
        this.mRingPlayer = null;
    }

    private void deallocatePlayerIfNeeded(Player aPlayer) {
        if (aPlayer != null) {
            try {
                aPlayer.stop();
                aPlayer.close();
            }
            catch (MediaException e) {
                this.mLog.error("Cannot stop  player", e);
            }
        }
    }

    protected LinphoneCoreListener getListener() {
        return this.mListener;
    }

    public void addFriend(LinphoneFriend lf) throws LinphoneCoreException {
        throw new RuntimeException("Not implemenetd yet");
    }

    public LinphoneChatRoom createChatRoom(String to) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void enableVideo(boolean vcapEnabled, boolean displayEnabled) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public LinphoneCore.FirewallPolicy getFirewallPolicy() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public String getStunServer() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public boolean isVideoEnabled() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setFirewallPolicy(LinphoneCore.FirewallPolicy pol) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setPresenceInfo(int minuteAway, String alternativeContact, OnlineStatus status) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setPreviewWindow(Object w) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setStunServer(String stunServer) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setVideoWindow(Object w) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public boolean getNetworkStateReachable() {
        return this.mNetworkIsUp;
    }

    public LinphoneCallParams createDefaultCallParameters() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public VideoSize getPreferredVideoSize() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public String getRing() {
        throw new RuntimeException("Not implemenetd yet");
    }

    public LinphoneCall inviteAddressWithParams(LinphoneAddress destination, LinphoneCallParams params) throws LinphoneCoreException {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setDownloadBandwidth(int bw) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setPreferredVideoSize(VideoSize vSize) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setRing(String path) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public void setUploadBandwidth(int bw) {
        throw new RuntimeException("Not implemenetd yet");
    }

    public int updateCall(LinphoneCall call, LinphoneCallParams params) {
        throw new RuntimeException("Not implemenetd yet");
    }
}

