/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.Node;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.SocketAddress;

class RtpPacketImpl
extends Node
implements RtpPacket {
    private byte[] mBuffer;
    private int mPhysSize;
    private int mRealLength;
    private int mTimestamp;
    private int mSeqNumber;
    private int mPayloadType;
    private int mSSRC;
    private boolean mMarker;
    private SocketAddress mSocketAddress;
    public static int sRtpHeaderSize = 12;

    public RtpPacketImpl(int dataSize) {
        this.mPhysSize = sRtpHeaderSize + dataSize;
        this.mBuffer = new byte[this.mPhysSize];
        this.mRealLength = this.mPhysSize;
        this.mTimestamp = 0;
        this.mSeqNumber = 0;
        this.mPayloadType = 0;
        this.mSSRC = 0;
    }

    public byte[] getBytes() {
        return this.mBuffer;
    }

    public int getDataOffset() {
        return sRtpHeaderSize;
    }

    public int getDataLength() {
        int len = this.mRealLength - sRtpHeaderSize;
        if (len > 0) {
            return len;
        }
        return 0;
    }

    public void setRealLength(int reallen) throws RtpException {
        if (reallen > this.mPhysSize) {
            throw new RtpException("new size exceeds physical storage of packet !");
        }
        this.mRealLength = reallen;
    }

    public int getPhysicalSize() {
        return this.mPhysSize;
    }

    public int getRealLength() {
        return this.mRealLength;
    }

    public void setTimestamp(int ts) {
        this.mTimestamp = ts;
    }

    public int getTimestamp() {
        return this.mTimestamp;
    }

    public void setSeqNumber(int seq) {
        this.mSeqNumber = seq;
    }

    public int getSeqNumber() {
        return this.mSeqNumber;
    }

    public void setPayloadType(int pt) {
        this.mPayloadType = pt;
    }

    public int getPayloadType() {
        return this.mPayloadType;
    }

    public void setSSRC(int ssrc) {
        this.mSSRC = ssrc;
    }

    public int getSSRC() {
        return this.mSSRC;
    }

    public void setMarkerBit(boolean bit) {
        this.mMarker = bit;
    }

    public boolean getMarkerBit() {
        return this.mMarker;
    }

    private void writeUint32(byte[] buf, int pos, int val) {
        buf[pos + 0] = (byte)(val >>> 24 & 0xFF);
        buf[pos + 1] = (byte)(val >>> 16 & 0xFF);
        buf[pos + 2] = (byte)(val >>> 8 & 0xFF);
        buf[pos + 3] = (byte)(val & 0xFF);
    }

    private int readUint32(byte[] buf, int pos) {
        int b0 = buf[pos] << 24;
        int b1 = buf[pos + 1] << 16 & 0xFFFFFF;
        int b2 = buf[pos + 2] << 8 & 0xFFFF;
        int b3 = buf[pos + 3] & 0xFF;
        long ret = b0 | b1 | b2 | b3;
        return (int)ret;
    }

    public void writeHeader() {
        this.mBuffer[0] = -128;
        this.mBuffer[1] = (byte)((this.mMarker ? 1 : 0) << 7 | this.mPayloadType);
        this.mBuffer[2] = (byte)(this.mSeqNumber >>> 8);
        this.mBuffer[3] = (byte)(this.mSeqNumber & 0xFF);
        this.writeUint32(this.mBuffer, 4, this.mTimestamp);
        this.writeUint32(this.mBuffer, 8, this.mSSRC);
    }

    public void readHeader() throws RtpException {
        if (this.mRealLength < 12) {
            throw new RtpException("Too short to be a RTP packet");
        }
        int ver = this.mBuffer[0] >>> 6 & 3;
        if (ver != 2) {
            throw new RtpException("Not a RTP packet, bad version number " + ver);
        }
        this.mMarker = (this.mBuffer[1] >>> 7 & 1) == 1;
        this.mPayloadType = this.mBuffer[1] & 0x7F;
        this.mSeqNumber = this.mBuffer[2] << 8 & 0xFFFF | this.mBuffer[3] & 0xFF;
        this.mTimestamp = this.readUint32(this.mBuffer, 4);
        this.mSSRC = this.readUint32(this.mBuffer, 8);
    }

    public void recycle() {
    }

    public SocketAddress getSocketAddress() {
        return this.mSocketAddress;
    }

    public void setSocketAddress(SocketAddress sockaddr) {
        this.mSocketAddress = sockaddr;
    }

    public String toString() {
        return "Seq=" + this.mSeqNumber + " Ts=" + this.mTimestamp;
    }
}

