/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.NistSipMessageHandlerImpl;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.SIPStackMessageFactory;
import sip4me.gov.nist.siplite.stack.SIPTransactionStack;
import sip4me.gov.nist.siplite.stack.Transaction;

public class NistSipMessageFactoryImpl
implements SIPStackMessageFactory {
    public SIPServerRequestInterface newSIPServerRequest(Request sipRequest, MessageChannel messageChannel) throws IllegalArgumentException {
        if (messageChannel == null || sipRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
        if (messageChannel instanceof Transaction) {
            retval.transactionChannel = (Transaction)messageChannel;
        }
        SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Returning request interface for " + sipRequest.getFirstLine() + " " + retval + " messageChannel = " + messageChannel);
        }
        return retval;
    }

    public SIPServerResponseInterface newSIPServerResponse(Response sipResponse, MessageChannel messageChannel) {
        try {
            ListeningPoint lp;
            Transaction tr;
            NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
            SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
            retval.transactionChannel = tr = theStack.findTransaction(sipResponse, false);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Found Transaction " + tr + " for " + sipResponse);
                LogWriter.logMessage("MessageProcessor = " + messageChannel.getMessageProcessor() + "/" + messageChannel.getMessageProcessor().getListeningPoint());
            }
            retval.listeningPoint = lp = messageChannel.getMessageProcessor().getListeningPoint();
            return retval;
        }
        catch (RuntimeException ex) {
            System.out.println("runtime exception caught!");
            ex.printStackTrace();
            return null;
        }
    }
}

