/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.siplite.stack.SIPStackTimerTask;

public class Pipeline
extends InputStream {
    private Vector buffList;
    private Buffer currentBuffer;
    private boolean isClosed;
    private Timer timer;
    private InputStream pipe;
    private int readTimeout;
    private TimerTask myTimerTask;
    private StringBuffer totalWriteBuffer;
    private StringBuffer totalReadBuffer;

    public void startTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        this.myTimerTask = new MyTimer(this);
        this.timer.schedule(this.myTimerTask, this.readTimeout);
    }

    public void stopTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
        }
    }

    public Pipeline(InputStream pipe, int readTimeout, Timer timer) {
        this.timer = timer;
        this.pipe = pipe;
        this.buffList = new Vector();
        this.readTimeout = readTimeout;
        this.totalWriteBuffer = new StringBuffer();
        this.totalReadBuffer = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] bytes, int start, int length) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buff = new Buffer(bytes, length);
        buff.ptr = start;
        Vector vector = this.buffList;
        synchronized (vector) {
            this.buffList.addElement(buff);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] bytes) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Vector vector = this.buffList;
        synchronized (vector) {
            Buffer buff = new Buffer(bytes, bytes.length);
            this.buffList.addElement(buff);
            this.totalWriteBuffer.append(new String(buff.bytes));
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        Vector vector = this.buffList;
        synchronized (vector) {
            this.buffList.notifyAll();
        }
        this.pipe.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        var1_1 = this.buffList;
        synchronized (var1_1) {
            if (this.currentBuffer != null && this.currentBuffer.ptr < this.currentBuffer.length) {
                retval = this.currentBuffer.getNextByte();
                this.totalReadBuffer.append((char)retval);
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
            if (this.isClosed && this.buffList.isEmpty()) {
                System.out.println("returning -1 bc pipeline is closed. \nTotalWrittenBuffer: " + this.totalWriteBuffer.toString() + "*********************************************" + "TotalreadBuffer: " + this.totalReadBuffer.toString());
                return -1;
            }
            if (true) ** GOTO lbl21
            {
                do {
                    this.buffList.wait();
                    if (!this.isClosed) continue;
                    return -1;
lbl21:
                    // 2 sources

                } while (this.buffList.isEmpty());
                this.currentBuffer = (Buffer)this.buffList.firstElement();
                this.buffList.removeElementAt(0);
                retval = this.currentBuffer.getNextByte();
                this.totalReadBuffer.append((char)retval);
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return retval;
            }
        }
    }

    class Buffer {
        byte[] bytes;
        int length;
        int ptr = 0;

        public Buffer(byte[] bytes, int length) {
            this.length = length;
            this.bytes = bytes;
        }

        public int getNextByte() {
            int retval = this.bytes[this.ptr++] & 0xFF;
            return retval;
        }
    }

    class MyTimer
    extends SIPStackTimerTask {
        Pipeline pipeline;
        private boolean isCancelled;

        protected MyTimer(Pipeline pipeline2) {
            this.pipeline = pipeline2;
        }

        protected void runTask() {
            if (this.isCancelled) {
                return;
            }
            try {
                System.out.println("Closing pipeline because of timeout");
                this.pipeline.close();
            }
            catch (IOException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }

        public boolean cancel() {
            boolean retval = super.cancel();
            this.isCancelled = true;
            return retval;
        }
    }
}

