/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.SocketConnection;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.parser.PipelinedMsgParser;
import sip4me.gov.nist.siplite.parser.SIPMessageListener;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.SIPServerException;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.gov.nist.siplite.stack.TCPMessageProcessor;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private SocketConnection mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private OutputStream myClientOutputStream;
    protected String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private final SIPMessageStack stack;
    private final String myAddress;
    private final int myPort;
    private String peerAddress;
    private int peerPort = -1;
    private String peerProtocol;
    private int viaPort = -1;
    private final TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(SocketConnection sock, SIPMessageStack sipStack, TCPMessageProcessor msgProcessor) throws IOException {
        this.stack = sipStack;
        this.mySock = sock;
        this.myAddress = sipStack.getHostAddress();
        this.peerAddress = sock.getAddress();
        this.myClientInputStream = sock.openInputStream();
        this.myClientOutputStream = sock.openOutputStream();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Creating new TCPMessageChannel " + this);
            LogWriter.logMessage(32, "Channel parameters: stack: " + this.stack + "\n" + "processor: " + msgProcessor + "\n" + "localAddress: " + this.myAddress + "\n" + "peerAddress: " + this.peerAddress + "\n" + "IS " + this.myClientInputStream + " Socket " + this.mySock);
        }
        this.stack.ioHandler.putSocket(this.stack.ioHandler.makeKey(this.mySock.getAddress(), this.mySock.getPort()), this.mySock, this.myClientOutputStream, this.myClientInputStream);
        this.mythread = new Thread((Runnable)this, "TCPMessageChannel - incoming connection");
        this.tcpMessageProcessor = msgProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(String inetAddr, int port, SIPMessageStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.stack = sipStack;
        this.tcpMessageProcessor = messageProcessor;
        this.myAddress = sipStack.getHostAddress();
        this.messageProcessor = messageProcessor;
        this.key = "TCP:" + this.stack.ioHandler.makeKey(this.peerAddress, this.peerPort);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Created new TCP Message Channel " + this + " with key " + this.key + "\nprocessor: " + messageProcessor);
        }
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block12: {
            try {
                try {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Closing message Channel " + this);
                    }
                    if (this.mySock != null) {
                        block11: {
                            try {
                                String addr = this.mySock.getAddress();
                                int port = this.mySock.getPort();
                                this.stack.ioHandler.removeAndCloseSocket(this.stack.ioHandler.makeKey(addr, port));
                            }
                            catch (IOException e) {
                                if (!LogWriter.needsLogging) break block11;
                                LogWriter.logMessage("Socket was already closed for " + this);
                            }
                        }
                        this.mySock = null;
                        break block12;
                    }
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Socket was already null for " + this);
                    }
                }
                catch (Exception ex) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Exception closing message Channel " + this);
                        LogWriter.logException(ex);
                    }
                    this.isRunning = false;
                    this.uncache();
                }
            }
            finally {
                this.isRunning = false;
                this.uncache();
            }
        }
    }

    public void closeFromParser() {
        block14: {
            try {
                try {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Closing message Channel " + this + " from Parser");
                    }
                    if (this.mySock != null) {
                        block13: {
                            try {
                                String addr = this.mySock.getAddress();
                                int port = this.mySock.getPort();
                                this.stack.ioHandler.removeAndCloseSocket(this.stack.ioHandler.makeKey(addr, port));
                            }
                            catch (IOException e) {
                                if (!LogWriter.needsLogging) break block13;
                                LogWriter.logMessage("Socket was already closed for " + this);
                            }
                        }
                        this.mySock = null;
                        break block14;
                    }
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Socket was already null for " + this);
                    }
                }
                catch (Exception ex) {
                    if (LogWriter.needsLogging && !this.stack.toExit) {
                        LogWriter.logMessage(2, "Exception closing message Channel " + this);
                        LogWriter.logException(ex);
                    }
                    this.isRunning = false;
                    this.uncache();
                    --this.tcpMessageProcessor.useCount;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("TCP Message Processor use count: " + this.tcpMessageProcessor.useCount);
                    }
                }
            }
            finally {
                this.isRunning = false;
                this.uncache();
                --this.tcpMessageProcessor.useCount;
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("TCP Message Processor use count: " + this.tcpMessageProcessor.useCount);
                }
            }
        }
    }

    private void sendMessage(byte[] msg, boolean retry) throws IOException {
        int portToUse = this.viaPort != -1 ? this.viaPort : this.peerPort;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("TCPMessageChannel, sendMessage()," + new String(msg) + "  to be sent to [" + this.peerAddress + ":" + portToUse + "/tcp] ");
        }
        if (!this.isRunning && !this.isCached) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "Tried to send message through a Message Channel that is no longer running. Create a new one.");
            }
            TCPMessageChannel newChannel = (TCPMessageChannel)this.tcpMessageProcessor.createMessageChannel(this.peerAddress, portToUse);
            newChannel.sendMessage(msg, retry);
            return;
        }
        SocketConnection sock = this.stack.ioHandler.sendBytes(this.peerAddress, portToUse, this.peerProtocol, msg, retry);
        if (sock != null && (this.mySock == null || sock != this.mySock && sock.getPort() == this.mySock.getPort())) {
            try {
                if (this.mySock != null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(16, "Closing socket on TCPMessageChannel and replacing with new one");
                    }
                    if (this.myClientOutputStream != null) {
                        this.myClientOutputStream.close();
                    }
                    if (this.myClientInputStream != null) {
                        this.myClientInputStream.close();
                    }
                    this.mySock.close();
                } else if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "TCP Msg channel " + this + " socket was null!");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.mySock = sock;
            this.myClientOutputStream = this.stack.ioHandler.getSocketOutputStream(this.mySock);
            this.myClientInputStream = this.stack.ioHandler.getSocketInputStream(this.mySock);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Creating new Thread from Message Channel " + this + " and new socket " + sock + " IS " + this.myClientInputStream);
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void sendMessage(Message sipMessage) throws IOException {
        if (sipMessage == null) {
            throw new NullPointerException("null arg!");
        }
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg, true);
        if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, String receiverAddress, int receiverPort, boolean retry) throws IOException, IllegalArgumentException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (!receiverAddress.equals(this.stack.outboundProxy)) {
            throw new IOException("Cannot proxy request");
        }
        SocketConnection sock = this.stack.ioHandler.sendBytes(this.peerAddress, this.peerPort, this.peerProtocol, message, retry);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientOutputStream = this.stack.ioHandler.getSocketOutputStream(this.mySock);
            this.myClientInputStream = this.stack.ioHandler.getSocketInputStream(this.mySock);
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void handleException(SIPServerException ex) {
        block6: {
            int rc = ex.getRC();
            String msgString = ex.getMessage();
            if (rc != 0) {
                Request request = (Request)ex.getSIPMessage();
                Response response = request.createResponse(rc);
                try {
                    this.sendMessage(response);
                }
                catch (IOException ioex) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logException(ioex);
                    }
                    break block6;
                }
            }
            try {
                this.sendMessage(msgString.getBytes(), false);
            }
            catch (IOException ioex) {
                if (!LogWriter.needsLogging) break block6;
                LogWriter.logException(ioex);
            }
        }
    }

    public void handleException(ParseException ex, Message sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (LogWriter.needsLogging) {
            LogWriter.logException(ex);
        }
        if (hdrClass.equals(FromHeader.clazz) || hdrClass.equals(ToHeader.clazz) || hdrClass.equals(CSeqHeader.clazz) || hdrClass.equals(ViaHeader.clazz) || hdrClass.equals(CallIdHeader.clazz) || hdrClass.equals(RequestLine.clazz) || hdrClass.equals(StatusLine.clazz)) {
            this.stack.logBadMessage(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Message sipMessage) {
        block34: {
            if (!this.stack.isAlive()) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "MsgChannel " + this + " is dropping message as the stack is closing");
                }
                return;
            }
            try {
                block33: {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("[TCPMessageChannel]-> Processing incoming message: " + sipMessage.getFirstLine());
                    }
                    if (sipMessage.getFromHeader() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeqHeader() == null || sipMessage.getViaHeaders() == null) {
                        String badmsg = sipMessage.encode();
                        if (LogWriter.needsLogging) {
                            ServerLog.logMessage("bad message " + badmsg);
                            ServerLog.logMessage(">>> Dropped Bad Msg");
                        }
                        this.stack.logBadMessage(badmsg);
                        return;
                    }
                    ViaList viaList = sipMessage.getViaHeaders();
                    if (sipMessage instanceof Request) {
                        ViaHeader v = (ViaHeader)viaList.first();
                        this.viaPort = v.hasPort() ? v.getPort() : 5060;
                        this.peerProtocol = v.getTransport();
                        try {
                            if (this.peerPort == -1) {
                                this.peerPort = this.mySock.getPort();
                            }
                            this.peerAddress = this.mySock.getAddress();
                            if (this.peerAddress == null && LogWriter.needsLogging) {
                                LogWriter.logMessage(2, "WARNING! Socket.getAddress() returned 'null'!!!");
                            }
                            if (v.hasParameter("rport") || !v.getHost().equals(this.peerAddress)) {
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage(16, "WARNING! \"Received\" parameter has been temporarily disabled. Response will be sent to topmost Via Host: " + v.getHost());
                                }
                                this.peerAddress = v.getHost();
                            }
                            if (v.hasParameter("rport")) {
                                v.setParameter("rport", Integer.toString(this.peerPort));
                            }
                            if (this.mySock.getAddress() == null || this.stack.maxConnections != -1 && this.tcpMessageProcessor.getNumConnections() >= this.stack.maxConnections) {
                                this.stack.ioHandler.disposeSocket(this.mySock, this.myClientInputStream, this.myClientOutputStream);
                                this.mySock = null;
                                this.myClientInputStream = null;
                                this.myClientOutputStream = null;
                                if (this.stack.maxConnections == -1) break block33;
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    this.tcpMessageProcessor.decreaseNumConnections();
                                    this.tcpMessageProcessor.notify();
                                    break block33;
                                }
                            }
                            if (!this.isCached) {
                                ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                                String key = "TCP:" + this.stack.ioHandler.makeKey(this.peerAddress, this.peerPort);
                                this.stack.ioHandler.putSocket(key, this.mySock, this.myClientOutputStream, this.myClientInputStream);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                long receptionTime = System.currentTimeMillis();
                if (sipMessage instanceof Request) {
                    SIPServerRequestInterface sipServerRequest;
                    Request sipRequest = (Request)sipMessage;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("----Processing Message---");
                    }
                    if ((sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this)) != null) {
                        try {
                            sipServerRequest.processRequest(sipRequest, this);
                            ServerLog.logMessage(sipMessage, String.valueOf(sipRequest.getViaHost()) + ":" + sipRequest.getViaPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), false, receptionTime);
                        }
                        catch (SIPServerException ex) {
                            ServerLog.logMessage(sipMessage, String.valueOf(sipRequest.getViaHost()) + ":" + sipRequest.getViaPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), ex.getMessage(), false, receptionTime);
                            this.handleException(ex);
                        }
                    } else if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Dropping request -- null sipServerRequest");
                    }
                    break block34;
                }
                Response sipResponse = (Response)sipMessage;
                SIPServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("got a response interface " + sipServerResponse);
                }
                try {
                    if (sipServerResponse != null) {
                        sipServerResponse.processResponse(sipResponse, this);
                    } else if (LogWriter.needsLogging) {
                        LogWriter.logMessage("null sipServerResponse!");
                    }
                }
                catch (SIPServerException ex) {
                    ServerLog.logMessage(sipMessage, String.valueOf(this.getPeerAddress().toString()) + ":" + this.getPeerPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), ex.getMessage(), false, receptionTime);
                }
            }
            catch (Exception ee) {
                if (!this.stack.isAlive()) break block34;
                throw new RuntimeException(ee.getClass() + ":" + ee.getMessage());
            }
        }
    }

    public void run() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "New TCP Message Channel Thread started " + this + " " + Thread.currentThread());
        }
        this.myParser = new PipelinedMsgParser(this, this.myClientInputStream, this.messageProcessor.getMaximumMessageSize());
        this.myParser.setMessageChannel(this);
        this.myParser.processInput();
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
    }

    public void handleIOException() {
    }

    protected void uncache() {
        this.tcpMessageProcessor.remove(this);
        this.isCached = false;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = "TCP:" + this.stack.ioHandler.makeKey(this.peerAddress, this.peerPort);
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public boolean isSecure() {
        return false;
    }
}

