/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.net.SocketException;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.TCPMessageChannel;

public class TCPMessageProcessor
extends MessageProcessor {
    private int nConnections = 0;
    public boolean isRunning;
    private final Hashtable tcpMessageChannels;
    private final Vector incomingTcpMessageChannels;
    protected int port;
    protected ServerSocketConnection serverSocket;
    public boolean ERROR_SOCKET = false;
    protected SIPMessageStack sipStack;

    public TCPMessageProcessor(SIPMessageStack sipStack, int port) {
        this.sipStack = sipStack;
        this.port = port;
        this.tcpMessageChannels = new Hashtable();
        this.incomingTcpMessageChannels = new Vector();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Created TCPMessageProcessor " + this);
        }
    }

    public void start() throws IOException {
        Thread thread = new Thread((Runnable)this, "TCPMessageProcessorThread");
        thread.setPriority(10);
        try {
            this.serverSocket = this.sipStack.getNetworkLayer().createServerSocket(this.getPort());
            if (this.serverSocket != null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Created server socket on " + this.serverSocket.getLocalAddress() + ":" + this.serverSocket.getLocalPort());
                }
                this.isRunning = true;
                thread.start();
            } else if (LogWriter.needsLogging) {
                LogWriter.logMessage("No server connection created  ");
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getClass() + " ::: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TCPMessageProcessor tCPMessageProcessor = this;
                synchronized (tCPMessageProcessor) {
                    while (this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                    this.increaseNumConnections();
                }
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Server socket blocked waiting for connections");
                }
                SocketConnection newsock = (SocketConnection)this.serverSocket.acceptAndOpen();
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("New socket created from incoming connection from host: " + newsock.getAddress());
                }
                this.incomingTcpMessageChannels.addElement(new TCPMessageChannel(newsock, this.sipStack, this));
            }
            catch (IOException ex) {
                if (!this.isRunning || !LogWriter.needsLogging) continue;
                LogWriter.logException(ex);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception ex) {
                if (!this.isRunning) continue;
                ex.printStackTrace();
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public String getTransport() {
        return "tcp";
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSipStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        TCPMessageChannel next;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Stopping TCPMessageProcessor");
        }
        this.isRunning = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Enumeration en = this.tcpMessageChannels.elements();
        while (en.hasMoreElements()) {
            next = (TCPMessageChannel)en.nextElement();
            next.close();
        }
        Enumeration incomingMCIterator = this.incomingTcpMessageChannels.elements();
        while (incomingMCIterator.hasMoreElements()) {
            next = (TCPMessageChannel)incomingMCIterator.nextElement();
            next.close();
        }
        this.notify();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("TCPMessageProcessor stopped");
        }
    }

    protected synchronized void remove(TCPMessageChannel tcpMessageChannel) {
        String key = tcpMessageChannel.getKey();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, this + " removing Channel " + tcpMessageChannel + " with key " + key);
        }
        if (this.tcpMessageChannels.get(key) == tcpMessageChannel) {
            this.tcpMessageChannels.remove(key);
            LogWriter.logMessage(32, "Message Channel " + tcpMessageChannel + " correctly uncached");
        } else {
            LogWriter.logMessage(32, "Message Channel " + tcpMessageChannel + " not indexed with key " + key + ". Instead: " + this.tcpMessageChannels.get(key));
        }
        this.incomingTcpMessageChannels.removeElement(tcpMessageChannel);
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = "TCP:" + this.sipStack.ioHandler.makeKey(targetHostPort.getHost().getAddress(), targetHostPort.getPort());
        if (this.tcpMessageChannels.get(key) != null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Returning existing channel " + this.tcpMessageChannels.get(key) + " with key " + key);
            }
            return (TCPMessageChannel)this.tcpMessageChannels.get(key);
        }
        TCPMessageChannel msgChannel = new TCPMessageChannel(targetHostPort.getHost().getAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.cacheMessageChannel(msgChannel);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Msg channel created " + msgChannel + " with key " + key);
        }
        return msgChannel;
    }

    public MessageChannel createMessageChannel(String host, int port) throws IOException {
        String key = "TCP:" + this.sipStack.ioHandler.makeKey(host, port);
        if (this.tcpMessageChannels.get(key) != null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Returning existing channel " + this.tcpMessageChannels.get(key) + " with key " + key);
            }
            return (TCPMessageChannel)this.tcpMessageChannels.get(key);
        }
        TCPMessageChannel msgChannel = new TCPMessageChannel(host, port, this.sipStack, this);
        this.cacheMessageChannel(msgChannel);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Msg channel created " + msgChannel + " with key " + key);
        }
        return msgChannel;
    }

    protected synchronized void cacheMessageChannel(TCPMessageChannel messageChannel) {
        TCPMessageChannel currentChannel;
        String key = messageChannel.getKey();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Caching Message Channel " + messageChannel + " with key " + key);
        }
        if ((currentChannel = (TCPMessageChannel)this.tcpMessageChannels.get(key)) != null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Replacing old channel. Closing " + currentChannel + " with key " + key);
            }
            currentChannel.close();
        }
        messageChannel.isCached = true;
        this.tcpMessageChannels.put(key, messageChannel);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized int increaseNumConnections() {
        ++this.nConnections;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "TCP connections increased to " + this.nConnections);
        }
        return this.nConnections;
    }

    public synchronized int decreaseNumConnections() {
        --this.nConnections;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "TCP connections reduced to " + this.nConnections);
        }
        return this.nConnections;
    }

    public synchronized int getNumConnections() {
        return this.nConnections;
    }
}

