/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.media.jsr135;

import java.io.IOException;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.media.protocol.ContentDescriptor;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;
import net.rim.device.api.media.control.AudioPathControl;
import org.linphone.jlinphone.media.jsr135.SendStream;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpSession;
import org.linphone.jortp.TimestampClock;

public class RecvStream
implements PlayerListener {
    private Player mPlayer;
    private SendStream mSendStream;
    private RtpSession mSession;
    private long mStartTime = 0L;
    private boolean mFirstRead = true;
    private boolean mRunning;
    private boolean mBuffering = true;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("RecvStream");
    private long mPlayerTs = -1L;
    private long mReturnedMs = 0L;
    private SourceStream mInput = new SourceStream(){
        byte[] sSilentAmr;
        private RtpPacket mTroncatedPacket;
        private int mTroncatedPacketSize;
        private boolean priority_set;
        ContentDescriptor mContentDescriptor;
        {
            byte[] byArray = new byte[32];
            byArray[0] = 60;
            byArray[1] = 72;
            byArray[2] = -11;
            byArray[3] = 31;
            byArray[4] = -106;
            byArray[5] = 102;
            byArray[6] = 121;
            byArray[7] = -31;
            byArray[8] = -32;
            byArray[9] = 1;
            byArray[10] = -25;
            byArray[11] = -118;
            byArray[12] = -16;
            byArray[16] = -64;
            this.sSilentAmr = byArray;
            this.priority_set = false;
            this.mContentDescriptor = new ContentDescriptor("audio/amr");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(byte[] b, int offset, int length) throws IOException {
            int bytesToReturn = this.sSilentAmr.length;
            if (RecvStream.this.mBuffering) {
                bytesToReturn = this.sSilentAmr.length * 8;
            }
            try {
                if (!this.priority_set && Thread.currentThread().getPriority() != 10) {
                    Thread.currentThread().setPriority(10);
                    this.priority_set = true;
                }
                int lWrittenLenth = 0;
                while (lWrittenLenth <= bytesToReturn && RecvStream.this.mRunning) {
                    long ts = RecvStream.this.getCurTs();
                    if (RecvStream.this.mPlayerTs == -1L) {
                        RecvStream.this.mPlayerTs = ts;
                        sLogger.info("Initializing timestamp to [" + RecvStream.this.mPlayerTs + "]");
                    }
                    RtpPacket packet = null;
                    try {
                        long diff;
                        while ((diff = ts - RecvStream.this.mPlayerTs) >= 0L) {
                            if (diff > 800L) {
                                RecvStream.this.mPlayerTs = ts - 800L;
                                sLogger.warn("Too late, skipping " + (diff - 800L) / 8L + " ms...");
                            }
                            if ((packet = RecvStream.this.mSession.recvPacket((int)RecvStream.this.mPlayerTs)) != null) {
                                RecvStream recvStream = RecvStream.this;
                                recvStream.mReturnedMs = recvStream.mReturnedMs + 20L;
                                if (RecvStream.this.mFirstRead) {
                                    String lAmrHeader = "#!AMR\n";
                                    lWrittenLenth = lAmrHeader.length();
                                    System.arraycopy(lAmrHeader.getBytes("US-ASCII"), 0, b, offset, lWrittenLenth);
                                    length -= lWrittenLenth;
                                    offset += lWrittenLenth;
                                    RecvStream.this.mFirstRead = false;
                                }
                                if (length < this.sSilentAmr.length) {
                                    System.arraycopy(packet.getBytes(), packet.getDataOffset() + 1, b, offset, length);
                                    lWrittenLenth += length;
                                    this.mTroncatedPacketSize = length;
                                    this.mTroncatedPacket = packet;
                                    if (sLogger.isLevelEnabled(28)) {
                                        sLogger.warn("End of buffer, [" + lWrittenLenth + "] bytes returned");
                                    }
                                    int n = lWrittenLenth;
                                    return n;
                                }
                                if (this.mTroncatedPacket != null) {
                                    int remain = this.mTroncatedPacket.getRealLength() - this.mTroncatedPacket.getDataOffset() - 1 - this.mTroncatedPacketSize;
                                    System.arraycopy(this.mTroncatedPacket.getBytes(), this.mTroncatedPacket.getDataOffset() + 1 + this.mTroncatedPacketSize, b, offset, remain);
                                    lWrittenLenth += remain;
                                    this.mTroncatedPacketSize = 0;
                                    this.mTroncatedPacket = null;
                                    offset += remain;
                                    length -= remain;
                                }
                                int datalen = packet.getRealLength() - packet.getDataOffset() - 1;
                                System.arraycopy(packet.getBytes(), packet.getDataOffset() + 1, b, offset, datalen);
                                lWrittenLenth += datalen;
                                length -= datalen;
                                offset += datalen;
                            }
                            RecvStream recvStream = RecvStream.this;
                            recvStream.mPlayerTs = recvStream.mPlayerTs + 160L;
                        }
                    }
                    catch (RtpException e) {
                        sLogger.error("Bad RTP packet", e);
                    }
                    if (packet != null) continue;
                    Thread.sleep(20L);
                }
                if (!RecvStream.this.mRunning) {
                    return -1;
                }
                if (sLogger.isLevelEnabled(31)) {
                    sLogger.debug("[" + lWrittenLenth + "] bytes returned");
                }
                int n = lWrittenLenth;
                return n;
            }
            catch (Throwable e) {
                sLogger.error("Exiting player input stream", e);
                return -1;
            }
            finally {
                if (bytesToReturn > this.sSilentAmr.length) {
                    RecvStream.this.mBuffering = false;
                }
            }
        }

        public ContentDescriptor getContentDescriptor() {
            return this.mContentDescriptor;
        }

        public long getContentLength() {
            return -1L;
        }

        public int getSeekType() {
            return 1;
        }

        public int getTransferSize() {
            return this.sSilentAmr.length;
        }

        public long seek(long where) throws IOException {
            sLogger.info("seeking to [" + where + "] just ignored");
            return where;
        }

        public long tell() {
            if (RecvStream.this.mStartTime == 0L) {
                return 0L;
            }
            return System.currentTimeMillis() - RecvStream.this.mStartTime;
        }

        public Control getControl(String controlType) {
            return null;
        }

        public Control[] getControls() {
            return null;
        }
    };

    private void reset() {
        this.mPlayer = null;
        this.mStartTime = 0L;
        this.mFirstRead = true;
        this.mBuffering = true;
        this.mPlayerTs = -1L;
        this.mReturnedMs = 0L;
    }

    public RecvStream(RtpSession session, SendStream sendStream) {
        this.mSession = session;
        this.mSendStream = sendStream;
    }

    public void stop() {
        if (this.mPlayer == null) {
            return;
        }
        this.mRunning = false;
        try {
            if (this.mPlayer.getState() == 400) {
                this.mPlayer.stop();
            }
            if (this.mPlayer.getState() != 0) {
                this.mPlayer.close();
            }
        }
        catch (MediaException e) {
            sLogger.error("Error stopping reveive stream", e);
        }
    }

    public void start() {
        this.mRunning = true;
        this.mSession.setTimestampClock(new TimestampClock(){

            public int getCurrentTimestamp() {
                return RecvStream.this.getCurTs();
            }
        });
        try {
            this.mPlayer = Manager.createPlayer((DataSource)new DataSource(null){
                SourceStream[] mStream;
                {
                    this.mStream = new SourceStream[]{RecvStream.this.mInput};
                }

                public void connect() throws IOException {
                    sLogger.info("connect data source");
                }

                public void disconnect() {
                    sLogger.info("disconnect data source");
                }

                public String getContentType() {
                    return "audio/amr";
                }

                public SourceStream[] getStreams() {
                    return this.mStream;
                }

                public void start() throws IOException {
                    sLogger.info("start data source");
                }

                public void stop() throws IOException {
                    sLogger.info("start data source");
                }

                public Control getControl(String controlType) {
                    return null;
                }

                public Control[] getControls() {
                    return null;
                }
            });
            this.mPlayer.addPlayerListener((PlayerListener)this);
            this.mPlayer.realize();
            AudioPathControl lPathCtr = (AudioPathControl)this.mPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
            lPathCtr.setAudioPath(0);
            this.mPlayer.prefetch();
            this.mPlayer.start();
            if (sLogger.isLevelEnabled(30)) {
                sLogger.info("Player is started .");
            }
        }
        catch (Throwable e) {
            sLogger.error("player error:", e);
        }
    }

    public void playerUpdate(Player arg0, String event, Object eventData) {
        if (sLogger.isLevelEnabled(30)) {
            sLogger.info("Got event " + event + "[" + (eventData == null ? "" : eventData.toString()) + "]" + "returned ms=" + this.mReturnedMs);
        }
        if (event == "bufferingStarted") {
            this.mBuffering = true;
        } else if (event == "deviceUnavailable") {
            try {
                this.mSendStream.getPlayer().stop();
            }
            catch (Throwable e) {
                sLogger.error("Enable to pause media players", e);
            }
        } else if (event == "deviceAvailable") {
            try {
                this.mSendStream.getPlayer().start();
                this.stop();
                this.reset();
                this.start();
            }
            catch (Throwable e) {
                sLogger.error("Enable to restart media players", e);
            }
        }
    }

    public int getPlayLevel() {
        if (this.mPlayer != null) {
            return ((VolumeControl)this.mPlayer.getControl("VolumeControl")).getLevel();
        }
        return 0;
    }

    public void setPlayLevel(int level) {
        if (this.mPlayer != null) {
            ((VolumeControl)this.mPlayer.getControl("VolumeControl")).setLevel(level);
        }
    }

    private int getCurTs() {
        if (this.mStartTime == 0L) {
            this.mStartTime = System.currentTimeMillis();
        }
        return (int)((System.currentTimeMillis() - this.mStartTime) * 8L);
    }

    public void enableSpeaker(boolean value) {
        if (this.mPlayer == null) {
            return;
        }
        AudioPathControl lPathCtr = (AudioPathControl)this.mPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
        try {
            lPathCtr.setAudioPath(value ? 1 : 0);
            sLogger.info("Speaker is " + (lPathCtr.getAudioPath() == 1 ? "enabled" : "disabled"));
        }
        catch (Throwable e) {
            sLogger.error("Cannot " + (value ? "enable" : "disable") + " speaker", e);
        }
    }

    public boolean isSpeakerEnabled() {
        if (this.mPlayer == null) {
            return false;
        }
        AudioPathControl lPathCtr = (AudioPathControl)this.mPlayer.getControl("net.rim.device.api.media.control.AudioPathControl");
        return lPathCtr.getAudioPath() == 1;
    }

    public long getPlayerTs() {
        return this.mPlayerTs;
    }
}

