/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.sal;

import org.linphone.jortp.PayloadType;

public class SalStreamDescription {
    private String mAddress;
    private PayloadType[] mPayloadTypes;
    private int mPort;
    private Proto mProto;
    private Type mType;
    private int mPtime;

    public String getAddress() {
        return this.mAddress;
    }

    public PayloadType[] getPayloadTypes() {
        return this.mPayloadTypes;
    }

    public int getPort() {
        return this.mPort;
    }

    public Proto getProto() {
        return this.mProto;
    }

    public Type getType() {
        return this.mType;
    }

    public void setAddress(String addr) {
        this.mAddress = addr;
    }

    public void setPayloadTypes(PayloadType[] pts) {
        this.mPayloadTypes = pts;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public void setProto(Proto p) {
        this.mProto = p;
    }

    public void setType(Type t) {
        this.mType = t;
    }

    public void setPtime(int ptime) {
        this.mPtime = ptime;
    }

    public int getPtime() {
        return this.mPtime;
    }

    private static boolean payloadsEquals(PayloadType[] pts1, PayloadType[] pts2) {
        if (pts1.length != pts2.length) {
            return false;
        }
        int i = 0;
        while (i < pts1.length) {
            PayloadType p1 = pts1[i];
            PayloadType p2 = pts2[i];
            if (!p1.equals(p2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean stringEquals(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public boolean equals(SalStreamDescription sd) {
        if (!this.stringEquals(this.getAddress(), sd.getAddress()) || this.getType() != sd.getType() || this.getPort() != sd.getPort() || this.getProto() != sd.getProto() || this.getPtime() != sd.getPtime()) {
            return false;
        }
        return SalStreamDescription.payloadsEquals(this.getPayloadTypes(), sd.getPayloadTypes());
    }

    public static class Proto {
        public static Proto RtpAvp = new Proto("RtpAvp");
        public static Proto RtpSavp = new Proto("RtpSavp");
        private String mStringValue;

        private Proto(String aStringValue) {
            this.mStringValue = aStringValue;
        }

        public String toString() {
            return this.mStringValue;
        }
    }

    public static class Type {
        public static Type Audio = new Type("Audio");
        public static Type Video = new Type("Video");
        public static Type Other = new Type("Other");
        private String mStringValue;

        private Type(String aStringValue) {
            this.mStringValue = aStringValue;
        }

        public String toString() {
            return this.mStringValue;
        }
    }
}

