/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.microedition.sip.SDPOutputStream;
import sip4me.gov.nist.microedition.sip.SipConnectionNotifierImpl;
import sip4me.gov.nist.microedition.sip.SipDialogImpl;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.TransactionAlreadyExistsException;
import sip4me.gov.nist.siplite.TransactionUnavailableException;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContactList;
import sip4me.gov.nist.siplite.header.ExpiresHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipServerConnection;

public class SipServerConnectionImpl
implements SipServerConnection {
    protected static final int REQUEST_RECEIVED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int STREAM_OPEN = 3;
    protected static final int COMPLETED = 4;
    protected static final int TERMINATED = 5;
    private int state = 1;
    private SipDialog sipDialog = null;
    private Request request = null;
    private Response response = null;
    private OutputStream contentOutputStream = null;
    private InputStream contentInputStream = null;
    private SipConnectionNotifierImpl sipConnectionNotifierImpl;

    protected SipServerConnectionImpl(Request request, SipDialog sipDialog, SipConnectionNotifierImpl sipConnectionNotifierImpl) {
        this.request = request;
        this.sipDialog = sipDialog;
        this.sipConnectionNotifierImpl = sipConnectionNotifierImpl;
    }

    public void initResponse(int code) throws IllegalArgumentException, sip4me.nist.javax.microedition.sip.SipException {
        ContactList contactList;
        if (code < 100 || code > 699) {
            throw new IllegalArgumentException("the response code is out of range.");
        }
        if (this.state != 1) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the response can not be initialized, because of wrong state.", 5);
        }
        try {
            this.response = StackConnector.messageFactory.createResponse(code, this.request);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        ToHeader toHeader = (ToHeader)this.response.getHeader("To");
        if (toHeader.getTag() == null) {
            toHeader.setTag(StackConnector.generateTag());
        }
        if ((contactList = this.response.getContactHeaders()) == null || contactList.isEmpty()) {
            ContactHeader contactHeader = null;
            try {
                Address address = StackConnector.addressFactory.createAddress("<sip:" + this.sipConnectionNotifierImpl.getLocalAddress() + ":" + this.sipConnectionNotifierImpl.getLocalPort() + ">");
                contactHeader = StackConnector.headerFactory.createContactHeader(address);
                this.response.addHeader(contactHeader);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
        this.state = 2;
    }

    public void setReasonPhrase(String phrase) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Reason Phrase can not be removed, because of wrong state.", 5);
        }
        if (phrase == null) {
            throw new IllegalArgumentException("The reason phrase can not be null");
        }
        this.response.setReasonPhrase(phrase);
    }

    public void send() throws IOException, InterruptedIOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 3 && this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("can not enable the refresh, because of wrong state.", 5);
        }
        ServerTransaction serverTransaction = (ServerTransaction)this.request.getTransaction();
        this.state = this.response.getStatusCode() / 100 != 1 ? 4 : 1;
        if (this.contentOutputStream != null) {
            this.response.setContent(this.contentOutputStream.toString());
            this.contentOutputStream = null;
        }
        if (serverTransaction == null) {
            try {
                SipProvider sipProvider = this.sipConnectionNotifierImpl.getSipProvider();
                serverTransaction = sipProvider.getNewServerTransaction(this.request);
            }
            catch (TransactionAlreadyExistsException taee) {
                taee.printStackTrace();
            }
            catch (TransactionUnavailableException tue) {
                tue.printStackTrace();
            }
        }
        serverTransaction.setApplicationData(this.sipConnectionNotifierImpl);
        try {
            serverTransaction.sendResponse(this.response);
        }
        catch (SipException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Couldn't send the response");
            e.printStackTrace();
        }
        if (serverTransaction.getDialog() == null) {
            return;
        }
        if (this.sipDialog == null) {
            this.sipDialog = new SipDialogImpl(serverTransaction.getDialog(), this.sipConnectionNotifierImpl, this.request.getRequestURI());
        } else if (StackConnector.getInstance().sipStack.isDialogCreated(this.request.getMethod())) {
            ((SipDialogImpl)this.sipDialog).setDialog(serverTransaction.getDialog());
        }
        if (this.response.isSuccessfulResponse()) {
            if (!this.response.getCSeqHeader().getMethod().equals("BYE")) {
                ((SipDialogImpl)this.sipDialog).setState((byte)2);
            } else {
                ((SipDialogImpl)this.sipDialog).setState((byte)3);
            }
        } else if (((SipDialogImpl)this.sipDialog).getDialog().getState() == 1 && this.response.getStatusCode() / 100 != 1) {
            serverTransaction.getDialog().setState(3);
        }
    }

    public void setHeader(String name, String value) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be set, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        this.response.attachHeader(header, true, true);
    }

    public void addHeader(String name, String value) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be add, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The header can not be created, check if it is correct");
        }
        this.response.addHeader(header);
    }

    public void removeHeader(String name) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be removed, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        this.response.removeHeader(name, true);
    }

    public String[] getHeaders(String name) {
        Enumeration e = this.request.getHeaders(name);
        int size = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++size;
        }
        if (size < 1) {
            return null;
        }
        String[] headers = new String[size];
        e = this.request.getHeaders(name);
        int count = 0;
        while (e.hasMoreElements()) {
            headers[count++] = ((Header)e.nextElement()).getHeaderValue();
        }
        return headers;
    }

    public String getHeader(String name) {
        Header hdr = this.request.getHeader(name);
        if (hdr != null) {
            return hdr.getHeaderValue();
        }
        return null;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestURI() {
        return this.request.getRequestURI().toString();
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public SipDialog getDialog() {
        return this.sipDialog;
    }

    public InputStream openContentInputStream() throws IOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 1) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the content input strean can not be open, because of wrong state.", 5);
        }
        byte[] buf = this.request.getRawContent();
        if (buf == null) {
            return null;
        }
        this.contentInputStream = new ByteArrayInputStream(buf);
        return this.contentInputStream;
    }

    public OutputStream openContentOutputStream() throws IOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the content output strean can not be open, because of wrong state.", 5);
        }
        if (this.response.getHeader("Content-Type") == null) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Content-Type unknown, set the content-type header first", 3);
        }
        if (this.response.getHeader("Content-Length") == null) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Content-Length unknown, set the content-length header first", 4);
        }
        this.contentOutputStream = new SDPOutputStream(this);
        this.state = 3;
        return this.contentOutputStream;
    }

    public void close() throws IOException {
        this.state = 5;
    }

    private void changeDialogState() {
        if (this.response.getCSeqHeader().getMethod().equals("REGISTER")) {
            return;
        }
        if (!this.response.isSuccessfulResponse()) {
            if (this.response.getCSeqHeader().getMethod().equals("SUBSCRIBE")) {
                ExpiresHeader expiresHeader = (ExpiresHeader)this.request.getHeader("Expires");
                if (expiresHeader.getExpires() == 0) {
                    ((SipDialogImpl)this.sipDialog).setState((byte)3);
                }
            } else if (!this.response.getCSeqHeader().getMethod().equals("BYE")) {
                if (this.sipDialog != null) {
                    ((SipDialogImpl)this.sipDialog).setState((byte)2);
                    ((SipDialogImpl)this.sipDialog).setDialogID(this.response.getDialogId(false));
                }
            } else {
                ((SipDialogImpl)this.sipDialog).setState((byte)3);
            }
        } else if (this.sipDialog.getState() == 1 && this.response.getStatusCode() / 100 != 1) {
            ((SipDialogImpl)this.sipDialog).setState((byte)3);
        }
    }
}

