/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.siplite.address.URI;

public class RequestLine
extends GenericObject {
    protected URI uri;
    protected String method;
    protected String sipVersion;
    public static Class clazz = new RequestLine().getClass();

    public RequestLine() {
        this.sipVersion = "SIP/2.0";
    }

    public void setSIPVersion(String sipVersion) {
        this.sipVersion = sipVersion;
    }

    public String encode() {
        StringBuffer encoding = new StringBuffer();
        if (this.method != null) {
            encoding.append(this.method);
            encoding.append(" ");
        }
        if (this.uri != null) {
            encoding.append(this.uri.encode());
            encoding.append(" ");
        }
        encoding.append(String.valueOf(this.sipVersion) + "\r\n");
        return encoding.toString();
    }

    public URI getUri() {
        return this.uri;
    }

    public RequestLine(URI requestURI, String method) {
        this.uri = requestURI;
        this.method = method;
        this.sipVersion = "SIP/2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        int i = 0;
        while (i < this.sipVersion.length()) {
            if (this.sipVersion.charAt(i) == '.') break;
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i) : String.valueOf(major) + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) == '/') {
                slash = true;
            }
            ++i;
        }
        return major;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        int i = 0;
        while (i < this.sipVersion.length()) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i) : String.valueOf(minor) + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) == '.') {
                dot = true;
            }
            ++i;
        }
        return minor;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RequestLine that = (RequestLine)other;
        try {
            retval = this.method.equals(that.method) && this.uri.equals(that.uri) && this.sipVersion.equals(that.sipVersion);
        }
        catch (NullPointerException ex) {
            retval = false;
        }
        return retval;
    }

    public Object clone() {
        RequestLine retval = new RequestLine();
        if (this.uri != null) {
            retval.uri = (URI)this.uri.clone();
        }
        if (this.method != null) {
            retval.method = new String(this.method);
        }
        if (this.sipVersion != null) {
            retval.sipVersion = new String(this.sipVersion);
        }
        return retval;
    }
}

