/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.header.ParametersHeader;
import sip4me.gov.nist.siplite.header.Protocol;

public class ViaHeader
extends ParametersHeader {
    public static Class clazz = new ViaHeader().getClass();
    public static final String NAME = "Via";
    public static final String BRANCH = "branch";
    public static final String HIDDEN = "hidden";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    public static final String RPORT = "rport";
    protected Protocol sentProtocol;
    protected HostPort sentBy = new HostPort();
    protected String comment;

    public ViaHeader() {
        super(NAME);
        this.sentProtocol = new Protocol();
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ViaHeader that = (ViaHeader)other;
        if (!this.sentProtocol.equals(that.sentProtocol)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.sentBy.equals(that.sentBy);
    }

    public String encodeBody() {
        String encoding = "";
        encoding = String.valueOf(encoding) + this.sentProtocol.encode() + " " + this.sentBy.encode();
        if (!this.sentBy.hasPort()) {
            encoding = String.valueOf(encoding) + ":5060";
        }
        if (this.comment != null) {
            encoding = String.valueOf(encoding) + "(" + this.comment + ")";
        }
        if (!this.parameters.isEmpty()) {
            encoding = String.valueOf(encoding) + ";" + this.parameters.encode();
        }
        return encoding;
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public boolean hasPort() {
        if (this.sentBy == null) {
            return false;
        }
        return this.getSentBy().hasPort();
    }

    public String getComment() {
        return this.comment;
    }

    public String getBranch() {
        return super.getParameter(BRANCH);
    }

    public String getReceived() {
        return super.getParameter(RECEIVED);
    }

    public String getMaddr() {
        return super.getParameter(MADDR);
    }

    public String getTTL() {
        return super.getParameter(TTL);
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String protocolVersion) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(protocolVersion);
    }

    public void setSentProtocol(Protocol s) {
        this.sentProtocol = s;
    }

    public void setTransport(String transport) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(transport);
    }

    public void setSentBy(HostPort s) {
        this.sentBy = s;
    }

    public void setComment(String c) {
        this.comment = c;
    }

    public Object clone() {
        ViaHeader retval = new ViaHeader();
        if (this.comment != null) {
            retval.comment = new String(this.comment);
        }
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        if (this.sentBy != null) {
            retval.sentBy = (HostPort)this.sentBy.clone();
        }
        if (this.sentProtocol != null) {
            retval.sentProtocol = (Protocol)this.sentProtocol.clone();
        }
        return retval;
    }

    public Object getValue() {
        return String.valueOf(this.sentProtocol.encode()) + " " + this.sentBy.encode();
    }

    public void setBranch(String branch) {
        super.setParameter(BRANCH, branch);
    }

    public void setHost(String host) {
        this.sentBy.setHost(new Host(host));
    }

    public void setHost(Host host) {
        this.sentBy.setHost(host);
    }

    public void setPort(int port) {
        this.sentBy.setPort(port);
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }
}

