/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.net.SocketException;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.UDPMessageChannel;

public class UDPMessageProcessor
extends MessageProcessor {
    private static final int HIGHWAT = 100;
    private static final int LOWAT = 50;
    protected boolean running;
    public static int MAX_DATAGRAM_SIZE = 1300;
    protected SIPMessageStack sipStack;
    protected DatagramConnection dc;
    protected Vector messageQueue;
    protected Vector messageChannels;
    protected int threadPoolSize;
    int port;

    protected UDPMessageProcessor(SIPMessageStack sipStack, int port) throws IOException {
        this.sipStack = sipStack;
        this.port = port;
        this.messageQueue = new Vector();
        this.useCount = 0;
        try {
            this.dc = sipStack.getNetworkLayer().createDatagramInboundSocket(port);
            MAX_DATAGRAM_SIZE = this.dc.getMaximumLength();
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "Setting maximum datagram size to " + MAX_DATAGRAM_SIZE);
            }
        }
        catch (SocketException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void start() {
        this.running = true;
        Thread thread = new Thread((Runnable)this, "UDPMessageProcessorThread");
        thread.setPriority(10);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.running = false;
            Vector vector = this.messageQueue;
            synchronized (vector) {
                this.messageQueue.notifyAll();
            }
            if (this.dc != null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Stopping UDPMessageProcessor");
                }
                Thread.sleep(300L);
                this.dc.close();
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("UDPMessageProcessor stoped");
                }
            }
        }
        catch (Exception ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("UDPMessageProcessor, stop(), exception raised:");
            }
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.running) {
            return;
        }
        this.messageChannels = new Vector();
        if (this.sipStack.threadPoolSize != -1) {
            int i = 0;
            while (i < this.sipStack.threadPoolSize) {
                UDPMessageChannel channel = new UDPMessageChannel(this.sipStack, this);
                this.messageChannels.addElement(channel);
                ++i;
            }
        }
        while (this.running) {
            try {
                Datagram packet = this.dc.newDatagram(MAX_DATAGRAM_SIZE);
                this.dc.receive(packet);
                if (LogWriter.needsLogging && packet.getLength() == MAX_DATAGRAM_SIZE) {
                    LogWriter.logMessage(16, "Incoming datagram is as big as Maximum Datagram Size. Some information might have been lost!");
                }
                if (this.messageQueue.size() >= 100) {
                    if (!LogWriter.needsLogging) continue;
                    LogWriter.logMessage("Dropping message -- queue length exceeded");
                    continue;
                }
                if (this.messageQueue.size() > 50 && this.messageQueue.size() < 100) {
                    boolean decision;
                    float threshold = (float)(this.messageQueue.size() - 50) / 50.0f;
                    Random rand = new Random(System.currentTimeMillis());
                    boolean bl = decision = (double)rand.nextFloat() > 1.0 - (double)threshold;
                    if (decision) {
                        if (!LogWriter.needsLogging) continue;
                        LogWriter.logMessage("Dropping message with probability " + (1.0 - (double)threshold));
                        continue;
                    }
                }
                if (this.sipStack.threadPoolSize != -1) {
                    Vector vector = this.messageQueue;
                    synchronized (vector) {
                        this.messageQueue.addElement(packet);
                        this.messageQueue.notify();
                        continue;
                    }
                }
                new UDPMessageChannel(packet, this.sipStack, this);
            }
            catch (IOException ex) {
                if (this.running && LogWriter.needsLogging) {
                    LogWriter.logMessage(2, "UDPMessageProcessor: Got an IO Exception");
                }
                this.running = false;
            }
            catch (Exception ex) {
                if (this.running && LogWriter.needsLogging) {
                    LogWriter.logMessage(2, "UDPMessageProcessor: Unexpected Exception - quitting");
                }
                this.running = false;
                InternalErrorHandler.handleException(ex);
                return;
            }
        }
    }

    public String getTransport() {
        return "UDP";
    }

    public int getPort() {
        return this.port;
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) {
        return new UDPMessageChannel(targetHostPort.getHost().getHostname(), targetHostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(String host, int port) {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return MAX_DATAGRAM_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUse() {
        Vector vector = this.messageQueue;
        synchronized (vector) {
            return this.messageQueue.size() != 0;
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }
}

