/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.core;

import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.core.LinphoneProxyConfig;
import org.linphone.jlinphone.core.LinphoneCoreImpl;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.sal.SalAddress;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalOp;

class LinphoneProxyConfigImpl
implements LinphoneProxyConfig {
    private String mProxy;
    private String mDialPrefix;
    private int mExpires = 600;
    private boolean mEscapePlus = false;
    private boolean mEnableRegister = false;
    private boolean mRegistered;
    private boolean mCommit = false;
    private SalOp mOp;
    private LinphoneCoreImpl mCore;
    private SalAddress mIdentityAddress;
    static Logger mLog = JOrtpFactory.instance().createLogger("LinphoneCore");

    LinphoneProxyConfigImpl() {
    }

    LinphoneProxyConfigImpl(String identity, String proxy, String route, boolean enableRegister) throws LinphoneCoreException {
        this();
        this.setIdentity(identity);
        this.mProxy = proxy;
        this.mEnableRegister = enableRegister;
    }

    public void done() {
        this.mCommit = true;
    }

    public void edit() {
        if (this.mOp != null && this.mCore != null) {
            this.mOp.unregister();
            this.mOp = null;
        }
    }

    public void enableRegister(boolean value) throws LinphoneCoreException {
        this.mEnableRegister = value;
    }

    public String getDomain() {
        return this.mIdentityAddress.getDomain();
    }

    public String normalizePhoneNumber(String number) {
        return number;
    }

    public void setDialEscapePlus(boolean value) {
        this.mEscapePlus = value;
    }

    public boolean isDialPlusEscaped() {
        return this.mEscapePlus;
    }

    public void setDialPrefix(String prefix) {
        this.mDialPrefix = prefix;
    }

    public void setIdentity(String identity) throws LinphoneCoreException {
        this.mIdentityAddress = SalFactory.instance().createSalAddress(identity);
    }

    public void setProxy(String proxyUri) throws LinphoneCoreException {
        this.mProxy = proxyUri;
    }

    public String getIdentity() {
        return this.mIdentityAddress.asStringUriOnly();
    }

    public String getProxy() {
        return this.mProxy;
    }

    public boolean isRegistered() {
        return this.mRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.mRegistered = isRegistered;
    }

    public boolean registerEnabled() {
        return this.mEnableRegister;
    }

    public void check(LinphoneCoreImpl core) {
        this.mCore = core;
        if (this.mCommit) {
            if (this.mEnableRegister) {
                this.mOp = core.getSal().createSalOp();
                try {
                    core.mListener.displayStatus(core, "Registration in progress");
                    core.mListener.registrationState(core, this, LinphoneCore.RegistrationState.RegistrationProgress, null);
                    this.mOp.register(this.mProxy, this.getIdentity(), this.mExpires);
                }
                catch (SalException e) {
                    mLog.error("Registration Error", e);
                }
            } else if (this.mOp != null) {
                this.mOp.unregister();
                this.mOp = null;
            }
            this.mCommit = false;
        }
    }

    public String getRoute() {
        throw new RuntimeException("Not implemented yet");
    }

    public void setRoute(String routeUri) throws LinphoneCoreException {
        throw new RuntimeException("Not implemented yet");
    }

    public void enablePublish(boolean enable) {
        throw new RuntimeException("Not implemented yet");
    }

    public LinphoneCore.RegistrationState getState() {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean publishEnabled() {
        throw new RuntimeException("Not implemented yet");
    }

    public void setExpires(int delay) {
        throw new RuntimeException("Not implemented yet");
    }
}

