/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.media;

import java.util.Timer;
import java.util.TimerTask;
import org.linphone.jlinphone.media.AudioStream;
import org.linphone.jlinphone.media.AudioStreamParameters;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.PayloadType;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpProfile;
import org.linphone.jortp.RtpSession;
import org.linphone.jortp.RtpTransport;
import org.linphone.jortp.SocketAddress;

public class AudioStreamEchoImpl
implements AudioStream {
    private AudioStreamParameters mParams;
    private RtpSession mSession;
    private Timer mTimer = new Timer();

    public void init(SocketAddress local) throws RtpException {
        this.mSession = JOrtpFactory.instance().createRtpSession();
        this.mSession.setLocalAddr(local);
    }

    public void start(AudioStreamParameters params) throws RtpException {
        this.mParams = params;
        this.mSession.setRemoteAddr(this.mParams.getRemoteDest());
        this.mSession.setProfile(this.mParams.getRtpProfile());
        this.mSession.setSendPayloadTypeNumber(this.mParams.getActivePayloadTypeNumber());
        this.mSession.setRecvPayloadTypeNumber(this.mParams.getActivePayloadTypeNumber());
        this.mTimer = new Timer();
        this.mTimer.scheduleAtFixedRate((TimerTask)new EchoTask(), 0L, 10L);
    }

    public void stop() {
        this.mTimer.cancel();
        this.mSession.close();
    }

    public int getPlayLevel() {
        return -1;
    }

    public void setPlayLevel(int level) {
    }

    public boolean isStarted() {
        return false;
    }

    public void enableSpeaker(boolean value) {
    }

    public boolean isMicMuted() {
        return false;
    }

    public boolean isSpeakerEnabled() {
        return false;
    }

    public void muteMic(boolean isMuted) {
    }

    public void setRtpTransport(RtpTransport t) {
        this.mSession.setTransport(t);
    }

    class EchoTask
    extends TimerTask {
        private long mTime;
        private RtpSession mSession;
        private int mClockrate;

        EchoTask() {
            this.mSession = AudioStreamEchoImpl.this.mSession;
            RtpProfile prof = this.mSession.getProfile();
            PayloadType pt = prof.getPayloadType(this.mSession.getSendPayloadTypeNumber());
            this.mClockrate = pt.getClockRate();
        }

        public void run() {
            int ts = (int)this.mTime * this.mClockrate;
            RtpPacket p = null;
            try {
                p = this.mSession.recvPacket(ts);
                if (p != null) {
                    this.mSession.sendPacket(p, ts);
                }
            }
            catch (RtpException e) {
                e.printStackTrace();
            }
        }
    }
}

