/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import java.io.PrintStream;
import net.rim.device.api.system.EventLogger;

public class LogWriter {
    static final long sip_for_me = 1098697294345051466L;
    static boolean isBB = false;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_EXCEPTION = 2;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_DEBUG = 32;
    private static String logFileName;
    public static PrintStream traceWriter;
    public static boolean needsLogging;
    private static PrintStream trace;
    protected static int traceLevel;

    static {
        try {
            Class.forName("net.rim.device.api.system.EventLogger");
            EventLogger.register((long)1098697294345051466L, (String)"sip-for-me", (int)2);
            isBB = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        traceWriter = System.out;
        needsLogging = false;
        trace = System.out;
        traceLevel = 0;
    }

    public static void logStackTrace() {
    }

    public static void logException(Exception ex) {
        if (needsLogging && traceLevel >= 2) {
            String message = ex.getClass() + ": " + ex.getMessage();
            System.err.println(message);
            ex.printStackTrace();
            if (isBB) {
                EventLogger.logEvent((long)1098697294345051466L, (byte[])message.getBytes());
            }
        }
    }

    public static synchronized void logMessage(String message, String remoteLogger) {
        LogWriter.logMessage(0, message);
    }

    public static void logMessage(int level, String message) {
        if (needsLogging && traceLevel >= level) {
            System.out.println(String.valueOf(System.currentTimeMillis()) + " :: " + message);
            if (isBB) {
                EventLogger.logEvent((long)1098697294345051466L, (byte[])message.getBytes(), (int)LogWriter.sipforme2BBlevel(level));
            }
        }
    }

    public static void logMessage(String message) {
        if (needsLogging && traceLevel >= 16) {
            System.out.println(String.valueOf(System.currentTimeMillis()) + " :: " + message);
            if (isBB) {
                EventLogger.logEvent((long)1098697294345051466L, (byte[])message.getBytes(), (int)LogWriter.sipforme2BBlevel(16));
            }
        }
    }

    public static void setTraceLevel(int level) {
        traceLevel = level;
    }

    public static int getTraceLevel() {
        return traceLevel;
    }

    public static void setLogFileName(String logFileName) {
    }

    private static int sipforme2BBlevel(int level) {
        switch (level) {
            case 32: {
                return 0;
            }
            case 16: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 2;
    }
}

