/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core.net;

import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.net.NetworkLayer;
import sip4me.gov.nist.core.net.SocketException;

public class DefaultNetworkLayer
implements NetworkLayer {
    public static final DefaultNetworkLayer SINGLETON = new DefaultNetworkLayer();

    public ServerSocketConnection createServerSocket(int port) throws SocketException {
        String location = "socket://:" + port;
        try {
            return (ServerSocketConnection)Connector.open((String)location);
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SocketException(iae.getMessage());
        }
        catch (ConnectionNotFoundException cnfe) {
            throw new SocketException(cnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public SocketConnection createSocket(String targetAddress, int targetPort) throws SocketException {
        String location = "socket://" + targetAddress + ":" + targetPort;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Opening TCP socket to " + location);
        }
        try {
            return (SocketConnection)Connector.open((String)location);
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SocketException(iae.getMessage());
        }
        catch (ConnectionNotFoundException cnfe) {
            throw new SocketException(cnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public DatagramConnection createDatagramSocket(String targetAddress, int targetPort) throws SocketException {
        String location = "datagram://" + targetAddress + ":" + targetPort;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Opening UDP socket to " + location);
        }
        try {
            return (DatagramConnection)Connector.open((String)location);
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SocketException(iae.getMessage());
        }
        catch (ConnectionNotFoundException cnfe) {
            throw new SocketException(cnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public DatagramConnection createDatagramInboundSocket(int targetPort) throws SocketException {
        String location = "datagram://:" + targetPort;
        try {
            return (DatagramConnection)Connector.open((String)location);
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SocketException(iae.getMessage());
        }
        catch (ConnectionNotFoundException cnfe) {
            throw new SocketException(cnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public String getDNSresolution(String domainOrIP) {
        return domainOrIP;
    }

    public ServerSocketConnection createServerSocket(String ip, int port) throws SocketException {
        return null;
    }
}

