/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import java.util.Vector;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class MediaField
extends SDPField {
    protected String media;
    protected int port;
    protected int nports;
    protected String proto;
    protected Vector formats = new Vector();

    public Object clone() {
        MediaField retval = new MediaField();
        retval.media = this.media;
        retval.port = this.port;
        retval.nports = this.nports;
        retval.proto = this.proto;
        int i = 0;
        while (i < this.formats.size()) {
            retval.formats.addElement(this.formats.elementAt(i));
            ++i;
        }
        return retval;
    }

    public MediaField() {
        super("m=");
    }

    public String getMedia() {
        return this.media;
    }

    public int getPort() {
        return this.port;
    }

    public int getNports() {
        return this.nports;
    }

    public String getProto() {
        return this.proto;
    }

    public Vector getFormats() {
        return this.formats;
    }

    public void setMedia(String m) {
        this.media = m;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setNports(int n) {
        this.nports = n;
    }

    public void setProto(String p) {
        this.proto = p;
    }

    public void setFormats(Vector formats) {
        this.formats = formats;
    }

    public String getMediaType() throws SdpParseException {
        return this.getMedia();
    }

    public void setMediaType(String mediaType) throws SdpException {
        if (mediaType == null) {
            throw new SdpException("The mediaType is null");
        }
        this.setMedia(mediaType);
    }

    public int getMediaPort() throws SdpParseException {
        return this.getPort();
    }

    public void setMediaPort(int port) throws SdpException {
        if (port < 0) {
            throw new SdpException("The port is < 0");
        }
        this.setPort(port);
    }

    public int getPortCount() throws SdpParseException {
        return this.getNports();
    }

    public void setPortCount(int portCount) throws SdpException {
        if (portCount < 0) {
            throw new SdpException("The port count is < 0");
        }
        this.setNports(portCount);
    }

    public String getProtocol() throws SdpParseException {
        return this.getProto();
    }

    public void setProtocol(String protocol) throws SdpException {
        if (protocol == null) {
            throw new SdpException("The protocol is null");
        }
        this.setProto(protocol);
    }

    public Vector getMediaFormats(boolean create) throws SdpParseException {
        if (!create && this.formats.size() == 0) {
            return null;
        }
        return this.formats;
    }

    public void setMediaFormats(Vector mediaFormats) throws SdpException {
        if (mediaFormats == null) {
            throw new SdpException("The mediaFormats is null");
        }
        this.formats = mediaFormats;
    }

    private String encodeFormats() {
        String retval = "";
        int i = 0;
        while (i < this.formats.size()) {
            retval = String.valueOf(retval) + this.formats.elementAt(i);
            if (i < this.formats.size() - 1) {
                retval = String.valueOf(retval) + " ";
            }
            ++i;
        }
        return retval;
    }

    public String encode() {
        String encoded_string = "m=";
        if (this.media != null) {
            encoded_string = String.valueOf(encoded_string) + this.media + " " + this.port;
        }
        if (this.nports > 1) {
            encoded_string = String.valueOf(encoded_string) + "/" + this.nports;
        }
        if (this.proto != null) {
            encoded_string = String.valueOf(encoded_string) + " " + this.proto;
        }
        if (this.formats != null) {
            encoded_string = String.valueOf(encoded_string) + " " + this.encodeFormats();
        }
        encoded_string = String.valueOf(encoded_string) + "\r\n";
        return encoded_string;
    }
}

