/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.microedition.sip.SipClientConnectionImpl;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.AuthorizationHeader;
import sip4me.gov.nist.siplite.header.ProxyAuthorizationHeader;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipClientConnectionListener;
import sip4me.nist.javax.microedition.sip.SipConnection;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipException;

public class SipDialogImpl
implements SipDialog {
    private byte state = 1;
    private String dialogID = null;
    protected Dialog dialog = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private URI requestURI = null;
    private SipClientConnectionListener sipClientConnectionListener = null;
    protected ProxyAuthorizationHeader proxyAuthorizationHeader = null;
    protected AuthorizationHeader authorizationHeader = null;

    protected SipDialogImpl(Dialog dialog, SipConnectionNotifier sipConnectionNotifier, URI requestURI) {
        if (dialog != null) {
            this.dialogID = dialog.getDialogId();
        }
        this.dialog = dialog;
        this.sipConnectionNotifier = sipConnectionNotifier;
        this.requestURI = requestURI;
    }

    public SipClientConnection getNewClientConnection(String method) throws IllegalArgumentException, SipException {
        if (this.state != 2) {
            throw new SipException("the client connection can not be initialized, because of wrong state.", 5);
        }
        SipClientConnectionImpl scc = new SipClientConnectionImpl(this.requestURI, this);
        if (method.trim().equalsIgnoreCase("ACK")) {
            scc.initAck();
        } else if (method.trim().equalsIgnoreCase("CANCEL")) {
            scc.initCancel();
        } else {
            scc.initRequest(method, this.sipConnectionNotifier);
        }
        return scc;
    }

    public boolean isSameDialog(SipConnection sc) {
        if (this.state == 3) {
            return false;
        }
        return sc.getDialog().getDialogID().equals(this.dialogID);
    }

    public byte getState() {
        return this.state;
    }

    public String getDialogID() {
        if (this.state == 3) {
            return null;
        }
        return this.dialogID;
    }

    protected void setDialogID(String dialogID) {
        this.dialogID = dialogID;
    }

    protected void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.setDialogID(dialog.getDialogId());
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    protected void setSipClientConnectionListener(SipClientConnectionListener sipClientConnectionListener) {
        this.sipClientConnectionListener = sipClientConnectionListener;
    }

    protected SipClientConnectionListener getSipClientConnectionListener() {
        return this.sipClientConnectionListener;
    }

    protected void setState(byte state) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(16, "setting state of SipDialog to " + state);
        }
        this.state = state;
    }
}

