/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.address;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.address.SipURI;

public class URI
extends GenericObject {
    public static final String SIP = "sip";
    public static final String SIPS = "sips";
    public static final String TEL = "tel";
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    public static final String USER = "user";
    public static final String TRANSPORT = "transport";
    public static final String METHOD = "method";
    public static final String TTL = "ttl";
    public static final String MADDR = "maddr";
    public static final String LR = "lr";
    protected String uriString;
    protected String scheme;

    protected URI() {
    }

    public URI(String uriString) throws ParseException {
        try {
            this.uriString = uriString;
            int i = uriString.indexOf(":");
            this.scheme = uriString.substring(0, i);
        }
        catch (Exception e) {
            throw new ParseException("URI, Bad URI format", 0);
        }
    }

    public String encode() {
        return this.uriString;
    }

    public String toString() {
        return this.encode();
    }

    public Object clone() {
        try {
            return new URI(this.uriString);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.valueOf(ex.getMessage()) + this.uriString);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSipURI() {
        return this instanceof SipURI;
    }
}

