/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;

public abstract class MessageProcessor
implements Runnable {
    protected static final String IN_ADDR_ANY = "0.0.0.0";
    protected static final String IN6_ADDR_ANY = "::0";
    private String sentBy;
    private HostPort sentByHostPort;
    private boolean sentBySet;
    private ListeningPoint listeningPoint;
    int useCount;

    public ViaHeader getViaHeader() {
        ViaHeader via = new ViaHeader();
        Host host = new Host();
        host.setHostname(this.getSIPStack().getHostAddress());
        via.setHost(host);
        via.setPort(this.getPort());
        via.setTransport(this.getTransport());
        via.setParameter("rport", "");
        return via;
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        this.listeningPoint = listeningPoint;
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public abstract String getTransport();

    public abstract int getPort();

    public abstract SIPMessageStack getSIPStack();

    public abstract MessageChannel createMessageChannel(HostPort var1) throws IOException;

    public abstract MessageChannel createMessageChannel(String var1, int var2) throws IOException;

    public abstract void start() throws IOException;

    public abstract void stop();

    public abstract int getDefaultTargetPort();

    public abstract boolean isSecure();

    public abstract int getMaximumMessageSize();

    public abstract /* synthetic */ void run();
}

