/*
 * Decompiled with CFR 0.152.
 */
package sip4me.nist.javax.microedition.sip;

import java.util.Vector;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.header.Header;

public class SipHeader {
    public static final String ERROR_INFO = "Error-Info";
    public static final String MIME_VERSION = "Mime-Version";
    public static final String IN_REPLY_TO = "In-Reply-To";
    public static final String ALLOW = "Allow";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CALL_INFO = "Call-Info";
    public static final String CSEQ = "CSeq";
    public static final String ALERT_INFO = "Alert-Info";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT = "Accept";
    public static final String ENCRYPTION = "Encryption";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String RECORD_ROUTE = "Record-Route";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TO = "To";
    public static final String VIA = "Via";
    public static final String FROM = "From";
    public static final String CALL_ID = "Call-Id";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String SERVER = "Server";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String HIDE = "Hide";
    public static final String ROUTE = "Route";
    public static final String CONTACT = "Contact";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORGANIZATION = "Organization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String REQUIRE = "Require";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String SUBJECT = "Subject";
    public static final String USER_AGENT = "User-Agent";
    public static final String WARNING = "Warning";
    public static final String PRIORITY = "Priority";
    public static final String DATE = "Date";
    public static final String EXPIRES = "Expires";
    public static final String RESPONSE_KEY = "Response-Key";
    public static final String WARN_AGENT = "Warn-Agent";
    public static final String SUPPORTED = "Supported";
    public static final String EVENT = "Event";
    public static final String P_ASSOCIATED_URI = "P-Associated-URI";
    public static final String P_PREFERRED_IDENTITY = "P-Preferred-Identity";
    private Header header = null;

    public SipHeader(String name, String value) throws IllegalArgumentException {
        try {
            this.header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public void setName(String name) throws IllegalArgumentException {
        this.header.setHeaderName(name);
    }

    public String getName() {
        return this.header.getName();
    }

    public String getValue() {
        return this.header.getValue().toString();
    }

    public String getHeaderValue() {
        return this.header.getHeaderValue();
    }

    public void setValue(String value) throws IllegalArgumentException {
        this.header.setHeaderValue(value);
    }

    public String getParameter(String name) {
        NameValueList parameterList = this.header.getParameters();
        return parameterList.getParameter(name);
    }

    public String[] getParameterNames() {
        NameValueList parameterList = this.header.getParameters();
        Vector parameterNameList = parameterList.getNames();
        String[] parameterNames = new String[parameterNameList.size()];
        int i = 0;
        while (i < parameterList.size()) {
            parameterNames[i] = (String)parameterNameList.elementAt(i);
            ++i;
        }
        return parameterNames;
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        NameValueList parameterList = this.header.getParameters();
        parameterList.add(name, value);
    }

    public void removeParameter(String name) {
        NameValueList parameterList = this.header.getParameters();
        parameterList.delete(name);
    }

    public String toString() {
        return this.header.toString();
    }
}

