;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-display-map
  (lambda ()
    (let (
	  (look (lw6-get-game-global "look"))
	  (loaded (lw6-get-game-global "loaded"))
	  )
      (if loaded
	  (let (
		(loaded-map (assoc-ref loaded "level"))
		)
	    (c-lw6gfx-display-map-preview loaded-map look))))))

(define lw6-display-hud
  (lambda (step)
    (let (
	  (look (lw6-get-game-global "look"))
	  (map-source (lw6-get-game-global "map-source"))
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (let(
	       (game-state (assoc-ref game-instance "game-state"))
	       )
	    (c-lw6gfx-display-hud game-state step look)
	    )	  
	  (c-lw6gfx-display-hud-preview step look)))))

(define lw6-display-fps
  (lambda ()
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (if (lw6-config-is-true? "display-fps")
	  (c-lw6gfx-display-fps %lw6-frames-per-sec look)
	  ))))

(define lw6-display-menu
  (lambda ()
    (let* (
	   (look (lw6-get-game-global "look"))
	   (map-source (lw6-get-game-global "map-source"))
	   (menu (lw6-current-menu))
	   (menu-smob (assoc-ref menu "smob"))
	   )
      (if menu-smob (c-lw6gfx-display-menu menu-smob look)))))

(define lw6-display-idle
  (lambda ()
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-menu)
	(lw6-display-fps)
	(c-lw6gfx-swap-buffers)
	))))

(define lw6-display-preview
  (lambda () 
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-map)
	(lw6-display-menu)
	(lw6-display-fps)
	(c-lw6gfx-swap-buffers)
      ))))

(define lw6-display-game
  (lambda () 
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-hud 0)
	(lw6-display-map)
	(lw6-display-hud 1)
	(lw6-display-menu)
	(c-lw6gfx-display-sysinfo %lw6-frames-per-sec %lw6-rounds-per-sec 0 0)
	(c-lw6gfx-display-log (list 
			       (_ "this is where") 
			       (_ "messages") 
			       (_ "could be logged")
			       ))
	(lw6-display-fps)
	(c-lw6gfx-swap-buffers)
	))))

(define lw6-display
  (lambda ()
    (let (
	  (display-func (lw6-get-game-global "display-func"))
	  )
      (if display-func
	  (display-func)
	  )
      )
    )
  )


