;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-logic
  (lambda ()
    (let (
	  (logic-func (lw6-get-game-global "logic-func"))
	  )
      (if logic-func
	  (logic-func)
	  )
      )
    )
  )

(define lw6-logic-idle
  (lambda ()
    #t
    )
  )

(define lw6-logic-game
  (lambda ()
    (let (
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (let (
		(game-state (assoc-ref game-instance "game-state"))
		)
	    (if (> (lw6-get-theorical-moves) (c-lw6ker-get-moves game-state))
		(c-lw6ker-do-round game-state)
		)
	    )
	  )
      )
    )
  )

(define lw6-get-theorical-moves
  (lambda ()
    (let (
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (let (
		(t (c-lw6gfx-get-ticks))
		(t0 (lw6-get-game-global "t0"))
		(moves-per-tick (assoc-ref game-instance "moves-per-tick"))
		)
	    ( * (- t t0) moves-per-tick)
	    )
	  0
	  )
      )	  
    )
  )


