;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-time-options-menu-time-item-list
  (list
   30
   60
   120
   180
   300
   600
   900
   1200
   1800
   2700
   3600
   5400
   7200
   10800
   14400
   21600
   43200
   86400))

(define lw6-time-options-menu-time-item-label-func
  (lambda (menuitem)
    (let* (
	   (total-time (lw6-config-get-number lw6def-total-time))
	   (hours (quotient total-time 3600))
	   (minutes1 (modulo (quotient total-time 600) 6))
	   (minutes2 (modulo (quotient total-time 60) 10))
	   (seconds1 (modulo (quotient total-time 10) 6))
	   (seconds2 (modulo total-time 10))
	  )
      (format #f 
	      (_ "Time ~a:~a~a:~a~a") 
	      hours minutes1 minutes2 seconds1 seconds2)
      )))

(define lw6-time-options-menu-time-item-update-func
  (lambda (menuitem)
    (let* (
	   (value (assoc-ref menuitem "value"))
	  )
      (lw6-config-set-number! lw6def-total-time (list-ref lw6-time-options-menu-time-item-list value))
      )))

(define lw6-time-options-menu-time-item-index-func
  (lambda (menuitem)
    (let* (
	   (total-time (lw6-config-get-number lw6def-total-time))
	   (index 0)
	  )
      (begin
	(map (lambda (v) (if (> total-time v) (set! index (+ index 1)))) lw6-time-options-menu-time-item-list)
	(if (>= index (length lw6-time-options-menu-time-item-list))
	    (set! index (- (length lw6-time-options-menu-time-item-list) 1)))
	index
	))))

(define lw6-time-options-menu-time-item
  (lambda ()
    (lw6-menu-item-list-template
     lw6-time-options-menu-time-item-label-func
     lw6-time-options-menu-time-item-update-func
     lw6-time-options-menu-time-item-index-func
     lw6-time-options-menu-time-item-list)
    ))

(define lw6-time-options-menu-speed-item-list
  (list
   (cons 2 1)
   (cons 5 1)
   (cons 10 1)
   (cons 15 1)
   (cons 20 1)
   (cons 25 1)
   (cons 33 1)
   (cons 40 1)
   (cons 50 1)
   (cons 60 1)
   (cons 40 2)
   (cons 50 2)
   (cons 60 2)
   (cons 50 3)
   (cons 50 4)
   (cons 50 5)
   (cons 100 3)
   (cons 100 4)
   (cons 100 5)))

(define lw6-time-options-menu-speed-item-label-func
  (lambda (menuitem)
    (let* (
	   (rps (lw6-config-get-number lw6def-rounds-per-sec))
	   (mpr (lw6-config-get-number lw6def-moves-per-round))
	   (mps (* rps mpr))
	   )
    (format #f (_ "Speed ~ax~a=~a") rps mpr mps))))


(define lw6-time-options-menu-speed-item-update-func
  (lambda (menuitem)
    (let* (
	   (value (assoc-ref menuitem "value"))
	   (rps-and-mpr (list-ref lw6-time-options-menu-speed-item-list value))
	   (rps (car rps-and-mpr))
	   (mpr (cdr rps-and-mpr))
	  )
      (lw6-config-set-number! lw6def-rounds-per-sec rps)
      (lw6-config-set-number! lw6def-moves-per-round mpr)
      )))

(define lw6-time-options-menu-speed-item-index-func
  (lambda (menuitem)
    (let* (
	   (rps (lw6-config-get-number lw6def-rounds-per-sec))
	   (mpr (lw6-config-get-number lw6def-moves-per-round))
	   (mps (* rps mpr))
	   (index 0)
	  )
      (begin
	(map (lambda (v) (if (> mps (* (car v) (cdr v))) (set! index (+ index 1)))) lw6-time-options-menu-speed-item-list)
	(if (>= index (length lw6-time-options-menu-speed-item-list))
	    (set! index (- (length lw6-time-options-menu-speed-item-list) 1)))
	index
	))))

(define lw6-time-options-menu-speed-item
  (lambda ()
    (lw6-menu-item-list-template
     lw6-time-options-menu-speed-item-label-func
     lw6-time-options-menu-speed-item-update-func
     lw6-time-options-menu-speed-item-index-func
     lw6-time-options-menu-speed-item-list)
    ))

(define lw6-time-options-menu
  (lambda()
    (let (
	  (menu (lw6-menu-template (_ "Time & speed")))
	  (old-total-time (lw6-config-get-number lw6def-total-time))
	  (old-rounds-per-sec (lw6-config-get-number lw6def-rounds-per-sec))
	  (old-moves-per-round (lw6-config-get-number lw6def-moves-per-round))
	  )
      (begin
	(lw6-append-menuitem! menu (lw6-time-options-menu-time-item))
	(lw6-append-menuitem! menu (lw6-time-options-menu-speed-item))
	(set! menu (assoc-set! menu "on-pop" 
			       (lambda (m) 
				 (if 
				  (or (not (equal? old-total-time (lw6-config-get-number lw6def-total-time)))
				      (not (equal? old-rounds-per-sec (lw6-config-get-number lw6def-rounds-per-sec)))
				      (not (equal? old-moves-per-round (lw6-config-get-number lw6def-moves-per-round))))
				  (begin (lw6-game-param-update) 
					 (lw6-loader-push (lw6-config-get-string lw6def-chosen-map)))))))
	menu
	))))
