/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import net.percederberg.mib.Mib;
import net.percederberg.mib.SymbolFactory;
import net.percederberg.mib.asn1.analysis.DepthFirstAdapter;
import net.percederberg.mib.asn1.node.Node;
import net.percederberg.mib.symbol.Symbol;
import net.percederberg.mib.symbol.TypeSymbol;
import net.percederberg.mib.symbol.ValueSymbol;
import net.percederberg.mib.type.ArrayType;
import net.percederberg.mib.type.CompoundType;
import net.percederberg.mib.type.Constraint;
import net.percederberg.mib.type.EnumerationType;
import net.percederberg.mib.type.IntegerType;
import net.percederberg.mib.type.NamedType;
import net.percederberg.mib.type.ObjectIdentifierType;
import net.percederberg.mib.type.SizeConstraint;
import net.percederberg.mib.type.SnmpModuleIdentityType;
import net.percederberg.mib.type.SnmpNotificationType;
import net.percederberg.mib.type.SnmpObjectIdentityType;
import net.percederberg.mib.type.SnmpObjectType;
import net.percederberg.mib.type.SnmpTextualConventionType;
import net.percederberg.mib.type.SnmpTrapType;
import net.percederberg.mib.type.StringType;
import net.percederberg.mib.type.Type;
import net.percederberg.mib.type.ValueConstraint;
import net.percederberg.mib.type.ValueRangeConstraint;

class SecondPassAnalysis
extends DepthFirstAdapter {
    private Mib mib = null;
    private SymbolFactory factory = null;

    public SecondPassAnalysis(Mib mib) {
        this.mib = mib;
        this.factory = new SymbolFactory(mib);
    }

    protected void outTypeAssignment(Node node) {
        TypeSymbol sym = (TypeSymbol)this.getOut(node.childOfType(268));
        Type type = (Type)this.getOut(node.childOfType(218));
        if (sym != null && type != null) {
            sym.setType(type);
        }
    }

    protected void outType(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outBuiltinType(Node node) {
        if (node.childrenOfType(49) == 1) {
            this.setOut(node, ObjectIdentifierType.getInstance());
        } else if (node.childrenOfType(220) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        } else if (node.childrenOfType(224) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        } else if (node.childrenOfType(226) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        } else if (node.childrenOfType(227) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        } else if (node.childrenOfType(228) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        } else if (node.childrenOfType(229) == 1) {
            this.setOut(node, this.getOut(node.childAt(0)));
        }
    }

    protected void inIntegerType(Node node) {
        if (node.childrenOfType(221) > 0) {
            EnumerationType type = new EnumerationType();
            this.setIn(node.childOfType(221), type);
            this.setOut(node, type);
        }
    }

    protected void outIntegerType(Node node) {
        if (node.childrenOfType(221) != 1) {
            if (node.childrenOfType(242) == 1) {
                Object obj = this.getOut(node.childOfType(242));
                if (obj instanceof ValueRangeConstraint) {
                    this.setOut(node, new IntegerType((ValueRangeConstraint)obj));
                } else {
                    this.mib.addError("integer used with non-integer constraint", node.firstLine(), node.lastLine());
                    this.setOut(node, new IntegerType());
                }
            } else {
                this.setOut(node, new IntegerType());
            }
        }
    }

    protected void inNamedNumberList(Node node) {
        Object obj = this.getIn(node);
        if (obj == null) {
            obj = new EnumerationType();
            this.setIn(node, obj);
        }
        int i = 0;
        while (i < node.children()) {
            this.setIn(node.childAt(i), obj);
            ++i;
        }
    }

    protected void outNamedNumber(Node node) {
        EnumerationType type = (EnumerationType)this.getIn(node);
        if (node.childrenOfType(223) > 0) {
            String label = (String)this.getOut(node.childOfType(266));
            Number value = (Number)this.getOut(node.childOfType(223));
            if (label != null && value != null) {
                type.addValue(label, value);
            }
        } else {
            this.mib.addWarning("defined number values not supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outSignedNumber(Node node) {
        Number num = (Number)this.getOut(node.childOfType(265));
        if (node.childrenOfType(17) > 0) {
            if (num instanceof Integer) {
                this.setOut(node, new Integer(-num.intValue()));
            } else {
                this.setOut(node, new Long(-num.longValue()));
            }
        } else {
            this.setOut(node, num);
        }
    }

    protected void outStringType(Node node) {
        StringType type = null;
        if (node.childrenOfType(242) == 1) {
            Object obj = this.getOut(node.childOfType(242));
            if (obj instanceof SizeConstraint) {
                type = new StringType((SizeConstraint)obj);
            } else {
                this.mib.addError("strings can only have size constraints", node.firstLine(), node.lastLine());
            }
        }
        if (type == null) {
            this.setOut(node, new StringType());
        } else {
            this.setOut(node, type);
        }
    }

    protected void inSequenceType(Node node) {
        CompoundType t = new CompoundType();
        if (node.childrenOfType(230) == 1) {
            this.setIn(node.childOfType(230), t);
        }
        this.setOut(node, t);
    }

    protected void outSequenceOfType(Node node) {
        Type t = (Type)this.getOut(node.childOfType(218));
        if (node.childrenOfType(248) == 1) {
            Object obj = this.getOut(node.childOfType(248));
            this.setOut(node, new ArrayType(t, (SizeConstraint)obj));
        } else {
            this.setOut(node, new ArrayType(t));
        }
    }

    protected void inSetType(Node node) {
        this.inSequenceType(node);
    }

    protected void outSetOfType(Node node) {
        this.outSequenceOfType(node);
    }

    protected void inElementTypeList(Node node) {
        Object obj = this.getIn(node);
        int i = 0;
        while (i < node.children()) {
            this.setIn(node.childAt(i), obj);
            ++i;
        }
    }

    protected void outElementType(Node node) {
        if (node.children() == 1) {
            CompoundType compound = (CompoundType)this.getIn(node);
            Object obj = this.getOut(node.childAt(0));
            if (obj instanceof ValueSymbol) {
                compound.addComponent((ValueSymbol)obj);
            } else {
                this.mib.addError("set or sequence element not declared separately as a variable", node.firstLine(), node.lastLine());
            }
        } else {
            this.mib.addWarning("only set or sequence elements that are simple variables are supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outNamedType(Node node) {
        if (node.childrenOfType(266) == 1) {
            Object obj = this.getOut(node.childOfType(266));
            this.setOut(node, this.mib.getSymbol(obj.toString()));
        }
    }

    protected void outDefinedType(Node node) {
        Constraint c = null;
        if (node.childrenOfType(267) > 0) {
            this.mib.addWarning("module references unsupported", node.firstLine(), node.lastLine());
        }
        Symbol sym = (Symbol)this.getOut(node.childOfType(268));
        if (node.childrenOfType(242) > 0) {
            c = (Constraint)this.getOut(node.childOfType(242));
        }
        if (sym instanceof TypeSymbol) {
            this.setOut(node, new NamedType((TypeSymbol)sym, c));
        }
    }

    protected void outConstraintList(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
        if (node.children() != 1) {
            this.mib.addWarning("multiple constraints not supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outConstraint(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outValueConstraint(Node node) {
        Object obj = null;
        if (node.childrenOfType(245) > 0) {
            obj = this.getOut(node.childOfType(245));
        } else {
            obj = this.getOut(node.childOfType(251));
            if (obj instanceof Number) {
                obj = new ValueConstraint((Number)obj);
            } else {
                this.mib.addWarning("only numeric value constraints are supported", node.firstLine(), node.lastLine());
            }
        }
        this.setOut(node, obj);
    }

    protected void outValueRange(Node node) {
        Number lower = (Number)this.getOut(node.childOfType(246));
        Number upper = (Number)this.getOut(node.childOfType(247));
        this.setOut(node, new ValueRangeConstraint(lower, upper));
    }

    protected void outLowerEndPoint(Node node) {
        if (node.childrenOfType(18) > 0) {
            this.mib.addWarning("unsupported constraint limit modifier: <", node.firstLine(), node.lastLine());
        }
        if (node.childrenOfType(251) == 1) {
            Object obj = this.getOut(node.childOfType(251));
            if (obj instanceof Number) {
                this.setOut(node, obj);
            } else {
                this.mib.addError("constraint limit not a number", node.firstLine(), node.lastLine());
            }
        }
    }

    protected void outUpperEndPoint(Node node) {
        if (node.childrenOfType(18) > 0) {
            this.mib.addWarning("unsupported constraint limit modifier: <", node.firstLine(), node.lastLine());
        }
        if (node.childrenOfType(251) == 1) {
            Object obj = this.getOut(node.childOfType(251));
            if (obj instanceof Number) {
                this.setOut(node, obj);
            } else {
                this.mib.addError("constraint limit not a number", node.firstLine(), node.lastLine());
            }
        }
    }

    protected void outSizeConstraint(Node node) {
        Object obj = this.getOut(node.childOfType(244));
        if (obj instanceof ValueRangeConstraint) {
            this.setOut(node, new SizeConstraint((ValueRangeConstraint)obj));
        } else if (obj instanceof ValueConstraint) {
            this.setOut(node, new SizeConstraint((ValueConstraint)obj));
        } else {
            this.mib.addError("size constraint must have value range", node.firstLine(), node.lastLine());
        }
    }

    protected void outValueAssignment(Node node) {
        ValueSymbol value = null;
        ObjectId oid = null;
        String id = (String)this.getOut(node.childOfType(266));
        Type type = (Type)this.getOut(node.childOfType(218));
        Object obj = this.getOut(node.childOfType(251));
        Symbol sym = this.mib.getSymbol(id);
        if (sym instanceof ValueSymbol) {
            value = (ValueSymbol)sym;
        }
        if (obj instanceof ObjectId) {
            oid = (ObjectId)obj;
        }
        if (value != null && type != null) {
            value.setType(type);
        }
        if (value != null && oid != null) {
            if (oid.isSimple()) {
                value.setParent(oid.getParentSymbol());
                value.setOID(oid.getValue());
            } else {
                this.mib.addWarning("cannot handle complex object identifiers: " + oid, node.firstLine(), node.lastLine());
            }
        }
    }

    protected void outValue(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outDefinedValue(Node node) {
        String id = (String)this.getOut(node.childOfType(266));
        this.setOut(node, this.mib.getSymbol(id));
    }

    protected void outBuiltinValue(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outObjectIdentifierValue(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outObjIdComponentList(Node node) {
        this.setOut(node, this.getOut(node.childAt(node.children() - 1)));
    }

    protected void outObjIdComponent(Node node) {
        Node parent = node.getParent();
        ObjectId oid = (ObjectId)this.getIn(node);
        if (node.childrenOfType(265) == 1) {
            Number value = (Number)this.getOut(node.childOfType(265));
            oid = new ObjectId(oid, value.intValue());
        } else if (node.childrenOfType(266) == 1) {
            String id = (String)this.getOut(node.childOfType(266));
            Symbol sym = this.mib.getSymbol(id);
            if (sym == null && (sym = this.factory.findSymbol(id)) != null) {
                this.mib.addSymbol(sym);
                this.mib.addWarning("symbol not imported, added implicitly: " + sym.getName(), node.firstLine(), node.lastLine());
            }
            if (sym instanceof ValueSymbol) {
                if (oid != null) {
                    this.mib.addError("overruled object identifier before " + sym, node.firstLine(), node.lastLine());
                }
                oid = new ObjectId((ValueSymbol)sym);
            } else {
                this.mib.addError("object identifier symbol not found: " + id, node.firstLine(), node.lastLine());
            }
        } else {
            this.mib.addWarning("only object identifiers in either name or number form are handled", node.firstLine(), node.lastLine());
        }
        this.setOut(node, oid);
        if (parent.childAfter(node) != null) {
            this.setIn(parent.childAfter(node), oid);
        }
    }

    protected void outIdentifier(Node node) {
        this.setOut(node, this.getOut(node.childOfType(109)));
    }

    protected void outTypeReference(Node node) {
        String id = (String)this.getOut(node.childOfType(109));
        Symbol sym = this.mib.getSymbol(id);
        if (sym == null) {
            sym = this.factory.findSymbol(id);
            if (sym == null) {
                this.mib.addError("reference to unknown symbol: " + id, node.firstLine(), node.lastLine());
            } else {
                this.mib.addSymbol(sym);
                this.mib.addWarning("symbol not imported, added implicitly: " + sym.getName(), node.firstLine(), node.lastLine());
            }
        }
        if (sym instanceof TypeSymbol) {
            this.setOut(node, sym);
        } else if (sym != null) {
            this.mib.addError("type reference to non-type symbol: " + sym, node.firstLine(), node.lastLine());
        }
    }

    protected void outNumber(Node node) {
        this.setOut(node, this.getOut(node.childOfType(110)));
    }

    protected void outDefinedMacroType(Node node) {
        this.setOut(node, this.getOut(node.childAt(0)));
    }

    protected void outSnmpModuleIdentityMacroType(Node node) {
        Date update = null;
        String org = null;
        String contact = null;
        String desc = null;
        update = (Date)this.getOut(node.childOfType(281));
        org = (String)this.getOut(node.childOfType(282));
        contact = (String)this.getOut(node.childOfType(283));
        desc = (String)this.getOut(node.childOfType(284));
        this.setOut(node, new SnmpModuleIdentityType(update, org, contact, desc));
    }

    protected void outSnmpObjectIdentityMacroType(Node node) {
        Integer status = null;
        String desc = null;
        String ref = null;
        status = (Integer)this.getOut(node.childOfType(286));
        if (status == null) {
            status = new Integer(5);
        }
        desc = (String)this.getOut(node.childOfType(284));
        if (node.childrenOfType(287) > 0) {
            ref = (String)this.getOut(node.childOfType(287));
            this.setOut(node, new SnmpObjectIdentityType(status, desc, ref));
        } else {
            this.setOut(node, new SnmpObjectIdentityType(status, desc));
        }
    }

    protected void outSnmpObjectTypeMacroType(Node node) {
        String units = null;
        String descr = null;
        String ref = null;
        Vector index = null;
        Object defval = null;
        Type subtype = (Type)this.getOut(node.childOfType(288));
        Integer access = (Integer)this.getOut(node.childOfType(293));
        Integer status = (Integer)this.getOut(node.childOfType(286));
        if (access == null) {
            access = new Integer(0);
        }
        if (status == null) {
            status = new Integer(5);
        }
        if (node.childrenOfType(292) == 1) {
            units = (String)this.getOut(node.childOfType(292));
        }
        if (node.childrenOfType(284) == 1) {
            descr = (String)this.getOut(node.childOfType(284));
        }
        if (node.childrenOfType(287) == 1) {
            ref = (String)this.getOut(node.childOfType(287));
        }
        if (node.childrenOfType(294) == 1) {
            index = (Vector)this.getOut(node.childOfType(294));
        }
        if (node.childrenOfType(297) == 1) {
            defval = this.getOut(node.childOfType(297));
        }
        this.setOut(node, new SnmpObjectType(subtype, access, status, descr, index, defval));
    }

    protected void outSnmpNotificationTypeMacroType(Node node) {
        Integer status = null;
        String desc = null;
        String ref = null;
        if (node.childrenOfType(298) > 0) {
            this.mib.addWarning("notification object values not supported", node.firstLine(), node.lastLine());
        }
        if ((status = (Integer)this.getOut(node.childOfType(286))) == null) {
            status = new Integer(5);
        }
        desc = (String)this.getOut(node.childOfType(284));
        if (node.childrenOfType(287) > 0) {
            ref = (String)this.getOut(node.childOfType(287));
            this.setOut(node, new SnmpNotificationType(status, desc, ref));
        } else {
            this.setOut(node, new SnmpNotificationType(status, desc));
        }
    }

    protected void outSnmpTrapTypeMacroType(Node node) {
        String enterprise = "";
        Vector vars = null;
        String desc = null;
        String ref = null;
        enterprise = (String)this.getOut(node.childOfType(300));
        if (node.childrenOfType(301) > 0) {
            vars = (Vector)this.getOut(node.childOfType(301));
        }
        if (node.childrenOfType(284) > 0) {
            desc = (String)this.getOut(node.childOfType(284));
        }
        if (node.childrenOfType(287) > 0) {
            ref = (String)this.getOut(node.childOfType(287));
        }
        this.setOut(node, new SnmpTrapType(enterprise, vars, desc, ref));
    }

    protected void outSnmpTextualConventionMacroType(Node node) {
        String hint = null;
        Integer status = null;
        String desc = null;
        String ref = null;
        Type syntax = null;
        if (node.childrenOfType(303) > 0) {
            hint = (String)this.getOut(node.childOfType(303));
        }
        if ((status = (Integer)this.getOut(node.childOfType(286))) == null) {
            status = new Integer(5);
        }
        desc = (String)this.getOut(node.childOfType(284));
        if (node.childrenOfType(287) > 0) {
            ref = (String)this.getOut(node.childOfType(287));
        }
        syntax = (Type)this.getOut(node.childOfType(288));
        this.setOut(node, new SnmpTextualConventionType(status, desc, ref, hint, syntax));
    }

    protected void outSnmpUpdatePart(Node node) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmm'Z'");
        String str = (String)this.getOut(node.childOfType(108));
        try {
            this.setOut(node, format.parse(str));
        }
        catch (ParseException e) {
            this.mib.addError("invalid module update date: " + str, node.firstLine(), node.lastLine());
        }
    }

    protected void outSnmpOrganizationPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(108)));
    }

    protected void outSnmpContactPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(108)));
    }

    protected void outSnmpDescrPart(Node node) {
        String text = (String)this.getOut(node.childOfType(108));
        String result = "";
        int pos = 0;
        while ((pos = text.indexOf(10)) >= 0) {
            result = result + text.substring(0, pos).trim() + "\n";
            text = text.substring(pos + 1);
        }
        if ((text = text.trim()).length() > 0) {
            result = result + text;
        }
        this.setOut(node, result);
    }

    protected void outSnmpStatusPart(Node node) {
        String str = (String)this.getOut(node.childOfType(266));
        if (str.equals("mandatory")) {
            this.setOut(node, new Integer(1));
        } else if (str.equals("optional")) {
            this.setOut(node, new Integer(2));
        } else if (str.equals("current")) {
            this.setOut(node, new Integer(3));
        } else if (str.equals("deprecated")) {
            this.setOut(node, new Integer(4));
        } else if (str.equals("obsolete")) {
            this.setOut(node, new Integer(5));
        } else {
            this.mib.addError("invalid snmp status: " + str, node.firstLine(), node.lastLine());
        }
    }

    protected void outSnmpReferPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(108)));
    }

    protected void outSnmpSyntaxPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(289)));
    }

    protected void outTypeOrBits(Node node) {
        if (node.childrenOfType(218) > 0) {
            this.setOut(node, this.getOut(node.childOfType(218)));
        } else {
            this.mib.addWarning("bits type not supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outSnmpUnitsPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(108)));
    }

    protected void outSnmpAccessPart(Node node) {
        String str = (String)this.getOut(node.childOfType(266));
        if (str.equals("not-accessible")) {
            this.setOut(node, new Integer(0));
        } else if (str.equals("accessible-for-notify")) {
            this.setOut(node, new Integer(1));
        } else if (str.equals("read-only")) {
            this.setOut(node, new Integer(2));
        } else if (str.equals("write-only")) {
            this.setOut(node, new Integer(3));
        } else if (str.equals("read-write")) {
            this.setOut(node, new Integer(4));
        } else if (str.equals("read-create")) {
            this.setOut(node, new Integer(5));
        } else {
            this.mib.addError("invalid snmp access: " + str, node.firstLine(), node.lastLine());
        }
    }

    protected void outSnmpIndexPart(Node node) {
        if (node.childrenOfType(295) > 0) {
            this.setOut(node, this.getOut(node.childOfType(295)));
        } else {
            this.mib.addWarning("index augments not supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outTypeOrValueList(Node node) {
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < node.children()) {
            Object obj = this.getOut(node.childAt(i));
            if (obj != null) {
                v.addElement(obj);
            }
            ++i;
        }
        if (v.size() > 0) {
            this.setOut(node, v);
        }
    }

    protected void outTypeOrValue(Node node) {
        if (node.childrenOfType(251) > 0) {
            Object obj = this.getOut(node.childAt(0));
            if (node.childrenOfType(91) > 0) {
                obj = this.getOut(node.childAt(1));
            }
            if (obj instanceof ValueSymbol) {
                this.setOut(node, obj);
            } else {
                this.mib.addWarning("unsupported index (must be a value field)", node.firstLine(), node.lastLine());
            }
        } else {
            this.mib.addWarning("type indices not supported", node.firstLine(), node.lastLine());
        }
    }

    protected void outSnmpDefValPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(251)));
    }

    protected void outSnmpEnterprisePart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(266)));
    }

    protected void outSnmpVarPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(302)));
    }

    protected void outVarTypes(Node node) {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < node.children()) {
            vars.add((String)this.getOut(node.childAt(i)));
            ++i;
        }
        this.setOut(node, vars);
    }

    protected void outSnmpDisplayPart(Node node) {
        this.setOut(node, this.getOut(node.childOfType(108)));
    }

    protected void outTCSTRING(Node node) {
        String text = node.toString();
        if (text.startsWith("\"")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"")) {
            text = text.substring(0, text.length() - 1);
        }
        int pos = 0;
        while ((pos = text.indexOf("\"\"", pos)) >= 0) {
            text = text.substring(0, pos) + text.substring(pos + 1);
        }
        this.setOut(node, text);
    }

    protected void outTIDENT(Node node) {
        this.setOut(node, node.toString());
    }

    protected void outTNUMBER(Node node) {
        Number num;
        try {
            num = new Integer(node.toString());
        }
        catch (Exception e) {
            num = new Long(node.toString());
        }
        this.setOut(node, num);
    }

    private class ObjectId {
        private ObjectId parent;
        private ValueSymbol symbol;
        private int value;

        public ObjectId(ValueSymbol symbol) {
            this(null, symbol, -1);
        }

        public ObjectId(ObjectId parent, int value) {
            this(parent, null, value);
        }

        public ObjectId(ObjectId parent, ValueSymbol symbol, int value) {
            this.parent = parent;
            this.symbol = symbol;
            this.value = value;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isSymbolicRoot() {
            return this.parent == null && this.symbol != null;
        }

        public boolean isSimple() {
            return !this.isRoot() && this.parent.isSymbolicRoot() && this.value >= 0;
        }

        public ValueSymbol getParentSymbol() {
            if (this.parent != null) {
                return this.parent.symbol;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String base = "";
            if (this.parent != null) {
                base = this.parent.toString();
            }
            if (this.symbol == null) {
                return base + "." + this.value;
            }
            if (this.value < 0) {
                return base + "." + this.symbol;
            }
            return base + "." + this.symbol + "(" + this.value + ")";
        }
    }
}

