/**
 *
 * Ce programme montre comment engendrer des entiers, réels et booléens
 * aléatoires.
 *
 * Pour cela, il utilise les fonctions suivantes:
 *
 *------------------------------------------------------------------------------
 * MLV_boolean_random:  Renvoie un booléen aléatoire.
 *
 * int MLV_boolean_random();
 *
 *------------------------------------------------------------------------------
 * MLV_integer_random : Renvoie un entier aléatoire choisi dans un intervalle 
 *                      donné en paramètre.
 * 
 * int MLV_integer_random(
 *    int    begin,    Borne inférieur de l'intervalle ( inclusif )
 *    int    end       Borne supérieur de l'intervalle ( inclusif )
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_double_random : Renvoie un réel aléatoire choisi dans un intervalle donné
 *                     en paramètre.
 *
 * double MLV_double_random(
 *    double    begin,    Borne inférieur de l'intervalle ( inclusif )
 *    double    end       Borne supérieur de l'intervalle ( inclusif )
 * );
 *
 * Ces fonctions sont décrites dans le fichier MLV_random.h.
 * Leurs documentations sont accéssibles en tapant dans le terminal la commande
 * suivante :
 *
 * man MLV_random.h
 * 
 */

#ifdef __cplusplus
extern "C" {
#endif
       #include <MLV/MLV_all.h>
#ifdef __cplusplus
}
#endif

#include <stdio.h>

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main(int argc, char *argv[]){
	//
	// Déclaration des variables qui contiendront les
	// nombres aléatoires qui seront engendrés
	//
	int resultat_i, resultat_b;
	double resultat_d;

	//
	// Récupère et affiche un entier aléatoire
	//
	resultat_i = MLV_integer_random(3,100);
	printf( "Entier aléatoire entre 3 et 100 : %i\n", resultat_i );

	//
	// Récupère et affiche un réel aléatoire
	//
	resultat_d = MLV_double_random( 3.0, 100.0 );
	printf( "Réel aléatoire entre 3.0 et 100.0 : %f\n", resultat_d );

	//
	// Récupère et affiche un booléen aléatoire
	//
	resultat_b = MLV_boolean_random();
	printf( "Boolean aléatoire : %i\n", resultat_b );

	return 0;
}
