#ifndef __MOBIUS_CRYPT_CIPHER_STREAM_H__
#define __MOBIUS_CRYPT_CIPHER_STREAM_H__
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <cstdint>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Abstract base class for stream ciphers
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_stream
{
public:
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief virtual destructor for safe inheritance
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  virtual ~cipher_stream () {}

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief encrypt data block
  //! \param first input iterator to the first element
  //! \param last input iterator to one element after last
  //! \param result output iterator
  //! \return output iterator updated
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  template <class InputIterator, class OutputIterator> OutputIterator
  encrypt (InputIterator first, InputIterator last, OutputIterator result)
  {
    while (first != last)
      {
        *result = _encrypt_byte (*first);
        ++first;
        ++result;
      }
      
    return result;
  }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief decrypt data block
  //! \param first input iterator to the first element
  //! \param last input iterator to one element after last
  //! \param result output iterator
  //! \return output iterator updated
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  template <class InputIterator, class OutputIterator> OutputIterator
  decrypt (InputIterator first, InputIterator last, OutputIterator result)
  {
    while (first != last)
      {
        *result = _decrypt_byte (*first);
        ++first;
        ++result;
      }

    return result;
  }

  virtual void reset () = 0;

protected:
  virtual std::uint8_t _encrypt_byte (std::uint8_t) = 0;
  virtual std::uint8_t _decrypt_byte (std::uint8_t) = 0;
};

#endif
