// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "api_filesystem_iso.h"
#include "api_datetime.h"
#include <mobius/filesystem/filesystem_iso.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief api_filesystem_iso: tp_new
//! \param type type object
//! \param args argument list
//! \param kwds keywords dict
//! \return new api.filesystem_iso object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_tp_new (PyTypeObject *type, PyObject *args, PyObject *)
{
  // if (!PyArg_ParseTuple (args, "|s", &arg_uri))
  //   return nulptr;

  api_filesystem_iso_o *self = (api_filesystem_iso_o *) type->tp_alloc (type, 0);
  if (self)
    {
  //  try
  //    {
  //      if (arg_uri)
  //        self->obj = new mobius::filesystem::filesystem_iso (arg_uri);
  //      else
  //        self->obj = new mobius::filesystem::filesystem_iso ();
  //    }
  //  catch (const std::runtime_error& e)
  //    {
  //      Py_DECREF (self);
  //      PyErr_SetString (PyExc_IOError, e.what ());
  //      self = nulptr;
  //    }
    }

  return (PyObject *) self;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_filesystem_iso_tp_dealloc (api_filesystem_iso_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_offset (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_size (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_name (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: fs_type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_fs_type (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_fs_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_descr_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_descr_version (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_descr_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: system_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_system_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_system_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_volume_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_space_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_space_size (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_space_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_set_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_set_size (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_set_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_sequence_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_sequence_number (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_sequence_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: logical_block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_logical_block_size (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_logical_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: path_table_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_path_table_size (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_path_table_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: type_l_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_type_l_path_table (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_l_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: type_l_optional_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_type_l_optional_path_table (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_l_optional_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: type_m_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_type_m_path_table (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_m_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: type_m_optional_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_type_m_optional_path_table (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_m_optional_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: volume_set_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_volume_set_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_volume_set_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: publisher_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_publisher_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_publisher_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: data_preparer_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_data_preparer_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_data_preparer_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: application_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_application_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_application_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: copyright_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_copyright_file_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_copyright_file_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: abstract_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_abstract_file_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_abstract_file_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: bibliographic_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_bibliographic_file_id (api_filesystem_iso_o *self)
{
  return PyString_FromString (self->obj->get_bibliographic_file_id ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_creation_time (api_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: last_modification_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_last_modification_time (api_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_modification_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: expiration_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_expiration_time (api_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_expiration_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: effective_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_effective_time (api_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_effective_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: file_structure_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_iso_getter_file_structure_version (api_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_file_structure_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_filesystem_iso_getsetters[] =
{
  {
    (char *) "offset",
    (getter) api_filesystem_iso_getter_offset,
    (setter) 0,
    (char *) "offset in bytes", NULL
  },
  {
    (char *) "size",
    (getter) api_filesystem_iso_getter_size,
    (setter) 0,
    (char *) "filesystem size in bytes", NULL
  },
  {
    (char *) "name",
    (getter) api_filesystem_iso_getter_name,
    (setter) 0,
    (char *) "filesystem name", NULL
  },
  {
    (char *) "fs_type",
    (getter) api_filesystem_iso_getter_fs_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "volume_descr_version",
    (getter) api_filesystem_iso_getter_volume_descr_version,
    (setter) 0,
    (char *) "volume description version", NULL
  },
  {
    (char *) "system_id",
    (getter) api_filesystem_iso_getter_system_id,
    (setter) 0,
    (char *) "system identifier", NULL
  },
  {
    (char *) "volume_id",
    (getter) api_filesystem_iso_getter_volume_id,
    (setter) 0,
    (char *) "volume identifier", NULL
  },
  {
    (char *) "volume_space_size",
    (getter) api_filesystem_iso_getter_volume_space_size,
    (setter) 0,
    (char *) "volume space size", NULL
  },
  {
    (char *) "volume_set_size",
    (getter) api_filesystem_iso_getter_volume_set_size,
    (setter) 0,
    (char *) "volume set size", NULL
  },
  {
    (char *) "volume_sequence_number",
    (getter) api_filesystem_iso_getter_volume_sequence_number,
    (setter) 0,
    (char *) "volume sequence number", NULL
  },
  {
    (char *) "logical_block_size",
    (getter) api_filesystem_iso_getter_logical_block_size,
    (setter) 0,
    (char *) "logical block size in bytes", NULL
  },
  {
    (char *) "path_table_size",
    (getter) api_filesystem_iso_getter_path_table_size,
    (setter) 0,
    (char *) "path table size in bytes", NULL
  },
  {
    (char *) "type_l_path_table",
    (getter) api_filesystem_iso_getter_type_l_path_table,
    (setter) 0,
    (char *) "location of type L path table", NULL
  },
  {
    (char *) "type_l_optional_path_table",
    (getter) api_filesystem_iso_getter_type_l_optional_path_table,
    (setter) 0,
    (char *) "location of optional type L path table", NULL
  },
  {
    (char *) "type_m_path_table",
    (getter) api_filesystem_iso_getter_type_m_path_table,
    (setter) 0,
    (char *) "location of type M path table", NULL
  },
  {
    (char *) "type_m_optional_path_table",
    (getter) api_filesystem_iso_getter_type_m_optional_path_table,
    (setter) 0,
    (char *) "location of optional type M path table", NULL
  },
  {
    (char *) "volume_set_id",
    (getter) api_filesystem_iso_getter_volume_set_id,
    (setter) 0,
    (char *) "volume set identifier", NULL
  },
  {
    (char *) "publisher_id",
    (getter) api_filesystem_iso_getter_publisher_id,
    (setter) 0,
    (char *) "publisher identifier", NULL
  },
  {
    (char *) "data_preparer_id",
    (getter) api_filesystem_iso_getter_data_preparer_id,
    (setter) 0,
    (char *) "data preparer identifier", NULL
  },
  {
    (char *) "application_id",
    (getter) api_filesystem_iso_getter_application_id,
    (setter) 0,
    (char *) "application identifier", NULL
  },
  {
    (char *) "copyright_file_id",
    (getter) api_filesystem_iso_getter_copyright_file_id,
    (setter) 0,
    (char *) "copyright file identifier", NULL
  },
  {
    (char *) "abstract_file_id",
    (getter) api_filesystem_iso_getter_abstract_file_id,
    (setter) 0,
    (char *) "abstract file identifier", NULL
  },
  {
    (char *) "bibliographic_file_id",
    (getter) api_filesystem_iso_getter_bibliographic_file_id,
    (setter) 0,
    (char *) "bibliographic file identifier", NULL
  },
  {
    (char *) "creation_time",
    (getter) api_filesystem_iso_getter_creation_time,
    (setter) 0,
    (char *) "volume creation date/time", NULL
  },
  {
    (char *) "last_modification_time",
    (getter) api_filesystem_iso_getter_last_modification_time,
    (setter) 0,
    (char *) "volume last modification date/time", NULL
  },
  {
    (char *) "expiration_time",
    (getter) api_filesystem_iso_getter_expiration_time,
    (setter) 0,
    (char *) "volume expiration date/time", NULL
  },
  {
    (char *) "effective_time",
    (getter) api_filesystem_iso_getter_effective_time,
    (setter) 0,
    (char *) "volume effective date/time", NULL
  },
  {
    (char *) "file_structure_version",
    (getter) api_filesystem_iso_getter_file_structure_version,
    (setter) 0,
    (char *) "file structure version", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_iso: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_filesystem_iso_t =
{
  PyObject_HEAD_INIT (0)
  0,                                         		// ob_size
  "api.filesystem_iso",                      		// tp_name
  sizeof (api_filesystem_iso_o),             		// tp_basicsize
  0,                                         		// tp_itemsize
  (destructor) api_filesystem_iso_tp_dealloc,		// tp_dealloc
  0,                                         		// tp_print
  0,                                         		// tp_getattr
  0,                                         		// tp_setattr
  0,                                         		// tp_compare
  0,                                         		// tp_repr
  0,                                         		// tp_as_number
  0,                                         		// tp_as_sequence
  0,                                         		// tp_as_mapping
  0,                                         		// tp_hash
  0,                                         		// tp_call
  0,                                         		// tp_str
  0,                                         		// tp_getattro
  0,                                         		// tp_setattro
  0,                                         		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,  		// tp_flags
  "filesystem_iso class",                    		// tp_doc
  0,                                         		// tp_traverse
  0,                                         		// tp_clear
  0,                                         		// tp_richcompare
  0,                                         		// tp_weaklistoffset
  0,                                         		// tp_iter
  0,                                         		// tp_iternext
  0,                                         		// tp_methods
  0,                                         		// tp_members
  api_filesystem_iso_getsetters,             		// tp_getset
  0,                                         		// tp_base
  0,                                         		// tp_dict
  0,                                         		// tp_descr_get
  0,                                         		// tp_descr_set
  0,                                         		// tp_dictoffset
  0,                                         		// tp_init
  0,                                         		// tp_alloc
  0                                          		// tp_new
};
