// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.turing module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include <pygil.h>
#include <mobius/crypt/hash_digest.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief hash_digest function
//! \param self Function object
//! \param args Argument list
//! \return Python object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
func_hash_digest (PyObject *, PyObject *args)
{
  // parse input args
  const char *arg_hash_id = nullptr;
  const std::uint8_t *arg_data_buffer = nullptr;
  Py_ssize_t arg_data_size;

  if (!PyArg_ParseTuple (args, "ss#", &arg_hash_id, &arg_data_buffer, &arg_data_size))
    return nullptr;

  mobius::bytearray arg_data (arg_data_buffer, arg_data_size);

  // execute C++ function
  PyObject *ret = nullptr;

  try
    {
      auto digest = mobius::py::GIL () (
		      mobius::crypt::hash_digest (
			      arg_hash_id,
			      arg_data
		      )
		    );
      ret = mobius::py::pybytes_from_bytearray (digest);
    }
  catch (const std::exception& e)
    {
      PyErr_SetString (PyExc_IOError, e.what ());
    }

  // return value
  return ret;
}
