#ifndef MOBIUS_CRYPT_CIPHER_BLOCK_MODE_H
#define MOBIUS_CRYPT_CIPHER_BLOCK_MODE_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block_mode_impl_base.h>
#include <mobius/bytearray.h>
#include <memory>

namespace mobius
{
namespace crypt
{
class cipher_block;

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief cipher_block_mode handle class
//! \author Eduardo Aguiar
//! \see https://en.wikipedia.org/wiki/Block_cipher_mode_of_operation
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_block_mode
{
public:
  // constructors
  cipher_block_mode (cipher_block&, const std::string&, const mobius::bytearray&);
  cipher_block_mode (cipher_block_mode&&) = default;
  cipher_block_mode (const cipher_block_mode&) = default;

  // operators
  cipher_block_mode& operator= (const cipher_block_mode&) = default;
  cipher_block_mode& operator= (cipher_block_mode&&) = default;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief encrypt data
  //! \param data data to be encrypted
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  void
  encrypt (mobius::bytearray& data)
  {
    impl_->encrypt (data);
  }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief decrypt data
  //! \param data data to be decrypted
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  void
  decrypt (mobius::bytearray& data)
  {
    impl_->decrypt (data);
  }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief reset cipher block mode
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  void
  reset ()
  {
    impl_->reset ();
  }

private:
  //! \brief implementation pointer
  std::shared_ptr <cipher_block_mode_impl_base> impl_;
};

} // namespace crypt
} // namespace mobius

#endif
