# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
from . import CXMLElement

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode CQuerySearch structure
# @see QuerySearch.cpp - CQuerySearch::Serialize
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (decoder):
  qs = dataholder ()
  qs.hash_md5 = None
  qs.pxml = None
  qs.want_url = False
  qs.want_dn = False
  qs.want_xml = False
  qs.want_com = False
  qs.want_pfs = False
  qs.min_size = 0
  qs.max_size = -1

  qs.version = decoder.get_int ()
  qs.guid = decoder.get_guid ()
  qs.search_string = decoder.get_string ()
  qs.hash_sha1 = decoder.get_hex_string (20)
  qs.hash_tiger = decoder.get_hex_string (24)
  qs.hash_ed2k = decoder.get_hex_string (16)
  qs.hash_bth = decoder.get_hex_string (20)

  if qs.version >= 7:
    qs.hash_md5 = decoder.get_hex_string (16)

  qs.uri = decoder.get_string ()

  if qs.uri:
    qs.pxml = CXMLElement.decode (decoder)

  if qs.version >= 5:
    qs.want_url = decoder.get_bool ()
    qs.want_dn = decoder.get_bool ()
    qs.want_xml = decoder.get_bool ()
    qs.want_com = decoder.get_bool ()
    qs.want_pfs = decoder.get_bool ()

  if qs.version >= 8:
    qs.min_size = decoder.get_qword ()
    qs.max_size = decoder.get_qword ()

  return qs
