#include <nacre/polynomial.hpp>
#include <nacre/rational.hpp>

int main () {

    unsigned int max_order = 10;

    std::cout << "Chebyshev Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "T_"<< i << " = " <<
        nacre::polynomial::ChebyshevPolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Legendre Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "P_"<< i << " = " <<
        nacre::polynomial::LegendrePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Laguerre Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "L_"<< i << " = " <<
        nacre::polynomial::LaguerrePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    std::cout << "Hermite Polynomials" << std::endl;
    for (size_t i = 0; i <= max_order; i++)
        std::cout << "H_"<< i << " = " <<
        nacre::polynomial::HermitePolynomial<nacre::rational::Rational<int> > (i) << std::endl;
    std::cout << std::endl;

    return 0;
}
