/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file non_static_methods.hpp
 * @date 2007-04-08
 * mpfrcpp::Real non-static methods:
 *     checkRange, getExponent, getMpfrT, getPrecision, setExponent,
 *     setPrecision, setPrecision, setToInfinity, setToNaN, subnormalize.
 * INTERNAL HEADER, NOT TO BE USED DIRECTLY.
 */

#ifndef INCLUDED_BY_MPFRCPP
    #error THIS IS AN INTERNAL HEADER ONLY, NOT TO BE USED DIRECTLY
#endif

#ifndef MPFRCPP_REAL_NON_STATIC_METHODS
#define MPFRCPP_REAL_NON_STATIC_METHODS

namespace mpfrcpp {

    //------------------------------------------------------------

    int Real::checkRange () throw() {
        int r = 0;
        mpfr_check_range( getMpfrT(), r,
                          getParameters().getDefaultRoundMode().getMpfrRndT() );
        return r;
    }

    //------------------------------------------------------------

    Exponent Real::getExponent () const throw() {
        return Exponent ( mpfr_get_exp( getMpfrT() ) );
    }

    //------------------------------------------------------------

    mpfr_t& Real::getMpfrT () throw() {
        return x_;
    }

    const mpfr_t& Real::getMpfrT () const throw() {
        return x_;
    }

    //------------------------------------------------------------

    Precision Real::getPrecision() const throw() {
        return Precision( mpfr_get_prec( getMpfrT() ) );
    }

    //------------------------------------------------------------

    void Real::setExponent ( const Exponent& e ) throw() {
        mpfr_set_exp( getMpfrT(), e.getMpExpT() );
    }

    //------------------------------------------------------------

    void Real::setPrecision( const Precision& p ) throw() {
        mpfr_set_prec( getMpfrT(), p.getMpfrPrecT() );
    }

    void Real::setPrecision( mpfr_prec_t p ) throw() {
        mpfr_set_prec( getMpfrT(), p );
    }

    //------------------------------------------------------------

    void Real::setToInfinity ( const int sign ) throw() {
        mpfr_set_inf( getMpfrT(), sign );
    }

    //------------------------------------------------------------

    void Real::setToNaN () throw() {
        mpfr_set_nan( getMpfrT() );
    }

    //------------------------------------------------------------

    void Real::subnormalize ( const Precision& p,
                              const RoundMode& rm ) throw() {
        mpfr_subnormalize ( getMpfrT(), p.getMpfrPrecT(), rm.getMpfrRndT() );
    }

    //------------------------------------------------------------

} // namespace mpfrcpp

#endif    // MPFRCPP_REAL_NON_STATIC_METHODS
